/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.settle.controller.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outrmat.settle.service.IOutRmatSettleService;
import com.ejianc.business.outrmat.settle.vo.OutRmatAccReciReportVO;
import com.ejianc.business.procost.api.ICostSettingApi;
import com.ejianc.business.procost.vo.SettingVO;
import com.ejianc.business.proequipmentcorpout.util.DateUtil;
import com.ejianc.business.profinance.api.IReceiptAndPaymentRegisterApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outRmat/accReciReport"})
public class OutRmatAccReceivableReportController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostSettingApi costSettingApi;
    @Autowired
    private IReceiptAndPaymentRegisterApi receiptAndPaymentRegisterApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOutRmatSettleService service;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    private void getQueryRange(Map<String, Object> paramMap, Map<String, Parameter> parameterMap) throws ParseException {
        CommonResponse settingResp = this.costSettingApi.getSettingInfo(InvocationInfoProxy.getOrgId());
        if (!settingResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u6210\u672c\u671f\u95f4\u8bbe\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        SettingVO setting = (SettingVO)settingResp.getData();
        if (null == setting) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u8fdb\u884c\u6210\u672c\u5176\u95f4\u8bbe\u7f6e\uff01");
        }
        String startDate = parameterMap.get("startDate").getValue().toString();
        String endDate = parameterMap.get("endDate").getValue().toString();
        if ("0".equals(setting.getPeriodRule())) {
            int maxDaysOfEndDate = DateUtil.getDaysOfMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM", (String)endDate));
            int maxDaysOfStartDate = DateUtil.getDaysOfMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM", (String)startDate));
            endDate = endDate + "-" + (maxDaysOfEndDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfEndDate);
            startDate = startDate + "-" + (maxDaysOfStartDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfStartDate);
            startDate = DateUtil.addDay((Date)DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)DateUtil.getLastMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)startDate), (String)"yyyy-MM-dd")), (int)1);
            paramMap.put("curStartDate", startDate);
            paramMap.put("curEndDate", endDate);
            paramMap.put("curYear", endDate.substring(0, 4));
            paramMap.put("lastYearStartDate", DateUtil.addDay((Date)DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)DateUtil.getLastMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)(Integer.valueOf(endDate.substring(0, 4)) - 1 + "-01-" + setting.getEndDay())), (String)"yyyy-MM-dd")), (int)1));
            paramMap.put("lastYearEndDate", Integer.valueOf(endDate.substring(0, 4)) - 1 + "-12-" + setting.getEndDay());
        } else {
            startDate = startDate + "-01";
            endDate = endDate + "-" + DateUtil.getDaysOfMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM", (String)endDate));
            paramMap.put("curStartDate", startDate);
            paramMap.put("curEndDate", endDate);
            parameterMap.remove("startDate");
            parameterMap.remove("endDate");
            paramMap.put("curYear", endDate.substring(0, 4));
            paramMap.put("lastYearStartDate", Integer.valueOf(endDate.substring(0, 4)) - 1 + "-01-01");
            paramMap.put("lastYearEndDate", Integer.valueOf(endDate.substring(0, 4)) - 1 + "-12-31");
        }
        CommonResponse orgResp = this.orgApi.findChildrenByParentIdWithoutProjectDept(Long.valueOf(parameterMap.get("orgId").getValue().toString()));
        if (!orgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u672c\u4e0b\u4fe1\u606f\u5931\u8d25\uff01");
        }
        paramMap.put("orgIds", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
    }

    private void caculate(List<Map<String, Object>> payInfoList, Map<Long, OutRmatAccReciReportVO> conIdMap, String groupField) {
        payInfoList.parallelStream().forEach(payInfo -> {
            OutRmatAccReciReportVO tmp = (OutRmatAccReciReportVO)conIdMap.get(Long.valueOf(payInfo.get(groupField).toString()));
            tmp.setCurRegisterMny(null != payInfo.get("curPaidMny") ? new BigDecimal(payInfo.get("curPaidMny").toString()) : BigDecimal.ZERO);
            tmp.setTotalRegisterMnyLastYear(null != payInfo.get("totalPaidMnyLastYear") ? new BigDecimal(payInfo.get("totalPaidMnyLastYear").toString()) : BigDecimal.ZERO);
            tmp.setTotalStartRegisterMny(null != payInfo.get("totalStartPaidMny") ? new BigDecimal(payInfo.get("totalStartPaidMny").toString()) : BigDecimal.ZERO);
            tmp.setTotalRegisterMnyThisYear(null != payInfo.get("totalRegisterMnyThisYear") ? new BigDecimal(payInfo.get("totalRegisterMnyThisYear").toString()) : BigDecimal.ZERO);
            tmp.setRegisterScale(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)tmp.getTotalStartRegisterMny(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)tmp.getTotalStartRegisterMny(), (BigDecimal)tmp.getTotalStartAllotTaxMny())), (BigDecimal)new BigDecimal("100")));
            tmp.setOverRegisterMny(ComputeUtil.safeSub((BigDecimal)tmp.getContractTaxMny(), (BigDecimal)tmp.getTotalStartRegisterMny()));
            tmp.setSettleOverRegisterMnyLastYear(ComputeUtil.safeSub((BigDecimal)tmp.getTotalSettleTaxMnyLastYear(), (BigDecimal)tmp.getTotalRegisterMnyLastYear()));
            tmp.setTotalOverMny(ComputeUtil.safeSub((BigDecimal)tmp.getTotalOverMny(), (BigDecimal)tmp.getTotalStartRegisterMny()));
            tmp.setCurOverMny(ComputeUtil.safeSub((BigDecimal)tmp.getCurOverMny(), (BigDecimal)tmp.getCurRegisterMny()));
            tmp.setLastTotalOverMny(ComputeUtil.safeSub((BigDecimal)tmp.getTotalOverMny(), (BigDecimal)tmp.getCurOverMny()));
        });
    }

    @PostMapping(value={"pageList"})
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) throws ParseException {
        JSONObject resp = new JSONObject();
        Map parameterMap = queryParam.getParams();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (null == parameterMap.get("orgId") || null == parameterMap.get("startDate") || null == parameterMap.get("endDate")) {
            return CommonResponse.error((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u8303\u56f4\u53c2\u6570\uff01");
        }
        String rentType = ((Parameter)parameterMap.get("rentType")).getValue().toString();
        paramMap.put("rentType", rentType);
        this.getQueryRange(paramMap, parameterMap);
        Map<String, Object> totalInfo = this.service.countAccRecei(paramMap);
        if (Integer.valueOf(totalInfo.get("total").toString()) == 0) {
            resp.put("total", (Object)0);
            resp.put("records", new ArrayList());
            resp.put("current", (Object)queryParam.getPageIndex());
            resp.put("size", (Object)queryParam.getPageSize());
            resp.put("pages", (Object)0);
            return CommonResponse.success((Object)resp);
        }
        Page page = new Page();
        page.setTotal(Long.valueOf(totalInfo.get("total").toString()).longValue());
        page.setSize((long)queryParam.getPageSize());
        page.setCurrent((long)queryParam.getPageIndex());
        resp = (JSONObject)BeanMapper.map((Object)page, JSONObject.class);
        paramMap.put("pageSize", queryParam.getPageSize());
        paramMap.put("startLine", queryParam.getPageIndex() - 1 < 0 ? 0 : (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        this.logger.info("\u5408\u540c\u7ed3\u7b97\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(paramMap));
        List<OutRmatAccReciReportVO> rsList = this.service.accReceiPageList(paramMap);
        HashMap<Long, OutRmatAccReciReportVO> conIdMap = new HashMap<Long, OutRmatAccReciReportVO>();
        ArrayList contractIds = new ArrayList();
        rsList.forEach(item -> {
            if (rentType.equals("0")) {
                conIdMap.put(item.getSupplierId(), (OutRmatAccReciReportVO)item);
            } else {
                conIdMap.put(item.getProjectId(), (OutRmatAccReciReportVO)item);
            }
            contractIds.addAll(Arrays.stream(item.getContractIds().split(",")).map(conId -> Long.valueOf(conId)).collect(Collectors.toList()));
        });
        paramMap.put("contractIds", conIdMap.keySet());
        CommonResponse payInfoResp = null;
        HashMap<String, Object> queryPayInfoParam = new HashMap<String, Object>();
        queryPayInfoParam.putAll(paramMap);
        queryPayInfoParam.remove("orgIds");
        String groupField = null;
        if (rentType.equals("0")) {
            queryPayInfoParam.put("groupByFields", "supplier_id");
            this.logger.info("\u5408\u540c\u6536\u6b3e\u4fe1\u606f\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(queryPayInfoParam));
            payInfoResp = this.receiptAndPaymentRegisterApi.queryContractRecInfo(JSONObject.parseObject((String)JSONObject.toJSONString(queryPayInfoParam)));
            this.logger.info("\u5408\u540c\u6536\u6b3e\u4fe1\u606f\u67e5\u8be2\uff1a{}", (Object)JSONObject.toJSONString((Object)payInfoResp));
            if (!payInfoResp.isSuccess()) {
                return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u6536\u6b3e\u767b\u8bb0\u4fe1\u606f\u5931\u8d25\uff01");
            }
            groupField = "supplierId";
        } else {
            queryPayInfoParam.put("groupByFields", "project_id");
            payInfoResp = this.receiptAndPaymentRegisterApi.getContractPayInfo(JSONObject.toJSONString(queryPayInfoParam));
            if (!payInfoResp.isSuccess()) {
                return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u4ed8\u6b3e\u767b\u8bb0\u4fe1\u606f\u5931\u8d25\uff01");
            }
            groupField = "projectId";
            this.fillProjectInfo(conIdMap);
        }
        if (null != payInfoResp.getData() && CollectionUtils.isNotEmpty((Collection)((Collection)payInfoResp.getData()))) {
            this.caculate((List)payInfoResp.getData(), conIdMap, groupField);
        }
        resp.put("records", rsList);
        return CommonResponse.success((Object)resp);
    }

    private String getProjectStateName(String projectState) {
        switch (projectState) {
            case "1": {
                return "\u5728\u5efa";
            }
            case "2": {
                return "\u9879\u76ee\u4e2d\u6b62";
            }
            case "3": {
                return "\u7ae3\u5de5";
            }
            case "4": {
                return "\u4fdd\u4fee";
            }
        }
        return projectState;
    }

    private void fillProjectInfo(Map<Long, OutRmatAccReciReportVO> conIdMap) {
        CommonResponse prjResp = this.projectPoolApi.queryProjectByIds(new ArrayList<Long>(conIdMap.keySet()));
        if (!prjResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)prjResp));
        } else if (!((JSONArray)prjResp.getData()).isEmpty()) {
            List poolList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)prjResp.getData()), ProjectPoolSetVO.class);
            poolList.parallelStream().forEach(item -> {
                OutRmatAccReciReportVO tmp = (OutRmatAccReciReportVO)conIdMap.get(item.getId());
                tmp.setProjectCode(item.getCode());
                tmp.setProjectName(item.getName());
                tmp.setProjectStateName(this.getProjectStateName(item.getProjectStatus()));
            });
        }
    }

    @PostMapping(value={"export"})
    public void pageList(@RequestBody QueryParam queryParam, HttpServletResponse response) throws ParseException {
        Map parameterMap = queryParam.getParams();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (null == parameterMap.get("orgId") || null == parameterMap.get("startDate") || null == parameterMap.get("endDate")) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u67e5\u8be2\u8303\u56f4\u53c2\u6570\uff01");
        }
        this.getQueryRange(paramMap, parameterMap);
        String rentType = ((Parameter)parameterMap.get("rentType")).getValue().toString();
        paramMap.put("rentType", rentType);
        this.logger.info("\u5408\u540c\u7ed3\u7b97\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(paramMap));
        List<OutRmatAccReciReportVO> rsList = this.service.accReceiPageList(paramMap);
        if (CollectionUtils.isNotEmpty(rsList)) {
            ArrayList contractIds = new ArrayList();
            HashMap<Long, OutRmatAccReciReportVO> conIdMap = new HashMap<Long, OutRmatAccReciReportVO>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            rsList.forEach(item -> {
                if (rentType.equals("0")) {
                    conIdMap.put(item.getSupplierId(), (OutRmatAccReciReportVO)item);
                } else {
                    conIdMap.put(item.getProjectId(), (OutRmatAccReciReportVO)item);
                }
                item.setBaseSignDateStr(sdf.format(item.getBaseSignDate()));
                contractIds.addAll(Arrays.stream(item.getContractIds().split(",")).map(conId -> Long.valueOf(conId)).collect(Collectors.toList()));
            });
            paramMap.put("contractIds", conIdMap.keySet());
            CommonResponse payInfoResp = null;
            HashMap<String, Object> queryPayInfoParam = new HashMap<String, Object>();
            queryPayInfoParam.putAll(paramMap);
            queryPayInfoParam.remove("orgIds");
            String groupField = null;
            if (rentType.equals("0")) {
                queryPayInfoParam.put("groupByFields", "supplier_id");
                payInfoResp = this.receiptAndPaymentRegisterApi.queryContractRecInfo(JSONObject.parseObject((String)JSONObject.toJSONString(queryPayInfoParam)));
                if (!payInfoResp.isSuccess()) {
                    throw new BusinessException("\u83b7\u53d6\u5408\u540c\u6536\u6b3e\u767b\u8bb0\u4fe1\u606f\u5931\u8d25\uff01");
                }
                groupField = "supplierId";
            } else {
                queryPayInfoParam.put("groupByFields", "project_id");
                payInfoResp = this.receiptAndPaymentRegisterApi.getContractPayInfo(JSONObject.toJSONString(queryPayInfoParam));
                if (!payInfoResp.isSuccess()) {
                    throw new BusinessException("\u83b7\u53d6\u5408\u540c\u4ed8\u6b3e\u767b\u8bb0\u4fe1\u606f\u5931\u8d25\uff01");
                }
                groupField = "projectId";
                this.fillProjectInfo(conIdMap);
            }
            if (null != payInfoResp.getData() && CollectionUtils.isNotEmpty((Collection)((Collection)payInfoResp.getData()))) {
                this.caculate((List)payInfoResp.getData(), conIdMap, groupField);
            }
        }
        HashMap<String, List<OutRmatAccReciReportVO>> records = new HashMap<String, List<OutRmatAccReciReportVO>>();
        records.put("records", rsList);
        ExcelExport.getInstance().exportWithTrans(rentType.equals("1") ? "OutRentInnerAccReceReport-export.xlsx" : "OutRentOuterAccReceReport-export.xlsx", records, response);
    }
}

