package com.ejianc.business.outrmat.settle.controller.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outrmat.settle.service.IOutRmatSettleService;
import com.ejianc.business.outrmat.settle.vo.OutRmatAccReciReportVO;
import com.ejianc.business.procost.api.ICostSettingApi;
import com.ejianc.business.procost.vo.SettingVO;
import com.ejianc.business.proequipmentcorpout.util.DateUtil;
import com.ejianc.business.profinance.api.IReceiptAndPaymentRegisterApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 辅料中心外租应收款期间报表
 *
 * @author CJ
 * @Description:
 * @date 2023/4/23 19:12
 */
@RestController
@RequestMapping(value = "/outRmat/accReciReport")
public class OutRmatAccReceivableReportController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostSettingApi costSettingApi;
    @Autowired
    private IReceiptAndPaymentRegisterApi receiptAndPaymentRegisterApi;
    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IOutRmatSettleService service;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    private void getQueryRange(Map<String, Object> paramMap, Map<String, Parameter> parameterMap) throws ParseException {
        //查询成本期间设置信息
        CommonResponse<SettingVO> settingResp = costSettingApi.getSettingInfo(InvocationInfoProxy.getOrgId());
        if(!settingResp.isSuccess()) {
            throw new BusinessException("查询失败，获取成本期间设置信息失败！");
        }
        SettingVO setting = settingResp.getData();
        if(null == setting) {
            throw new BusinessException("查询失败，当前组织未设置进行成本其间设置！");
        }

        String startDate = parameterMap.get("startDate").getValue().toString();
        String endDate = parameterMap.get("endDate").getValue().toString();

        //根据成本期间设置信息拼接查询日期范围
        if("0".equals(setting.getPeriodRule())) {
            int maxDaysOfEndDate = DateUtil.getDaysOfMonth(DateFormatUtil.parseDate("yyyy-MM", endDate));
            int maxDaysOfStartDate = DateUtil.getDaysOfMonth(DateFormatUtil.parseDate("yyyy-MM", startDate));
            endDate += "-" + (maxDaysOfEndDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfEndDate);
            startDate += "-" + (maxDaysOfStartDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfStartDate);
            startDate = DateUtil.addDay(DateFormatUtil.parseDate("yyyy-MM-dd", DateUtil.getLastMonth(DateFormatUtil.parseDate("yyyy-MM-dd", startDate), "yyyy-MM-dd")),1);
            //固定日期
            paramMap.put("curStartDate", startDate);
            paramMap.put("curEndDate", endDate);

            paramMap.put("curYear", endDate.substring(0,4));
            //计算去年结算开始日期，取去年第一个月的结束日期的前一个月再加一天的日期
            paramMap.put("lastYearStartDate", DateUtil.addDay(
                    DateFormatUtil.parseDate("yyyy-MM-dd",
                            DateUtil.getLastMonth(
                                    DateFormatUtil.parseDate("yyyy-MM-dd",
                                            Integer.valueOf(endDate.substring(0,4)) - 1 + "-01-" + setting.getEndDay()),
                                    "yyyy-MM-dd")
                    ),1));
            //计算去年结算结束日期
            paramMap.put("lastYearEndDate", Integer.valueOf(endDate.substring(0,4)) - 1 + "-12-" + setting.getEndDay());
        } else {
            //自然月
            startDate += "-01";
            endDate += "-" + DateUtil.getDaysOfMonth(DateFormatUtil.parseDate("yyyy-MM", endDate));
            paramMap.put("curStartDate", startDate);
            paramMap.put("curEndDate", endDate);

            parameterMap.remove("startDate");
            parameterMap.remove("endDate");

            paramMap.put("curYear", endDate.substring(0,4));
            //计算去年结算开始日期
            paramMap.put("lastYearStartDate", Integer.valueOf(endDate.substring(0,4)) - 1 + "-01-01");
            //计算去年结算结束日期
            paramMap.put("lastYearEndDate", Integer.valueOf(endDate.substring(0,4)) - 1 + "-12-31");
        }

        CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentIdWithoutProjectDept(Long.valueOf(parameterMap.get("orgId").getValue().toString()));
        if(!orgResp.isSuccess()) {
            throw new BusinessException("查询失败，获取组织本下信息失败！");
        }
        //根据组织过滤
        paramMap.put("orgIds", orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
    }

    private void caculate(List<Map<String, Object>> payInfoList, Map<Long, OutRmatAccReciReportVO> conIdMap, String groupField) {
        payInfoList.parallelStream().forEach(payInfo -> {
            OutRmatAccReciReportVO tmp = conIdMap.get(Long.valueOf(payInfo.get(groupField).toString()));
            tmp.setCurRegisterMny(null != payInfo.get("curPaidMny") ? new BigDecimal(payInfo.get("curPaidMny").toString()) : BigDecimal.ZERO);
            tmp.setTotalRegisterMnyLastYear(null != payInfo.get("totalPaidMnyLastYear") ? new BigDecimal(payInfo.get("totalPaidMnyLastYear").toString()) : BigDecimal.ZERO);
            tmp.setTotalStartRegisterMny(null != payInfo.get("totalStartPaidMny") ? new BigDecimal(payInfo.get("totalStartPaidMny").toString()) : BigDecimal.ZERO);
            tmp.setTotalRegisterMnyThisYear(null != payInfo.get("totalRegisterMnyThisYear") ? new BigDecimal(payInfo.get("totalRegisterMnyThisYear").toString()) : BigDecimal.ZERO);
            //计算
            //合同付款比例  开工累计付款金额/合同金额*100%
            tmp.setRegisterScale(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(tmp.getTotalStartRegisterMny(), ComputeUtil.safeAdd(tmp.getTotalStartRegisterMny(), tmp.getTotalStartAllotTaxMny())), new BigDecimal("100")));
            //合同欠付金额  合同金额-开工累计付款金额
            tmp.setOverRegisterMny(ComputeUtil.safeSub(tmp.getContractTaxMny(), tmp.getTotalStartRegisterMny()));
            //上年结算累计欠付款：取期间结束年，该合同的查询年份的上一年结算金额-付款金额
            tmp.setSettleOverRegisterMnyLastYear(ComputeUtil.safeSub(tmp.getTotalSettleTaxMnyLastYear(), tmp.getTotalRegisterMnyLastYear()));

            //累计欠款合计：开累结算 - 开累收款
            tmp.setTotalOverMny(ComputeUtil.safeSub(tmp.getTotalOverMny(), tmp.getTotalStartRegisterMny()));
            //本期欠款：本期结算 - 本期收款
            tmp.setCurOverMny(ComputeUtil.safeSub(tmp.getCurOverMny(), tmp.getCurRegisterMny()));
            //截至上期累计欠款： 累计欠款 - 本期欠款
            tmp.setLastTotalOverMny(ComputeUtil.safeSub(tmp.getTotalOverMny(), tmp.getCurOverMny()));
        });
    }

    /**
     * 辅料中心周转材租出合同结算报表
     *
     * @param queryParam
     * @return
     * @throws ParseException
     */
    @PostMapping(value = "pageList")

    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) throws ParseException {
        JSONObject resp = new JSONObject();
        Map<String, Parameter> parameterMap = queryParam.getParams();
        Map<String, Object> paramMap = new HashMap<>();
        if(null == parameterMap.get("orgId") || null == parameterMap.get("startDate") || null == parameterMap.get("endDate")) {
            return CommonResponse.error("请选择查询范围参数！");
        }
        String rentType = parameterMap.get("rentType").getValue().toString();
        paramMap.put("rentType", rentType);
        getQueryRange(paramMap, parameterMap);

        Map<String, Object> totalInfo = service.countAccRecei(paramMap);
        if(Integer.valueOf(totalInfo.get("total").toString()) == 0) {
            resp.put("total", 0);
            resp.put("records", new ArrayList<>());
            resp.put("current", queryParam.getPageIndex());
            resp.put("size", queryParam.getPageSize());
            resp.put("pages", 0);
            return CommonResponse.success(resp);
        }

        IPage<OutRmatAccReciReportVO> page = new Page<>();
        page.setTotal(Long.valueOf(totalInfo.get("total").toString()));
        page.setSize(queryParam.getPageSize());
        page.setCurrent(queryParam.getPageIndex());
        resp = BeanMapper.map(page, JSONObject.class);
        paramMap.put("pageSize", queryParam.getPageSize());
        paramMap.put("startLine", queryParam.getPageIndex() - 1 < 0 ? 0 : (queryParam.getPageIndex() - 1) * queryParam.getPageSize());

        logger.info("合同结算查询参数：{}", JSONObject.toJSONString(paramMap));
        List<OutRmatAccReciReportVO> rsList = service.accReceiPageList(paramMap);
        Map<Long, OutRmatAccReciReportVO> conIdMap = new HashMap<>();
        List<Long> contractIds = new ArrayList<>();
        rsList.forEach(item -> {
            if(rentType.equals("0")) {
                conIdMap.put(item.getSupplierId(), item);
            } else {
                conIdMap.put(item.getProjectId(), item);
            }
            contractIds.addAll(Arrays.stream(item.getContractIds().split(",")).map(conId -> Long.valueOf(conId)).collect(Collectors.toList()));
        });

        paramMap.put("contractIds", contractIds);

        //查询合同付款登记信息
        CommonResponse<List<Map<String, Object>>> payInfoResp = null;
        Map<String, Object> queryPayInfoParam = new HashMap<>();
        queryPayInfoParam.putAll(paramMap);
        queryPayInfoParam.remove("orgIds");
        String groupField = null;
        if(rentType.equals("0")) {
            queryPayInfoParam.put("groupByFields", "supplier_id");
            logger.info("合同收款信息查询参数：{}", JSONObject.toJSONString(queryPayInfoParam));
            payInfoResp = receiptAndPaymentRegisterApi.queryContractRecInfo(JSONObject.parseObject(JSONObject.toJSONString(queryPayInfoParam)));
            if(!payInfoResp.isSuccess()) {
                return CommonResponse.error("获取合同收款登记信息失败！");
            }
            groupField = "supplierId";
        } else {
            queryPayInfoParam.put("groupByFields", "project_id");
            payInfoResp = receiptAndPaymentRegisterApi.getContractPayInfo(JSONObject.toJSONString(queryPayInfoParam));
            if(!payInfoResp.isSuccess()) {
                return CommonResponse.error("获取合同付款登记信息失败！");
            }

            groupField = "projectId";
            //查询项目信息
            fillProjectInfo(conIdMap);
        }

        if(null != payInfoResp.getData() && CollectionUtils.isNotEmpty(payInfoResp.getData())) {
            caculate(payInfoResp.getData(), conIdMap, groupField);
        }

        resp.put("records", rsList);

        return CommonResponse.success(resp);
    }

    private String getProjectStateName(String projectState) {
        switch (projectState) {
            case "1":
                return  "在建";
            case "2":
                return  "项目中止";
            case "3":
                return  "竣工";
            case "4":
                return  "保修";
            default:
                return projectState;
        }
    }

    private void fillProjectInfo( Map<Long, OutRmatAccReciReportVO> conIdMap) {
        CommonResponse<JSONArray> prjResp = projectPoolApi.queryProjectByIds(new ArrayList<>(conIdMap.keySet()));
        if(!prjResp.isSuccess()) {
            logger.error("查询项目信息失败，{}", JSONObject.toJSONString(prjResp));
        } else {
            if(!prjResp.getData().isEmpty()) {
                List<ProjectPoolSetVO> poolList = JSONArray.parseArray(JSONObject.toJSONString(prjResp.getData()), ProjectPoolSetVO.class);
                poolList.parallelStream().forEach(item -> {
                    OutRmatAccReciReportVO tmp =  conIdMap.get(item.getId());
                    tmp.setProjectCode(item.getCode());
                    tmp.setProjectName(item.getName());
                    tmp.setProjectStateName(getProjectStateName(item.getProjectStatus()));
                });
            }
        }

    }

    @PostMapping(value = "export")
    public void pageList(@RequestBody QueryParam queryParam, HttpServletResponse response) throws ParseException {
        Map<String, Parameter> parameterMap = queryParam.getParams();
        Map<String, Object> paramMap = new HashMap<>();
        if(null == parameterMap.get("orgId") || null == parameterMap.get("startDate") || null == parameterMap.get("endDate")) {
            throw new BusinessException("请选择查询范围参数！");
        }

        getQueryRange(paramMap, parameterMap);
        String rentType = parameterMap.get("rentType").getValue().toString();
        paramMap.put("rentType", rentType);

        logger.info("合同结算查询参数：{}", JSONObject.toJSONString(paramMap));
        List<OutRmatAccReciReportVO> rsList = service.accReceiPageList(paramMap);

        if(CollectionUtils.isNotEmpty(rsList)) {
            List<Long> contractIds = new ArrayList<>();
            Map<Long, OutRmatAccReciReportVO> conIdMap = new HashMap<>();

            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            rsList.forEach(item -> {
                if(rentType.equals("0")) {
                    conIdMap.put(item.getSupplierId(), item);
                } else {
                    conIdMap.put(item.getProjectId(), item);
                }
                item.setBaseSignDateStr(sdf.format(item.getBaseSignDate()));
                contractIds.addAll(Arrays.stream(item.getContractIds().split(",")).map(conId -> Long.valueOf(conId)).collect(Collectors.toList()));
            });

            paramMap.put("contractIds", contractIds);

            //查询合同付款登记信息
            CommonResponse<List<Map<String, Object>>> payInfoResp = null;
            Map<String, Object> queryPayInfoParam = new HashMap<>();
            queryPayInfoParam.putAll(paramMap);
            queryPayInfoParam.remove("orgIds");
            String groupField = null;
            if(rentType.equals("0")) {
                queryPayInfoParam.put("groupByFields", "supplier_id");
                payInfoResp = receiptAndPaymentRegisterApi.queryContractRecInfo(JSONObject.parseObject(JSONObject.toJSONString(queryPayInfoParam)));
                if(!payInfoResp.isSuccess()) {
                    throw new BusinessException("获取合同收款登记信息失败！");
                }
                groupField = "supplierId";
            } else {
                queryPayInfoParam.put("groupByFields", "project_id");
                payInfoResp = receiptAndPaymentRegisterApi.getContractPayInfo(JSONObject.toJSONString(queryPayInfoParam));
                if(!payInfoResp.isSuccess()) {
                    throw new BusinessException("获取合同付款登记信息失败！");
                }

                groupField = "projectId";
                //查询项目信息
                fillProjectInfo(conIdMap);
            }

            if(null != payInfoResp.getData() && CollectionUtils.isNotEmpty(payInfoResp.getData())) {
                caculate(payInfoResp.getData(), conIdMap, groupField);
            }
        }

        Map<String, Object> records = new HashMap<>();
        records.put("records", rsList);
        ExcelExport.getInstance().exportWithTrans(rentType.equals("1") ? "OutRentInnerAccReceReport-export.xlsx" : "OutRentOuterAccReceReport-export.xlsx", records, response);
    }

}
