/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractFileService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outRmatContractFileUpdate/"})
public class OutRmatContractFileController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutRmatContractService contractService;
    @Autowired
    private IOutRmatContractFileService service;

    @PostMapping(value={"updateFileInfo"})
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();
        this.logger.info("-----\u5408\u540c\u9644\u4ef6\u4fe1\u606f\u66f4\u65b0------\uff1a{}", (Object)updateData);
        OutRmatContractEntity contract = (OutRmatContractEntity)((Object)this.contractService.selectById(updateData.getLong("billId")));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFileHighlightId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        contract.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));
        contract.setContractFileSyncFlag(true);
        this.contractService.saveOrUpdate((Object)contract, false);
        resp.put("message", (Object)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
        resp.put("billData", (Object)contract);
        return CommonResponse.success((String)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"getBillDataJson"})
    public CommonResponse<OutRmatContractVO> getBillDataJson(@RequestParam Long id) {
        this.logger.info("-----\u67e5\u8be2\u5408\u540c\u5b50\u8868\u5408\u5e76-----\u5408\u540cid\uff1a{}", (Object)id);
        OutRmatContractEntity contract = (OutRmatContractEntity)((Object)this.contractService.selectById(id));
        OutRmatContractVO vo = (OutRmatContractVO)BeanMapper.map((Object)((Object)contract), OutRmatContractVO.class);
        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,##0.00");
        if (CollectionUtils.isNotEmpty((Collection)vo.getDailyRentList())) {
            vo.getDailyRentList().forEach(item -> {
                item.setCountStr(null != item.getCount() ? priceFmt.format(item.getCount()) : priceFmt.format(BigDecimal.ZERO));
                item.setUnitPriceStr(null != item.getUnitPrice() ? priceFmt.format(item.getUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setUnitTaxPriceStr(null != item.getUnitTaxPrice() ? priceFmt.format(item.getUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setLoseUnitPriceStr(null != item.getLoseUnitPrice() ? priceFmt.format(item.getLoseUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setLoseUnitTaxPriceStr(null != item.getLoseUnitTaxPrice() ? priceFmt.format(item.getLoseUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setStopUnitPriceStr(null != item.getStopUnitPrice() ? priceFmt.format(item.getStopUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setStopUnitTaxPriceStr(null != item.getStopUnitTaxPrice() ? priceFmt.format(item.getStopUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setSurplusCountStr(null != item.getSurplusCount() ? priceFmt.format(item.getSurplusCount()) : priceFmt.format(BigDecimal.ZERO));
                item.setTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentMnyStr(null != item.getRentMny() ? mnyFmt.format(item.getRentMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentTaxMnyStr(null != item.getRentTaxMny() ? mnyFmt.format(item.getRentTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentTaxStr(null != item.getRentTax() ? mnyFmt.format(item.getRentTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setStartDateStr(null != item.getStartDate() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)item.getStartDate()) : "");
                item.setEndDateStr(null != item.getEndDate() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)item.getEndDate()) : "");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getMonthRentList())) {
            vo.getMonthRentList().forEach(item -> {
                item.setCountStr(null != item.getCount() ? priceFmt.format(item.getCount()) : priceFmt.format(BigDecimal.ZERO));
                item.setUnitPriceStr(null != item.getUnitPrice() ? priceFmt.format(item.getUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setUnitTaxPriceStr(null != item.getUnitTaxPrice() ? priceFmt.format(item.getUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setLoseUnitPriceStr(null != item.getLoseUnitPrice() ? priceFmt.format(item.getLoseUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setLoseUnitTaxPriceStr(null != item.getLoseUnitTaxPrice() ? priceFmt.format(item.getLoseUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setStopUnitPriceStr(null != item.getStopUnitPrice() ? priceFmt.format(item.getStopUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setStopUnitTaxPriceStr(null != item.getStopUnitTaxPrice() ? priceFmt.format(item.getStopUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setSurplusCountStr(null != item.getSurplusCount() ? priceFmt.format(item.getSurplusCount()) : priceFmt.format(BigDecimal.ZERO));
                item.setLackMonthDayUnitPriceStr(null != item.getLackMonthDayUnitPrice() ? priceFmt.format(item.getLackMonthDayUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setLackMonthDayUnitTaxPriceStr(null != item.getLackMonthDayUnitTaxPrice() ? priceFmt.format(item.getLackMonthDayUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentMnyStr(null != item.getRentMny() ? mnyFmt.format(item.getRentMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentTaxMnyStr(null != item.getRentTaxMny() ? mnyFmt.format(item.getRentTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentTaxStr(null != item.getRentTax() ? mnyFmt.format(item.getRentTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setStartDateStr(null != item.getStartDate() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)item.getStartDate()) : "");
                item.setEndDateStr(null != item.getEndDate() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)item.getEndDate()) : "");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getNumRentList())) {
            vo.getNumRentList().forEach(item -> {
                item.setCountStr(null != item.getCount() ? priceFmt.format(item.getCount()) : priceFmt.format(BigDecimal.ZERO));
                item.setUnitPriceStr(null != item.getUnitPrice() ? priceFmt.format(item.getUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setUnitTaxPriceStr(null != item.getUnitTaxPrice() ? priceFmt.format(item.getUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setLoseUnitPriceStr(null != item.getLoseUnitPrice() ? priceFmt.format(item.getLoseUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setLoseUnitTaxPriceStr(null != item.getLoseUnitTaxPrice() ? priceFmt.format(item.getLoseUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setSurplusCountStr(null != item.getSurplusCount() ? priceFmt.format(item.getSurplusCount()) : priceFmt.format(BigDecimal.ZERO));
                item.setQuantitiesStr(null != item.getQuantities() ? priceFmt.format(item.getQuantities()) : priceFmt.format(BigDecimal.ZERO));
                item.setTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentMnyStr(null != item.getRentMny() ? mnyFmt.format(item.getRentMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentTaxMnyStr(null != item.getRentTaxMny() ? mnyFmt.format(item.getRentTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentTaxStr(null != item.getRentTax() ? mnyFmt.format(item.getRentTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setStartDateStr(null != item.getStartDate() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)item.getStartDate()) : "");
                item.setEndDateStr(null != item.getEndDate() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)item.getEndDate()) : "");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getOtherList())) {
            vo.getOtherList().forEach(item -> {
                item.setOtherPriceStr(null != item.getUnitPrice() ? priceFmt.format(item.getUnitPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setOtherTaxPriceStr(null != item.getUnitTaxPrice() ? priceFmt.format(item.getUnitTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setOtherMnyStr(null != item.getMny() ? mnyFmt.format(item.getMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setOtherTaxMnyStr(null != item.getTaxMny() ? mnyFmt.format(item.getTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setOtherTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setOtherNumStr(null != item.getCount() ? priceFmt.format(item.getCount()) : priceFmt.format(BigDecimal.ZERO));
                item.setOtherTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getRepairList())) {
            vo.getRepairList().forEach(item -> {
                item.setRepairPriceStr(null != item.getRepairPrice() ? priceFmt.format(item.getRepairPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setRepairTaxPriceStr(null != item.getRepairTaxPrice() ? priceFmt.format(item.getRepairTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setRepairTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRepairTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getScrapList())) {
            vo.getScrapList().forEach(item -> {
                item.setScrapPriceStr(null != item.getDamageScrapPrice() ? priceFmt.format(item.getDamageScrapPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setScrapTaxPriceStr(null != item.getDamageScrapTaxPrice() ? priceFmt.format(item.getDamageScrapTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setScrapTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setScrapTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getPaymentList())) {
            vo.getPaymentList().forEach(item -> item.setPaymentScaleStr(null != item.getPaymentScale() ? mnyFmt.format(item.getPaymentScale()) : mnyFmt.format(BigDecimal.ZERO)));
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getClauseList())) {
            vo.getClauseList().forEach(item -> item.setNecessaryStatusStr(null != item.getNecessaryStatus() && item.getNecessaryStatus() == 1 ? "\u662f" : "\u5426"));
        }
        return CommonResponse.success((Object)vo);
    }

    @GetMapping(value={"getSignedFileInfo"})
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value="billId") Long billId, @RequestParam(value="billType") String billType) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.service.getSignedFileInfo(billId, billType));
    }
}

