package com.ejianc.business.outrmat.lose.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 遗失单材料清单明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_outrmat_lose_detail")
public class OutRmatLoseDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="material_id")
    private Long materialId; // 物料主键
    @TableField(value="material_name")
    private String materialName; // 物料名称
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物料分类
    @TableField(value="material_type_name")
    private String materialTypeName; // 物料分类名称
    @TableField(value="material_code")
    private String materialCode; // 物料编码
    @TableField(value="unit_name")
    private String unitName; // 计量单位
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="lose_tax_price")
    private BigDecimal loseTaxPrice; // 遗失单价
    @TableField(value="lose_price")
    private BigDecimal losePrice; // 遗失单价(无税)
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="exit_num")
    private BigDecimal exitNum; // 可退场数量
    @TableField(value="lose_num")
    private BigDecimal loseNum; // 遗失数量
    @TableField(value="compensation_mny")
    private BigDecimal compensationMny; // 赔偿金额(无税)
    @TableField(value="compensation_tax_mny")
    private BigDecimal compensationTaxMny; // 赔偿金额
    @TableField(value="date")
    private Date date; // 止租日期
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="lose_id")
    private Long loseId; // 遗失单主键
    @TableField(value="unit_id")
    private Long unitId; // 单位主键
    @TableField(value="rent_calculation_type")
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租
    @TableField(value="use_status")
    private String useStatus; // 使用状态：0-停用，1-启用
    @TableField(value="source_id")
    private String sourceId; // 来源主键
    @TableField(value = "tax")
    private BigDecimal tax; //赔偿税额
    @TableField(value="unit_m_id")
    private Long unitMId; // 计量单位主键
    @TableField(value="unit_m_name")
    private String unitMName; // 计量单位
    @TableField(value="num_m")
    private BigDecimal numM; // 计量数量
    @TableField(value="trans_scale")
    private BigDecimal transScale; // 转换系数
    @TableField(value="store_id")
    private Long storeId; // 仓库主键
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="source_type")
    private Integer sourceType; // 材料来源,0-自购,1-租赁

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public BigDecimal getLosePrice() {
        return losePrice;
    }

    public void setLosePrice(BigDecimal losePrice) {
        this.losePrice = losePrice;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getExitNum() {
        return exitNum;
    }

    public void setExitNum(BigDecimal exitNum) {
        this.exitNum = exitNum;
    }
    public BigDecimal getLoseNum() {
        return loseNum;
    }

    public void setLoseNum(BigDecimal loseNum) {
        this.loseNum = loseNum;
    }
    public BigDecimal getCompensationMny() {
        return compensationMny;
    }

    public void setCompensationMny(BigDecimal compensationMny) {
        this.compensationMny = compensationMny;
    }
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getLoseId() {
        return loseId;
    }

    public void setLoseId(Long loseId) {
        this.loseId = loseId;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUseStatus() {
        return useStatus;
    }

    public void setUseStatus(String useStatus) {
        this.useStatus = useStatus;
    }

    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }

    public BigDecimal getLoseTaxPrice() {
        return loseTaxPrice;
    }

    public void setLoseTaxPrice(BigDecimal loseTaxPrice) {
        this.loseTaxPrice = loseTaxPrice;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public BigDecimal getCompensationTaxMny() {
        return compensationTaxMny;
    }

    public void setCompensationTaxMny(BigDecimal compensationTaxMny) {
        this.compensationTaxMny = compensationTaxMny;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public Long getUnitMId() {
        return unitMId;
    }

    public void setUnitMId(Long unitMId) {
        this.unitMId = unitMId;
    }

    public String getUnitMName() {
        return unitMName;
    }

    public void setUnitMName(String unitMName) {
        this.unitMName = unitMName;
    }

    public BigDecimal getNumM() {
        return numM;
    }

    public void setNumM(BigDecimal numM) {
        this.numM = numM;
    }

    public BigDecimal getTransScale() {
        return transScale;
    }

    public void setTransScale(BigDecimal transScale) {
        this.transScale = transScale;
    }
}
