package com.ejianc.business.assist.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.bean.ContractRelieveEntity;
import com.ejianc.business.assist.rmat.bean.SettleEntity;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.assist.rmat.enums.SettleEnum;
import com.ejianc.business.assist.rmat.mapper.ContractRelieveMapper;
import com.ejianc.business.assist.rmat.service.IContractRelieveService;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.service.ISettleService;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.rmat.vo.ContractRelieveVO;
import com.ejianc.business.assist.rmat.vo.record.RelieveRecordVO;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * 合同解除
 * 
 * @author generator
 * 
 */
@Service("contractRelieveService")
public class ContractRelieveServiceImpl extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity> implements IContractRelieveService{

    private static final String PRORMAT_CONTRACT_RELIEVE = "PRORMAT_CONTRACT_RELIEVE";//此处需要根据实际修改

    @Autowired
    private IBillTypeApi billTypeApi;
    
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IContractService contractService;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Autowired
    private ISettleService settleService;
    
    @Override
    public ContractRelieveVO saveOrUpdate(ContractRelieveVO saveOrUpdateVO) {
        ContractRelieveEntity entity = BeanMapper.map(saveOrUpdateVO, ContractRelieveEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(PRORMAT_CONTRACT_RELIEVE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        contractService.validateContract(saveOrUpdateVO.getContractId(), MaterialConstant.解除单, saveOrUpdateVO.getId(), MaterialConstant.保存);
        
        // 查询合同状态：不是履约中不可以解除
        ContractEntity contractEntity = contractService.selectById(entity.getContractId());
        if (contractEntity == null || Objects.equals(contractEntity.getPerformanceStatus(), PerformanceStatusEnum.已终止.getCode())
                || Objects.equals(contractEntity.getPerformanceStatus(), PerformanceStatusEnum.已作废.getCode())
                ||  Objects.equals(contractEntity.getPerformanceStatus(), PerformanceStatusEnum.未签订.getCode())) {
            throw new BusinessException("查询不到合同或合同状态为未签订或已终止或已作废！");
        }
        
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, entity.getContractId()));
        List<ContractRelieveEntity> list = this.queryList(param);
        if (list.size() > 1) {
            throw new BusinessException("一个合同只能有一份合同解除协议!");
        }
        
        // 起草方式 1、上传解除协议，初始化签章状态为；1-未签章
        entity.setSignatureStatus(0);
        
        
        this.saveOrUpdate(entity, false);
        
        return BeanMapper.map(entity, ContractRelieveVO.class);
    }

    @Override
    public Boolean addRelieveFlag(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, id));
        List<ContractRelieveEntity> list = this.queryList(param);
        
        return ListUtil.isEmpty(list);
    }

    @Override
    public RelieveRecordVO queryRelieveRecord(Long id) {
        ContractEntity entity = contractService.selectById(id);
        RelieveRecordVO vo = new RelieveRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        
        LambdaQueryWrapper<ContractRelieveEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRelieveEntity::getContractId, id);
        wrapper.orderByDesc(ContractRelieveEntity::getCreateTime);

        List<ContractRelieveEntity> list = this.list(wrapper);
        
        vo.setDetailList(BeanMapper.mapList(list, ContractRelieveVO.class));
        
        return vo;
    }

    /**
     * 转换目标成本VO
     * @param entity
     * @return
     */
    @Override
    public ExecutionVO targetCost(ContractRelieveEntity entity) {
        // 计算所有过程结算累计结算金额 
        LambdaQueryWrapper<SettleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettleEntity::getContractId, entity.getContractId());
        wrapper.eq(SettleEntity::getSettleType, SettleEnum.过程结算.getCode());
        wrapper.in(SettleEntity::getBillState, Arrays.asList(1,3));
        List<SettleEntity> list = settleService.list(wrapper);

        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettleTaxMny() != null).map(SettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettleMny() != null).map(SettleEntity::getSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 查询合同
        ContractEntity contractEntity = contractService.getById(entity.getContractId());

        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getBillCode());
        totalVO.setBillType(BillTypeEnum.辅料中心租入合同解除.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.周转材租赁合同.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setMoney(ComputeUtil.safeDiv(totalSettleMny, contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeDiv(totalSettleTaxMny, contractEntity.getContractTaxMny()));
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            baseHost = BASE_HOST_FRONTEND;
        }
        totalVO.setLinkUrl(baseHost + "ejc-prormat-frontend/#/contract/relieveCard?id=" + entity.getId());

        executionVO.setTotalVO(totalVO);

        return executionVO;

    }
    
}
