package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.rmat.bean.TotalPlanDetailChangeEntity;
import com.ejianc.business.assist.rmat.bean.TotalPlanDetailEntity;
import com.ejianc.business.assist.rmat.bean.TotalPlanEntity;
import com.ejianc.business.assist.rmat.service.ITotalPlanDetailChangeService;
import com.ejianc.business.assist.rmat.service.ITotalPlanService;
import com.ejianc.business.assist.rmat.utils.SortUtil;
import com.ejianc.business.assist.rmat.utils.TreeNodeBUtil;
import com.ejianc.business.assist.rmat.vo.TotalPlanChangeVO;
import com.ejianc.business.assist.rmat.vo.TotalPlanDetailChangeVO;
import com.ejianc.business.assist.rmat.vo.TotalPlanDetailVO;
import com.ejianc.business.assist.rmat.vo.TotalPlanVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.assist.rmat.mapper.TotalPlanChangeMapper;
import com.ejianc.business.assist.rmat.bean.TotalPlanChangeEntity;
import com.ejianc.business.assist.rmat.service.ITotalPlanChangeService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 周转材总计划变更
 *
 * @author generator
 */
@Service("totalPlanChangeService")
public class TotalPlanChangeServiceImpl extends BaseServiceImpl<TotalPlanChangeMapper, TotalPlanChangeEntity> implements ITotalPlanChangeService {
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private ITotalPlanDetailChangeService detailChangeService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IShareMaterialApi materialApi;

    @Override
    public TotalPlanChangeVO queryDetailChange(Long id) {
        TotalPlanEntity entity = totalPlanService.selectById(id);
        if (entity != null) {
            TotalPlanChangeVO vo = BeanMapper.map(entity, TotalPlanChangeVO.class);

            List<TotalPlanDetailChangeVO> detailVoListDb = vo.getDetailList();
            List<TotalPlanDetailChangeVO> detailVoList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(detailVoListDb)) {
                detailVoListDb.forEach(detailEntity -> {
                    if (null == detailEntity.getChangeType() || 2 != detailEntity.getChangeType()) {
                        detailVoList.add(detailEntity);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(detailVoList)) {
                for (TotalPlanDetailChangeVO cdEntity : detailVoList) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("add");
                }
                new SortUtil<TotalPlanDetailChangeVO>().entryListToSort(detailVoList, "treeIndex");
                vo.setDetailList(TreeNodeBUtil.buildTree(detailVoList));
            }
            vo.setTotalId(entity.getId());
            vo.setId(null);
            vo.setBillState(null);
            vo.setCreateUserCode(null);
            vo.setCreateTime(null);
            vo.setUpdateUserCode(null);
            vo.setUpdateTime(null);
            vo.setChangeReason(null);
            vo.setBeforeChangeMny(vo.getEstimatedMny());// 变更前金额
            vo.setChangeVersion(vo.getChangeVersion() + 1);// 版本
            return vo;
        }
        return null;
    }

    @Override
    public TotalPlanChangeVO saveOrUpdate(TotalPlanChangeVO saveOrUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        TotalPlanChangeEntity entity = null;
        String operateType = null;

        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改
            entity = BeanMapper.map(saveOrUpdateVO, TotalPlanChangeEntity.class);
            operateType = "edit";
        } else {
            //新增
            entity = BeanMapper.map(saveOrUpdateVO, TotalPlanChangeEntity.class);
            operateType = "add";
        }
        super.saveOrUpdate(entity);
        //更新子表信息
        if ("edit".equals(operateType)) {
            baseMapper.delByPlanId(entity.getId());
        }
        List<TotalPlanDetailChangeEntity> detailEntityList = entity.getDetailList();
        List<TotalPlanDetailChangeEntity> detailEntitys = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (TotalPlanDetailChangeEntity cdEntity : detailEntityList) {
                cdEntity.setId(IdWorker.getId());
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (TotalPlanDetailChangeEntity cdEntity : detailEntityList) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
                cdEntity.setChangeId(entity.getId());
                if (!"del".equals(cdEntity.getRowState())) {
                    detailEntitys.add(cdEntity);
                }
            }
            if (detailEntitys.size() > 0) {
                detailChangeService.saveOrUpdateBatch(detailEntitys, detailEntitys.size(), false);
            }
        }

        LambdaUpdateWrapper<TotalPlanEntity> lambdaUpdate = new LambdaUpdateWrapper<>();
        lambdaUpdate.set(TotalPlanEntity::getChangingMny, entity.getEstimatedMny());
        lambdaUpdate.set(TotalPlanEntity::getChangeStatus, 2);
        lambdaUpdate.set(TotalPlanEntity::getChangeCode, entity.getBillCode());
        lambdaUpdate.set(TotalPlanEntity::getChangeId, entity.getId());
        lambdaUpdate.eq(TotalPlanEntity::getId, entity.getTotalId());
        totalPlanService.update(lambdaUpdate);


        TotalPlanChangeVO totalPlanChangeVO = queryDetail(entity.getId(), true);
        //推送目标成本
        //删除之前数据
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
        TotalPlanEntity masterPlanEntity = totalPlanService.selectById(entity.getTotalId());
        ExecutionVO executionVO1 = totalPlanService.targetCost(BeanMapper.map(masterPlanEntity, TotalPlanVO.class),"");
        totalExecutionVOList.add(executionVO1.getTotalVO());
        logger.info("目标成本删除数据"+ JSON.toJSONString(totalExecutionVOList));
        CommonResponse<String> response1 = executionApi.aggDel(totalExecutionVOList);
        if (!response1.isSuccess()){
            throw new BusinessException("目标成本推送失败,"+response1.getMsg());
        }

        //新推数据
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            baseHost = BASE_HOST_FRONTEND;
        }
        String linkUrl =baseHost+"ejc-promaterial-frontend/#/concreteMasterPlan/changeCard?id="+entity.getId();
        ExecutionVO executionVO = totalPlanService.targetCost(BeanMapper.map(queryDetail(entity.getId(), false), TotalPlanVO.class),linkUrl);
        logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()){
            throw new BusinessException("目标成本推送失败,"+response.getMsg());
        }
        return totalPlanChangeVO;
    }

    @Override
    public TotalPlanChangeVO queryDetail(Long id, boolean detailHasChildren) {
        TotalPlanChangeEntity entity = super.selectById(id);
        TotalPlanChangeVO vo = BeanMapper.map(entity, TotalPlanChangeVO.class);

        List<TotalPlanDetailChangeVO> detailVoListDb = vo.getDetailList();
        List<TotalPlanDetailChangeVO> detailVoList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailVoListDb)) {
            detailVoListDb.forEach(detailEntity -> {
                if (null == detailEntity.getChangeType() || 2 != detailEntity.getChangeType()) {
                    detailVoList.add(detailEntity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailVoList)) {
            for (TotalPlanDetailChangeVO cdEntity : detailVoList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("add");
            }
            new SortUtil<TotalPlanDetailChangeVO>().entryListToSort(detailVoList, "treeIndex");
            if (detailHasChildren) {
                vo.setDetailList(TreeNodeBUtil.buildTree(detailVoList));
            } else {
                vo.setDetailList(detailVoList);
            }
        }
        return vo;
    }

    @Override
    public void deleteByIds(List<TotalPlanChangeVO> vos) {
        //目标成本推送
        //删除数据
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
        List<TotalPlanVO> masterPlanEntityList = new ArrayList<>();
        for (TotalPlanChangeVO vo : vos) {
            TotalPlanChangeEntity masterPlanChangeEntity = baseMapper.selectById(vo.getId());
            ExecutionVO executionVO = totalPlanService.targetCost(BeanMapper.map(masterPlanChangeEntity, TotalPlanVO.class),"");
            totalExecutionVOList.add(executionVO.getTotalVO());
            masterPlanEntityList.add(totalPlanService.queryDetail(masterPlanChangeEntity.getTotalId(),false));

            // 执行数据删除
            TotalPlanChangeEntity changeEntity = super.selectById(vo.getId());

            LambdaUpdateWrapper<TotalPlanEntity> lambdaUpdate = new LambdaUpdateWrapper<>();
            lambdaUpdate.set(TotalPlanEntity::getChangingMny, null);
            if (changeEntity.getChangeVersion() == 2) {
                lambdaUpdate.set(TotalPlanEntity::getChangeStatus, 1);
            } else {
                lambdaUpdate.set(TotalPlanEntity::getChangeStatus, 3);
            }
            lambdaUpdate.set(TotalPlanEntity::getChangeCode, null);
            lambdaUpdate.set(TotalPlanEntity::getChangeId, null);
            lambdaUpdate.eq(TotalPlanEntity::getId, changeEntity.getTotalId());
            totalPlanService.update(lambdaUpdate);

            super.removeById(vo, false);
        }

        logger.info("目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
        CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本推送失败," + response.getMsg());
        }

        //推送上一版数据
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            baseHost = BASE_HOST_FRONTEND;
        }
        for (TotalPlanVO masterPlanEntity : masterPlanEntityList) {
            //目标成本推送
            String linkUrl =baseHost+"ejc-promaterial-frontend/#/masterPlan/card?id="+masterPlanEntity.getId();
            ExecutionVO executionVO1 = totalPlanService.targetCost(masterPlanEntity,linkUrl);
            logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO1));
            CommonResponse<String> response1 = executionApi.aggPush(executionVO1);
            if (!response1.isSuccess()){
                throw new BusinessException("目标成本推送失败,"+response.getMsg());
            }
        }
    }

    @Override
    public List<TotalPlanChangeVO> queryChangeHistory(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        List<TotalPlanChangeEntity> changeEntities = baseMapper.selectList(new QueryWrapper<TotalPlanChangeEntity>()
                .eq("total_id", id)
                .in("bill_state", billStatus).orderByDesc("used_time"));
        if (null != changeEntities && changeEntities.size() > 0) {
            List<TotalPlanChangeVO> changeVos = BeanMapper.mapList(changeEntities, TotalPlanChangeVO.class);
            for (TotalPlanChangeVO cvo : changeVos) {
                String historyBillCode = cvo.getBillCode() + "-" + cvo.getChangeVersion();
                cvo.setHistoryBillCode(historyBillCode);
            }
            return changeVos;
        }
        return null;
    }
}
