package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.rmat.bean.TotalPlanDetailEntity;
import com.ejianc.business.assist.rmat.service.ITotalPlanDetailService;
import com.ejianc.business.assist.rmat.utils.SortUtil;
import com.ejianc.business.assist.rmat.utils.TreeNodeBUtil;
import com.ejianc.business.assist.rmat.vo.TotalPlanDetailVO;
import com.ejianc.business.assist.rmat.vo.TotalPlanVO;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.assist.rmat.mapper.TotalPlanMapper;
import com.ejianc.business.assist.rmat.bean.TotalPlanEntity;
import com.ejianc.business.assist.rmat.service.ITotalPlanService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 周转材总计划
 *
 * @author generator
 */
@Service("totalPlanService")
public class TotalPlanServiceImpl extends BaseServiceImpl<TotalPlanMapper, TotalPlanEntity> implements ITotalPlanService {
    private static final String BILL_CODE = "PRO_TOTAL_PLAN_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ITotalPlanDetailService detailService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String baseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IShareMaterialApi materialApi;

    @Override
    public TotalPlanVO saveOrUpdate(TotalPlanVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        TotalPlanEntity entity = null;
        String operateType = null;

        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            entity = BeanMapper.map(saveorUpdateVO, TotalPlanEntity.class);
            operateType = "edit";
        } else {
            //新增
            //校验项目是否已有总计划
            LambdaQueryWrapper<TotalPlanEntity> lambd = new LambdaQueryWrapper<>();
            lambd.eq(TotalPlanEntity::getProjectId, saveorUpdateVO.getProjectId());
            lambd.eq(TotalPlanEntity::getDr, BaseVO.DR_UNDELETE);
            List<TotalPlanEntity> list = super.list(lambd);
            if (null != list && list.size() > 0) {
                throw new BusinessException("保存失败，该项目下已存在周转材总计划，请勿重复添加！");
            }
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveorUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            entity = BeanMapper.map(saveorUpdateVO, TotalPlanEntity.class);
            entity.setChangeStatus(1);//未变更
            operateType = "add";
        }
        entity.setBaseMny(entity.getEstimatedMny());
        super.saveOrUpdate(entity);
        //更新子表信息
        if ("edit".equals(operateType)) {
            baseMapper.delByPlanId(entity.getId());
        }
        List<TotalPlanDetailEntity> detailEntityList = entity.getDetailList();
        List<TotalPlanDetailEntity> detailEntitys = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (TotalPlanDetailEntity cdEntity : detailEntityList) {
                cdEntity.setId(IdWorker.getId());
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (TotalPlanDetailEntity cdEntity : detailEntityList) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
                //变更类型
                cdEntity.setChangeType(0);
                cdEntity.setTotalId(entity.getId());
                if (!"del".equals(cdEntity.getRowState())) {
                    detailEntitys.add(cdEntity);
                }
            }
            if (detailEntitys.size() > 0) {
                detailService.saveOrUpdateBatch(detailEntitys, detailEntitys.size(), false);
            }
        }
        TotalPlanVO totalPlanVO = queryDetail(entity.getId(), true);

        //目标成本推送
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            baseHost = BASE_HOST_FRONTEND;
        }
        String linkUrl =baseHost+"ejc-promaterial-frontend/#/masterPlan/card?id="+entity.getId();
        ExecutionVO executionVO = targetCost(queryDetail(entity.getId(), false),linkUrl);
        logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()){
            throw new BusinessException("目标成本推送失败,"+response.getMsg());
        }
        return totalPlanVO;
    }
    @Override
    public ExecutionVO targetCost(TotalPlanVO totalPlanVO,String linkUrl){
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(totalPlanVO.getId());
        totalVO.setTenantId(totalPlanVO.getTenantId());
        totalVO.setBillCode(totalPlanVO.getBillCode());
        totalVO.setBillType("BT220209000000005");
        totalVO.setBillCategory(BillCategoryEnum.计划.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.周转材材料总计划.getCode());
        totalVO.setProjectId(totalPlanVO.getProjectId());
        totalVO.setOrgId(totalPlanVO.getOrgId());
        totalVO.setMoney(totalPlanVO.getEstimatedMny());
        totalVO.setTaxMoney(totalPlanVO.getEstimatedMny());
        totalVO.setLinkUrl(linkUrl);
        totalVO.setBillDate(totalPlanVO.getCreateTime().toString());
        for (TotalPlanDetailVO planDetailVO : totalPlanVO.getDetailList()) {
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(planDetailVO.getId());
            detailExecutionVO.setSourceBillId(totalPlanVO.getId());
            detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
            detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
            //判断是否是分类
            if (planDetailVO.getMaterialId()==null){
                detailExecutionVO.setCategoryFlag(true);
            }
            detailExecutionVO.setCode(planDetailVO.getMaterialCode());
            detailExecutionVO.setCategoryFlag(false);
            detailExecutionVO.setCategoryContainFlag(false);
            //根据分类ID查询物料分类信息
            MaterialCategoryVO categoryVO = materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
            if (categoryVO==null){
                detailExecutionVO.setCategoryInnerCode(null);
                detailExecutionVO.setCategoryCode(null);
            }else {
                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                detailExecutionVO.setCategoryCode(categoryVO.getCode());
            }
            detailExecutionVO.setDocId(planDetailVO.getSourceId()==null?1439116437228298666L:planDetailVO.getSourceId());
            detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());
            detailExecutionVO.setName(planDetailVO.getMaterialName());
            detailExecutionVO.setUnitName(planDetailVO.getUnit());
            detailExecutionVO.setNum(planDetailVO.getNum());
            detailExecutionVO.setMoney(planDetailVO.getMny());
            detailExecutionVO.setTaxMoney(planDetailVO.getMny());
            detailList.add(detailExecutionVO);
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);

        return executionVO;
    }

    @Override
    public TotalPlanVO queryDetail(Long id, boolean detailHasChildren) {
        TotalPlanEntity entity = super.selectById(id);
        TotalPlanVO vo = BeanMapper.map(entity, TotalPlanVO.class);

        List<TotalPlanDetailVO> detailVoListDb = vo.getDetailList();
        List<TotalPlanDetailVO> detailVoList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailVoListDb)) {
            detailVoListDb.forEach(detailEntity -> {
                if (null == detailEntity.getChangeType() || 2 != detailEntity.getChangeType()) {
                    detailVoList.add(detailEntity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailVoList)) {
            for (TotalPlanDetailVO cdEntity : detailVoList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("add");
            }
            new SortUtil<TotalPlanDetailVO>().entryListToSort(detailVoList, "treeIndex");
            if (detailHasChildren) {
                vo.setDetailList(TreeNodeBUtil.buildTree(detailVoList));
            } else {
                vo.setDetailList(detailVoList);
            }
        }

        return vo;
    }
    @Override
    public void delByPlanId(Long id) {
        baseMapper.delByPlanId(id);
    }

    @Override
    public void delByIds(List<TotalPlanVO> vos) {
        if(CollectionUtils.isNotEmpty(vos)) {
            //目标成本推送
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            for (TotalPlanVO masterPlanVO : vos) {
                ExecutionVO executionVO = targetCost(BeanMapper.map(baseMapper.selectById(masterPlanVO.getId()),TotalPlanVO.class),"");
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            logger.info("目标成本删除数据"+ JSON.toJSONString(totalExecutionVOList));
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败,"+response.getMsg());
            }
            List<Long> ids = vos.stream().map(TotalPlanVO::getId).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(ids)) {
                super.removeByIds(ids);
            }
        }
    }
}
