/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.rmat.bean.TotalPlanDetailEntity;
import com.ejianc.business.assist.rmat.bean.TotalPlanEntity;
import com.ejianc.business.assist.rmat.mapper.TotalPlanMapper;
import com.ejianc.business.assist.rmat.service.ITotalPlanDetailService;
import com.ejianc.business.assist.rmat.service.ITotalPlanService;
import com.ejianc.business.assist.rmat.utils.SortUtil;
import com.ejianc.business.assist.rmat.utils.TreeNodeBUtil;
import com.ejianc.business.assist.rmat.vo.TotalPlanDetailVO;
import com.ejianc.business.assist.rmat.vo.TotalPlanVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="totalPlanService")
public class TotalPlanServiceImpl
extends BaseServiceImpl<TotalPlanMapper, TotalPlanEntity>
implements ITotalPlanService {
    private static final String BILL_CODE = "PRO_TOTAL_PLAN_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ITotalPlanDetailService detailService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IShareMaterialApi materialApi;

    @Override
    public TotalPlanVO saveOrUpdate(TotalPlanVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        TotalPlanEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity = (TotalPlanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, TotalPlanEntity.class));
            operateType = "edit";
        } else {
            LambdaQueryWrapper lambd = new LambdaQueryWrapper();
            lambd.eq(TotalPlanEntity::getProjectId, (Object)saveorUpdateVO.getProjectId());
            lambd.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
            List list = super.list((Wrapper)lambd);
            if (null != list && list.size() > 0) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u5468\u8f6c\u6750\u603b\u8ba1\u5212\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (TotalPlanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, TotalPlanEntity.class));
            entity.setChangeStatus(1);
            operateType = "add";
        }
        entity.setBaseMny(entity.getEstimatedMny());
        super.saveOrUpdate((Object)entity);
        if ("edit".equals(operateType)) {
            ((TotalPlanMapper)this.baseMapper).delByPlanId(entity.getId());
        }
        List<TotalPlanDetailEntity> detailEntityList = entity.getDetailList();
        ArrayList<TotalPlanDetailEntity> detailEntitys = new ArrayList<TotalPlanDetailEntity>();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (TotalPlanDetailEntity cdEntity : detailEntityList) {
                cdEntity.setId(IdWorker.getId());
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (TotalPlanDetailEntity cdEntity : detailEntityList) {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                }
                cdEntity.setChangeType(0);
                cdEntity.setTotalId(entity.getId());
                if ("del".equals(cdEntity.getRowState())) continue;
                detailEntitys.add(cdEntity);
            }
            if (detailEntitys.size() > 0) {
                this.detailService.saveOrUpdateBatch(detailEntitys, detailEntitys.size(), false);
            }
        }
        TotalPlanVO totalPlanVO = this.queryDetail(entity.getId(), true);
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        String linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + entity.getId();
        ExecutionVO executionVO = this.targetCost(this.queryDetail(entity.getId(), false), linkUrl);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return totalPlanVO;
    }

    @Override
    public ExecutionVO targetCost(TotalPlanVO totalPlanVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(totalPlanVO.getId());
        totalVO.setTenantId(totalPlanVO.getTenantId());
        totalVO.setBillCode(totalPlanVO.getBillCode());
        totalVO.setBillType("BT220209000000005");
        totalVO.setBillCategory(BillCategoryEnum.\u8ba1\u5212.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u603b\u8ba1\u5212.getCode());
        totalVO.setProjectId(totalPlanVO.getProjectId());
        totalVO.setOrgId(totalPlanVO.getOrgId());
        totalVO.setMoney(totalPlanVO.getEstimatedMny());
        totalVO.setTaxMoney(totalPlanVO.getEstimatedMny());
        totalVO.setLinkUrl(linkUrl);
        totalVO.setBillDate(totalPlanVO.getCreateTime().toString());
        for (TotalPlanDetailVO planDetailVO : totalPlanVO.getDetailList()) {
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(planDetailVO.getId());
            detailExecutionVO.setSourceBillId(totalPlanVO.getId());
            detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
            detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
            if (planDetailVO.getMaterialId() == null) {
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
            }
            detailExecutionVO.setCode(planDetailVO.getMaterialCode());
            detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
            detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
            MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
            if (categoryVO == null) {
                detailExecutionVO.setCategoryInnerCode(null);
                detailExecutionVO.setCategoryCode(null);
            } else {
                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                detailExecutionVO.setCategoryCode(categoryVO.getCode());
            }
            detailExecutionVO.setDocId(Long.valueOf(planDetailVO.getSourceId() == null ? 1439116437228298666L : planDetailVO.getSourceId()));
            detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
            detailExecutionVO.setName(planDetailVO.getMaterialName());
            detailExecutionVO.setUnitName(planDetailVO.getUnit());
            detailExecutionVO.setNum(planDetailVO.getNum());
            detailExecutionVO.setMoney(planDetailVO.getMny());
            detailExecutionVO.setTaxMoney(planDetailVO.getMny());
            detailList.add(detailExecutionVO);
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public TotalPlanVO queryDetail(Long id, boolean detailHasChildren) {
        TotalPlanEntity entity = (TotalPlanEntity)((Object)super.selectById((Serializable)id));
        TotalPlanVO vo = (TotalPlanVO)BeanMapper.map((Object)((Object)entity), TotalPlanVO.class);
        List detailVoListDb = vo.getDetailList();
        ArrayList detailVoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailVoListDb)) {
            detailVoListDb.forEach(detailEntity -> {
                if (null == detailEntity.getChangeType() || 2 != detailEntity.getChangeType()) {
                    detailVoList.add(detailEntity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailVoList)) {
            for (TotalPlanDetailVO cdEntity : detailVoList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("add");
            }
            new SortUtil().entryListToSort(detailVoList, "treeIndex");
            if (detailHasChildren) {
                vo.setDetailList(TreeNodeBUtil.buildTree(detailVoList));
            } else {
                vo.setDetailList(detailVoList);
            }
        }
        return vo;
    }

    @Override
    public void delByPlanId(Long id) {
        ((TotalPlanMapper)this.baseMapper).delByPlanId(id);
    }

    @Override
    public void delByIds(List<TotalPlanVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (TotalPlanVO masterPlanVO : vos) {
                ExecutionVO executionVO = this.targetCost((TotalPlanVO)BeanMapper.map((Object)((TotalPlanMapper)this.baseMapper).selectById(masterPlanVO.getId()), TotalPlanVO.class), "");
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ids)) {
                super.removeByIds(ids);
            }
        }
    }
}

