package com.ejianc.business.assist.report.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.assist.report.bean.MonthReportDetailEntity;
import com.ejianc.business.assist.report.vo.MonthReportDetailVO;
import com.ejianc.business.assist.report.vo.MonthReportVO;
import com.ejianc.business.assist.store.bean.FlowEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.consts.StoreCommonConsts;
import com.ejianc.business.assist.store.service.IFlowService;
import com.ejianc.business.assist.store.service.ISurplusService;
import com.ejianc.business.assist.store.vo.SurplusVO;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteEntity;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.assist.report.mapper.MonthReportMapper;
import com.ejianc.business.assist.report.bean.MonthReportEntity;
import com.ejianc.business.assist.report.service.IMonthReportService;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 自有周转材月报表
 * 
 * @author generator
 * 
 */
@Service("monthReportService")
public class MonthReportServiceImpl extends BaseServiceImpl<MonthReportMapper, MonthReportEntity> implements IMonthReportService{
    private static final String BILL_CODE = "MONTH_REPORT";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IFlowService flowService;
    @Autowired
    private  ISurplusService surplusService;
    @Override
    public void saveMonthReport() {

        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        String today = dateFormat.format(cal.getTime());
        String period = today.substring(0,7);
        //查询主纬度数据
        //1,查询flow 流水表
        //1.1  入库日期小于今天
        //1.2  出入库类型 inOutTypeEnum  in (周转材收料入库,其他入库)
        QueryWrapper<FlowEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("in_out_flag", StoreCommonConsts.IN_OUT_TYPE_IN);
        queryWrapper.in("in_out_type", InOutTypeEnum.周转材收料入库.getInOutType(),InOutTypeEnum.其他入库.getInOutType());
        queryWrapper.le("source_bill_date",today);
        List<FlowEntity> instoreList = flowService.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(instoreList)){
            //根据分类id 去查询是否存在数据，有数据则证明不是期初  否则为期初数据
            List<FlowEntity> instoreListNew = instoreList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(()-> new TreeSet<>(Comparator.comparing(FlowEntity::getMaterialCategoryId))), ArrayList::new));
            Map<Long,String> mapTypeIds = instoreListNew.stream().collect(Collectors.toMap(FlowEntity::getMaterialCategoryId, FlowEntity::getMaterialCategoryName));
            mapTypeIds.forEach((k,v)->{
                QueryWrapper<MonthReportEntity> queryReportWrapper = new QueryWrapper<>();
                queryReportWrapper.eq("material_type_id", k);
                queryReportWrapper.orderByDesc("push_date");
                List<MonthReportEntity> monthReportEntities = super.list(queryReportWrapper);
                if(CollectionUtils.isNotEmpty(monthReportEntities)){
                    // 非期初数据
                    MonthReportEntity lastMonthReportEntity =  super.selectById(monthReportEntities.get(0).getId());//上期间数据
                    Date pushDate = lastMonthReportEntity.getPushDate();
                    MonthReportEntity monthReportEntity =  new MonthReportEntity();
                    monthReportEntity.setPeriod(period);
                    monthReportEntity.setMaterialTypeId(k);
                    monthReportEntity.setMaterialTypeName(v);
                    monthReportEntity.setPushDate(new Date());
                    monthReportEntity.setQcFlag(1);
                    monthReportEntity.setBillCode(getBillCode(monthReportEntity));
                    // 取子表信息
                    List<MonthReportDetailEntity> monthReportDetailVOS = baseMapper.getMonthDetailNum(k,dateFormat.format(pushDate),today);
                    if(CollectionUtils.isNotEmpty(monthReportDetailVOS)){
                        List<MonthReportDetailEntity> monthReportDetailList = lastMonthReportEntity.getMonthReportDetailList();
                        //map<项目id，上月数据的结存>
                        Map<Long,BigDecimal> map= monthReportDetailList.stream().collect(Collectors.toMap(MonthReportDetailEntity::getProjectId, MonthReportDetailEntity::getMonthBalanceDetailNum));
                        monthReportDetailVOS.forEach(m->{
                            if(map.containsKey(m.getProjectId())){
                                m.setMonthBalanceDetailNum(m.getMonthBalanceDetailNum().add(map.get(m.getProjectId())));
                                m.setLastBalanceDetailNum(map.get(m.getProjectId()));
                            }
                        });
                        BigDecimal monthBalanceNum =  monthReportDetailVOS.stream().map(MonthReportDetailEntity::getMonthBalanceDetailNum).reduce(BigDecimal.ZERO,BigDecimal::add);
                        BigDecimal monthScrapNum =  monthReportDetailVOS.stream().map(MonthReportDetailEntity::getMonthScrapDetailNum).reduce(BigDecimal.ZERO,BigDecimal::add);
                        monthReportEntity.setMonthBalanceNum(monthBalanceNum);// 本月结存
                        monthReportEntity.setMonthScrapNum(monthScrapNum);// 本月报废
                        monthReportEntity.setScrapNums(ComputeUtil.safeAdd(monthScrapNum,lastMonthReportEntity.getScrapNums()));// 累计报废 --本月+上月
                        monthReportEntity.setLastScrapNums(monthReportEntity.getScrapNums().subtract(monthScrapNum));//上月累计报废
                        monthReportEntity.setLastStorageNum(lastMonthReportEntity.getMonthStorageNum());   //上月账存
                        //本月库存 =本月周转材大类的仓库列表中的闲置数量+本月报废
                        BigDecimal surplusXzNum = BigDecimal.ZERO;
                        List<SurplusVO>  surplusVOS = surplusService.queryStoreList(k);
                        if(CollectionUtils.isNotEmpty(surplusVOS)){
                            surplusXzNum =  surplusVOS.stream().map(SurplusVO::getSurplusXzNum).reduce(BigDecimal.ZERO,BigDecimal::add);//闲置数量
                        }
                        monthReportEntity.setMonthStockNum(ComputeUtil.safeAdd(surplusXzNum,monthScrapNum));//本月库存
                        monthReportEntity.setMonthStorageNum(ComputeUtil.safeAdd(monthBalanceNum,monthReportEntity.getMonthStockNum()));//  本月账存：等于本月库存+本月项目结存
                        monthReportEntity.setMonthReportDetailList(monthReportDetailVOS);
                        super.saveOrUpdate(monthReportEntity,false);
                    }
                }else{
                    //期初数据
                    MonthReportEntity monthReportEntity = new MonthReportEntity();
                    monthReportEntity.setPeriod(period);
                    monthReportEntity.setMaterialTypeId(k);
                    monthReportEntity.setMaterialTypeName(v);
                    monthReportEntity.setPushDate(new Date());
                    monthReportEntity.setQcFlag(0);
                    monthReportEntity.setBillCode(getBillCode(monthReportEntity));
                    // 取子表信息
                    List<MonthReportDetailEntity> monthReportDetailVOS = baseMapper.getMonthDetailNum(k,null,today);
                    if(CollectionUtils.isNotEmpty(monthReportDetailVOS)){
                        BigDecimal monthBalanceNum =  monthReportDetailVOS.stream().map(MonthReportDetailEntity::getMonthBalanceDetailNum).reduce(BigDecimal.ZERO,BigDecimal::add);
                        BigDecimal monthScrapNum =  monthReportDetailVOS.stream().map(MonthReportDetailEntity::getMonthScrapDetailNum).reduce(BigDecimal.ZERO,BigDecimal::add);
                        monthReportEntity.setMonthBalanceNum(monthBalanceNum);// 本月结存
                        monthReportEntity.setMonthScrapNum(monthScrapNum);// 本月报废
                        monthReportEntity.setScrapNums(monthScrapNum);// 累计报废
                        monthReportEntity.setLastScrapNums(BigDecimal.ZERO);//上月累计报废
                        monthReportEntity.setLastStorageNum(null);   //上月账存
                        //本月库存 =本月周转材大类的仓库列表中的闲置数量+本月报废
                        BigDecimal surplusXzNum = BigDecimal.ZERO;
                        List<SurplusVO>  surplusVOS = surplusService.queryStoreList(k);
                        if(CollectionUtils.isNotEmpty(surplusVOS)){
                            surplusXzNum =  surplusVOS.stream().map(SurplusVO::getSurplusXzNum).reduce(BigDecimal.ZERO,BigDecimal::add);//闲置数量
                        }
                        monthReportEntity.setMonthStockNum(ComputeUtil.safeAdd(surplusXzNum,monthScrapNum));//本月库存
                        monthReportEntity.setMonthStorageNum(ComputeUtil.safeAdd(monthBalanceNum,monthReportEntity.getMonthStockNum()));//  本月账存：等于本月库存+本月项目结存
                        monthReportEntity.setMonthReportDetailList(monthReportDetailVOS);
                        super.saveOrUpdate(monthReportEntity,false);
                    }

                }
            });
        }
    }

    public String getBillCode(MonthReportEntity monthReportEntity){
        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),BeanMapper.map(monthReportEntity,MonthReportVO.class));
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if (billCode.isSuccess()) {
            return billCode.getData();
        } else {
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
    }
}
