package com.ejianc.business.assist.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.bean.MaterialContractRelieveEntity;
import com.ejianc.business.assist.material.mapper.MaterialContractRelieveMapper;
import com.ejianc.business.assist.material.service.IMaterialContractRelieveService;
import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.assist.material.service.IMaterialSettleService;
import com.ejianc.business.assist.material.vo.MaterialContractRelieveVO;
import com.ejianc.business.assist.material.vo.record.MaterialRelieveRecordVO;
import com.ejianc.business.assist.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 辅料中心采购合同-合同解除
 * 
 * @author generator
 * 
 */
@Service("materialContractRelieveService")
public class MaterialContractRelieveServiceImpl extends BaseServiceImpl<MaterialContractRelieveMapper, MaterialContractRelieveEntity> implements IMaterialContractRelieveService{

    private static final String BILL_CODE = "ASSIST_RMAT_RENT_IN_CONTRACT_RELIEVE";//此处需要根据实际修改


    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IMaterialContractService contractService;


    @Autowired
    private IMaterialSettleService settleService;
    
    @Override
    public MaterialContractRelieveVO saveOrUpdate(MaterialContractRelieveVO saveOrUpdateVO) {
        MaterialContractRelieveEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialContractRelieveEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        contractService.validateContract(saveOrUpdateVO.getContractId(), MaterialConstant.解除单, saveOrUpdateVO.getId(), MaterialConstant.保存);

        // 查询合同状态：不是履约中不可以解除
        MaterialContractEntity contractEntity = contractService.selectById(entity.getContractId());
        if (contractEntity == null || Objects.equals(contractEntity.getPerformanceStatus(), PerformanceStatusEnum.已终止.getCode())
                || Objects.equals(contractEntity.getPerformanceStatus(), PerformanceStatusEnum.已作废.getCode())
                ||  Objects.equals(contractEntity.getPerformanceStatus(), PerformanceStatusEnum.未签订.getCode())) {
            throw new BusinessException("查询不到合同或合同状态为未签订或已终止或已作废！");
        }

        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, entity.getContractId()));
        List<MaterialContractRelieveEntity> list = this.queryList(param);
        if (list.size() > 1) {
            throw new BusinessException("一个合同只能有一份合同解除协议!");
        }

        // 起草方式 1、上传解除协议，初始化签章状态为；1-未签章
        entity.setSignatureStatus(0);


        this.saveOrUpdate(entity, false);

        return BeanMapper.map(this.selectById(entity.getId()), MaterialContractRelieveVO.class);
    }

    @Override
    public MaterialRelieveRecordVO queryRelieveRecord(Long id) {
        MaterialContractEntity entity = contractService.selectById(id);
        MaterialRelieveRecordVO vo = new MaterialRelieveRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());

        LambdaQueryWrapper<MaterialContractRelieveEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(MaterialContractRelieveEntity::getContractId, id);
        wrapper.orderByDesc(MaterialContractRelieveEntity::getCreateTime);

        List<MaterialContractRelieveEntity> list = this.list(wrapper);

        vo.setDetailList(BeanMapper.mapList(list, MaterialContractRelieveVO.class));

        return vo;
        
    }


}
