/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.report.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.assist.report.bean.MonthReportDetailEntity;
import com.ejianc.business.assist.report.bean.MonthReportEntity;
import com.ejianc.business.assist.report.mapper.MonthReportMapper;
import com.ejianc.business.assist.report.service.IMonthReportService;
import com.ejianc.business.assist.report.vo.MonthReportVO;
import com.ejianc.business.assist.store.bean.FlowEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.consts.StoreCommonConsts;
import com.ejianc.business.assist.store.service.IFlowService;
import com.ejianc.business.assist.store.service.ISurplusService;
import com.ejianc.business.assist.store.vo.SurplusVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="monthReportService")
public class MonthReportServiceImpl
extends BaseServiceImpl<MonthReportMapper, MonthReportEntity>
implements IMonthReportService {
    private static final String BILL_CODE = "MONTH_REPORT";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IFlowService flowService;
    @Autowired
    private ISurplusService surplusService;

    @Override
    public void saveMonthReport() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        String today = dateFormat.format(cal.getTime());
        String period = today.substring(0, 7);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.IN_OUT_TYPE_IN);
        queryWrapper.in((Object)"in_out_type", new Object[]{InOutTypeEnum.\u5468\u8f6c\u6750\u6536\u6599\u5165\u5e93.getInOutType(), InOutTypeEnum.\u5176\u4ed6\u5165\u5e93.getInOutType()});
        queryWrapper.le((Object)"source_bill_date", (Object)today);
        List instoreList = this.flowService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)instoreList)) {
            List instoreListNew = instoreList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FlowEntity>(Comparator.comparing(FlowEntity::getMaterialCategoryId))), ArrayList::new));
            Map<Long, String> mapTypeIds = instoreListNew.stream().collect(Collectors.toMap(FlowEntity::getMaterialCategoryId, FlowEntity::getMaterialCategoryName));
            mapTypeIds.forEach((k, v) -> {
                QueryWrapper queryReportWrapper = new QueryWrapper();
                queryReportWrapper.eq((Object)"material_type_id", k);
                queryReportWrapper.orderByDesc((Object)"push_date");
                List monthReportEntities = super.list((Wrapper)queryReportWrapper);
                if (CollectionUtils.isNotEmpty((Collection)monthReportEntities)) {
                    MonthReportEntity lastMonthReportEntity = (MonthReportEntity)((Object)((Object)super.selectById((Serializable)((MonthReportEntity)((Object)((Object)monthReportEntities.get(0)))).getId())));
                    Date pushDate = lastMonthReportEntity.getPushDate();
                    MonthReportEntity monthReportEntity = new MonthReportEntity();
                    monthReportEntity.setPeriod(period);
                    monthReportEntity.setMaterialTypeId((Long)k);
                    monthReportEntity.setMaterialTypeName((String)v);
                    monthReportEntity.setPushDate(new Date());
                    monthReportEntity.setQcFlag(1);
                    monthReportEntity.setBillCode(this.getBillCode(monthReportEntity));
                    List<MonthReportDetailEntity> monthReportDetailVOS = ((MonthReportMapper)this.baseMapper).getMonthDetailNum((Long)k, dateFormat.format(pushDate), today);
                    if (CollectionUtils.isNotEmpty(monthReportDetailVOS)) {
                        List<MonthReportDetailEntity> monthReportDetailList = lastMonthReportEntity.getMonthReportDetailList();
                        Map<Long, BigDecimal> map = monthReportDetailList.stream().collect(Collectors.toMap(MonthReportDetailEntity::getProjectId, MonthReportDetailEntity::getMonthBalanceDetailNum));
                        monthReportDetailVOS.forEach(m -> {
                            if (map.containsKey(m.getProjectId())) {
                                m.setMonthBalanceDetailNum(m.getMonthBalanceDetailNum().add((BigDecimal)map.get(m.getProjectId())));
                                m.setLastBalanceDetailNum((BigDecimal)map.get(m.getProjectId()));
                            }
                        });
                        BigDecimal monthBalanceNum = monthReportDetailVOS.stream().map(MonthReportDetailEntity::getMonthBalanceDetailNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal monthScrapNum = monthReportDetailVOS.stream().map(MonthReportDetailEntity::getMonthScrapDetailNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        monthReportEntity.setMonthBalanceNum(monthBalanceNum);
                        monthReportEntity.setMonthScrapNum(monthScrapNum);
                        monthReportEntity.setScrapNums(ComputeUtil.safeAdd((BigDecimal)monthScrapNum, (BigDecimal)lastMonthReportEntity.getScrapNums()));
                        monthReportEntity.setLastScrapNums(monthReportEntity.getScrapNums().subtract(monthScrapNum));
                        monthReportEntity.setLastStorageNum(lastMonthReportEntity.getMonthStorageNum());
                        BigDecimal surplusXzNum = BigDecimal.ZERO;
                        List<SurplusVO> surplusVOS = this.surplusService.queryStoreList((Long)k);
                        if (CollectionUtils.isNotEmpty(surplusVOS)) {
                            surplusXzNum = surplusVOS.stream().map(SurplusVO::getSurplusXzNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        }
                        monthReportEntity.setMonthStockNum(ComputeUtil.safeAdd((BigDecimal)surplusXzNum, (BigDecimal)monthScrapNum));
                        monthReportEntity.setMonthStorageNum(ComputeUtil.safeAdd((BigDecimal)monthBalanceNum, (BigDecimal)monthReportEntity.getMonthStockNum()));
                        monthReportEntity.setMonthReportDetailList(monthReportDetailVOS);
                        super.saveOrUpdate((Object)monthReportEntity, false);
                    }
                } else {
                    MonthReportEntity monthReportEntity = new MonthReportEntity();
                    monthReportEntity.setPeriod(period);
                    monthReportEntity.setMaterialTypeId((Long)k);
                    monthReportEntity.setMaterialTypeName((String)v);
                    monthReportEntity.setPushDate(new Date());
                    monthReportEntity.setQcFlag(0);
                    monthReportEntity.setBillCode(this.getBillCode(monthReportEntity));
                    List<MonthReportDetailEntity> monthReportDetailVOS = ((MonthReportMapper)this.baseMapper).getMonthDetailNum((Long)k, null, today);
                    if (CollectionUtils.isNotEmpty(monthReportDetailVOS)) {
                        BigDecimal monthBalanceNum = monthReportDetailVOS.stream().map(MonthReportDetailEntity::getMonthBalanceDetailNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal monthScrapNum = monthReportDetailVOS.stream().map(MonthReportDetailEntity::getMonthScrapDetailNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        monthReportEntity.setMonthBalanceNum(monthBalanceNum);
                        monthReportEntity.setMonthScrapNum(monthScrapNum);
                        monthReportEntity.setScrapNums(monthScrapNum);
                        monthReportEntity.setLastScrapNums(BigDecimal.ZERO);
                        monthReportEntity.setLastStorageNum(null);
                        BigDecimal surplusXzNum = BigDecimal.ZERO;
                        List<SurplusVO> surplusVOS = this.surplusService.queryStoreList((Long)k);
                        if (CollectionUtils.isNotEmpty(surplusVOS)) {
                            surplusXzNum = surplusVOS.stream().map(SurplusVO::getSurplusXzNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        }
                        monthReportEntity.setMonthStockNum(ComputeUtil.safeAdd((BigDecimal)surplusXzNum, (BigDecimal)monthScrapNum));
                        monthReportEntity.setMonthStorageNum(ComputeUtil.safeAdd((BigDecimal)monthBalanceNum, (BigDecimal)monthReportEntity.getMonthStockNum()));
                        monthReportEntity.setMonthReportDetailList(monthReportDetailVOS);
                        super.saveOrUpdate((Object)monthReportEntity, false);
                    }
                }
            });
        }
    }

    public String getBillCode(MonthReportEntity monthReportEntity) {
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)monthReportEntity), MonthReportVO.class)));
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (billCode.isSuccess()) {
            return (String)billCode.getData();
        }
        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
    }
}

