package com.ejianc.business.assist.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.rmat.bean.ContractDailyRentEntity;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.bean.ContractMonthRentEntity;
import com.ejianc.business.assist.rmat.bean.ContractNumRentEntity;
import com.ejianc.business.assist.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.assist.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.assist.rmat.service.*;
import com.ejianc.business.assist.rmat.utils.PageUtil;
import com.ejianc.business.assist.rmat.vo.ContractVO;
import com.ejianc.business.assist.rmat.vo.RentRefVO;
import com.ejianc.business.assist.rmat.vo.record.SupplementRecordVO;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 周转材租赁合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contract")
public class ContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IBillTypeApi billTypeApi;
   
    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    
    @Autowired
    private IContractService service;

    @Autowired
    private IContractDailyRentService dailyRentService;

    @Autowired
    private IContractMonthRentService monthRentService;

    @Autowired
    private IContractNumRentService numRentService;

    @Autowired
    private IContractRelieveService relieveService;
    
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@RequestBody ContractVO saveOrUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
    	return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveOrUpdateVO,authority));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryDetail(id));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        
        return CommonResponse.success(service.delete(vos));
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", service.pageList(param));
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        CommonResponse<JSONObject> commonResponse = this.queryList(param);
        List<ContractEntity> list = (List<ContractEntity>) commonResponse.getData().get("records");

        List<ContractVO> returnList = BeanMapper.mapList(list, ContractVO.class);
        if (ListUtil.isNotEmpty(returnList)) {
            for (ContractVO vo : returnList) {
                // 合同状态
                if (StringUtils.isBlank(vo.getPerformanceStatus())) {
                    vo.setPerformanceStatus(PerformanceStatusEnum.未签订.getDescription());
                }else {
                    vo.setPerformanceStatus(PerformanceStatusEnum.getEnumByCode(vo.getPerformanceStatus()).getDescription());
                }
                
                // 签章状态
                if (vo.getSignatureStatus() == null) {
                    vo.setSignatureStatusName(SignatureStatusEnum.未签章.getDescription());
                }else {
                    vo.setSignatureStatusName(SignatureStatusEnum.getEnumByCode(vo.getSignatureStatus()).getDescription());
                }
                
                // 单据状态名称
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", returnList);
        ExcelExport.getInstance().export("arri-contract-export.xlsx", beans, response);
    }
    
    
    /**
     * @Description 周转材租赁外租合同参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/arriContractRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> arriContractRef(@RequestParam Integer pageNumber
            , @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        
        param.getParams().put("performanceStatus", new Parameter(QueryParam.EQ, PerformanceStatusEnum.履约中.getCode()));
        param.getParams().put("changeStatus", new Parameter(QueryParam.IN, Arrays.asList(1,3)));

        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("orgId")) {
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        // 设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);
        
        IPage<ContractEntity> page = service.queryPage(param,false);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @Description 周转材租赁外租合同日租、月租、工程量租明细参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/arriContractRentRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentRefVO>> arriContractRentRef(@RequestParam Integer pageNumber
            , @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        
        QueryParam param = new QueryParam();
        param.setPageSize(-1);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("materialName");
        param.getFuzzyFields().add("materialTypeName");
        param.getFuzzyFields().add("materialCode");
        param.getFuzzyFields().add("spec");
        param.getFuzzyFields().add("unitName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 只要分类
        param.getParams().put("row_type", new Parameter(QueryParam.EQ, 1));
        
        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
            }else {
                return CommonResponse.error("当前传入合同id为空！");
            }
        }
        
        param.getOrderMap().put("createTime", "desc");
        
        //  查询日租明细
        IPage<ContractDailyRentEntity> dailyRentEntityIPage = dailyRentService.queryPage(param, false);
        List<ContractDailyRentEntity> dailyRentEntityList = dailyRentEntityIPage.getRecords();
        for (ContractDailyRentEntity entity : dailyRentEntityList) {
            entity.setRentCalculationType("0");
        }
        
        //  查询月租明细
        IPage<ContractMonthRentEntity> monthRentEntityIPage = monthRentService.queryPage(param, false);
        List<ContractMonthRentEntity> monthRentEntityList = monthRentEntityIPage.getRecords();
        for (ContractMonthRentEntity entity : monthRentEntityList) {
            entity.setRentCalculationType("1");
        }
        
        //  查询工程量租明细
        IPage<ContractNumRentEntity> numRentEntityIPage = numRentService.queryPage(param, false);
        List<ContractNumRentEntity> numRentEntityList = numRentEntityIPage.getRecords();
        for (ContractNumRentEntity entity : numRentEntityList) {
            entity.setRentCalculationType("2");
        }
        
        List<RentRefVO> rentRefVOList = new ArrayList<>();
        rentRefVOList.addAll(BeanMapper.mapList(dailyRentEntityList, RentRefVO.class));
        rentRefVOList.addAll(BeanMapper.mapList(monthRentEntityList, RentRefVO.class));
        rentRefVOList.addAll(BeanMapper.mapList(numRentEntityList, RentRefVO.class));
        rentRefVOList = rentRefVOList.stream().sorted(Comparator.comparing(RentRefVO::getCreateTime).reversed()).collect(Collectors.toList());
        
        rentRefVOList.forEach(e->{e.setRentCalculationTypeName(CommonConstant.CONTRACT_RENT_CALCULATION_TYPE.get(e.getRentCalculationType()));});

        List<RentRefVO> resultList = PageUtil.listToPage(rentRefVOList, pageNumber, pageSize);
        IPage<RentRefVO> page = new Page<>();
        page.setRecords(resultList);
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        page.setTotal(resultList.size());
        
        return CommonResponse.success("查询参照数据成功！", page);
    }
    
    
    /**
     * 根据合同Id查询合同文件管理信息
     *
     * @param contractId 合同Id
     * @return
     */
    @GetMapping(value = "/getContractFileMgrInfo")
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value = "contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        CommonResponse<BillTypeVO> billTypeResp = billTypeApi.getByRefCode(CommonConstant.CONTRACT_REFCODE);
        if(!billTypeResp.isSuccess()) {
            logger.error("根据refCode-{}查询对应元数据失败, 原因：{}", CommonConstant.CONTRACT_REFCODE, billTypeResp.getMsg());
            return CommonResponse.error("查询元数据信息失败");
        }

        ContractEntity contractEntity = service.selectById(contractId);
        CommonResponse<TemplateCategoryVO> categoryResp = templateCategoryApi.queryTmplCategoryById(contractEntity.getContractCategoryId());
        if(!categoryResp.isSuccess()) {
            logger.error("根据合同类别I的-{}查询对应合同类别信息失败, 原因：{}", contractEntity.getContractCategoryId(), categoryResp.getMsg());
            return CommonResponse.error("查询合同类别信息失败");
        }
        TemplateCategoryVO category = categoryResp.getData();
        resp.put("contactId", contractEntity.getId());
        resp.put("contractBillTypeCode", billTypeResp.getData().getBillCode());
        resp.put("contractCategoryId", category.getId());
        resp.put("boBillType", category.getBillTypeCode());

        return CommonResponse.success("查询成功！", resp);
    }

    /**
     * 判断当前合同是否能新增补充协议
     * @param id
     * @return
     */
    @RequestMapping(value = "/addSupplementFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = service.addSupplementFlag(id);
        if (flag){
            return CommonResponse.success("校验通过，该合同可以新增补充协议！");
        }
        return CommonResponse.error("当前合同存在未生效的补充协议，不能新增！");
    }

    /**
     * 合同补充协议历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplementRecordVO> querySupplementRecord(@RequestParam Long id) {
        SupplementRecordVO vo = service.querySupplementRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 判断当前合同能否新增合同解除单据
     * @param id 合同主键
     * @return boolean
     */
    @RequestMapping(value = "/addRelieveFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> addRelieveFlag(Long id) {
        Boolean flag = relieveService.addRelieveFlag(id);
        return CommonResponse.success("校验该合同新增合同解除单据成功！", flag);
    }
    
    /**
     * 辅料中心租入合同分类参照
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/arriContractCategoryRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RentRefVO>> arriContractCategoryRef(@RequestParam Long contractId) {
        QueryParam param = new QueryParam();
        
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("row_type", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        param.getOrderMap().put("createTime", "desc");

        //  查询日租明细
        IPage<ContractDailyRentEntity> dailyRentEntityIPage = dailyRentService.queryPage(param, false);
        List<ContractDailyRentEntity> dailyRentEntityList = dailyRentEntityIPage.getRecords();
        for (ContractDailyRentEntity entity : dailyRentEntityList) {
            entity.setRentCalculationType("0");
        }

        //  查询月租明细
        IPage<ContractMonthRentEntity> monthRentEntityIPage = monthRentService.queryPage(param, false);
        List<ContractMonthRentEntity> monthRentEntityList = monthRentEntityIPage.getRecords();
        for (ContractMonthRentEntity entity : monthRentEntityList) {
            entity.setRentCalculationType("1");
        }

        //  查询工程量租明细
        IPage<ContractNumRentEntity> numRentEntityIPage = numRentService.queryPage(param, false);
        List<ContractNumRentEntity> numRentEntityList = numRentEntityIPage.getRecords();
        for (ContractNumRentEntity entity : numRentEntityList) {
            entity.setRentCalculationType("2");
        }

        List<RentRefVO> rentRefVOList = new ArrayList<>();
        rentRefVOList.addAll(BeanMapper.mapList(dailyRentEntityList, RentRefVO.class));
        rentRefVOList.addAll(BeanMapper.mapList(monthRentEntityList, RentRefVO.class));
        rentRefVOList.addAll(BeanMapper.mapList(numRentEntityList, RentRefVO.class));
        rentRefVOList = rentRefVOList.stream().sorted(Comparator.comparing(RentRefVO::getCreateTime).reversed()).collect(Collectors.toList());

        rentRefVOList.forEach(e->{e.setRentCalculationTypeName(CommonConstant.CONTRACT_RENT_CALCULATION_TYPE.get(e.getRentCalculationType()));});
        
        return CommonResponse.success("查询参照数据成功！", rentRefVOList);
    }

    /**
     *  校验同一个合同只能存在一个自由态或审批中的单据（补充协议、变更单、冻结单、解除单）
     * @param contractId    合同主键
     * @param billType  待校验单据类型
     * @param billId    待校验单据主键
     * @return
     */
    @RequestMapping(value = "/validateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam("contractId") Long contractId, @RequestParam(value = "billType", required = false) String billType
            , @RequestParam(value = "billId", required = false) Long billId, @RequestParam(value = "type", required = false) String type) {
        String msg = service.validateContract(contractId, billType, billId, type);
        return CommonResponse.success("校验成功！", msg);
    }
    
}
