package com.ejianc.business.outrmat.order.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.assist.rmat.service.IDeliveryDetailService;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryDetailEntity;
import com.ejianc.business.outrmat.delivery.service.IOutRmatDeliveryDetailService;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderDetailEntity;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderEntity;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderDetailService;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderService;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderDetailVO;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderVO;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.business.promaterial.order.vo.OrderDetailVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.outrmat.order.mapper.OutRmatOrderDeliveryMapper;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderDeliveryEntity;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderDeliveryService;
import org.yaml.snakeyaml.events.Event;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 租出订单-发货流水表
 * 
 * @author generator
 * 
 */
@Service("outRmatOrderDeliveryService")
public class OutRmatOrderDeliveryServiceImpl extends BaseServiceImpl<OutRmatOrderDeliveryMapper, OutRmatOrderDeliveryEntity> implements IOutRmatOrderDeliveryService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutRmatOrderDetailService outRmatOrderDetailService;
    @Autowired
    private IOutRmatOrderService outRmatOrderService;
    @Autowired
    private IReceiptsApi receiptsApi;

    @Override
    public void saveOrUpdate(List<OutRmatDeliveryDetailEntity> detailVOS, Long contractId) {
        this.delOrderDetail(detailVOS);
        this.addOrderDetail(detailVOS,contractId);
    }
    @Override
    public void delete(List<OutRmatDeliveryDetailEntity> detailVOS, Long contractId) {
        this.delOrderDetail(detailVOS);
    }


    //新增回显
    public void addOrderDetail(List<OutRmatDeliveryDetailEntity> detailVOS, Long contractId) {
        Map<String,OutRmatOrderDeliveryEntity> orderDeliveryDetail = new HashMap<>();
        Map<String,OutRmatOrderDetailEntity> orderDetail = new HashMap<>();
        Set<Long> orderIds = new HashSet<>();//占用的订单id
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            for (OutRmatDeliveryDetailEntity outRmatDeliveryDetail: detailVOS) {
                List<OutRmatOrderDetailEntity> orderDetailEntities = outRmatOrderDetailService.queryMaterialDetail(contractId, outRmatDeliveryDetail.getMaterialId(), outRmatDeliveryDetail.getRentUnitId(), outRmatDeliveryDetail.getCalculateUnitId(), outRmatDeliveryDetail.getRentCalculationType().toString());//剩余发货大于0的订单明细
                BigDecimal orderNumsSum = outRmatDeliveryDetail.getRentNum() == null ? BigDecimal.ZERO : outRmatDeliveryDetail.getRentNum();//计租量
                if (CollectionUtils.isNotEmpty(orderDetailEntities)) {
                    for (int i = 0; i < orderDetailEntities.size(); i++) {
                        if (orderNumsSum.compareTo(BigDecimal.ZERO) > 0) {//总订单>0
                            BigDecimal orderNums = BigDecimal.ZERO;//本次占用
                            OutRmatOrderDetailEntity entity  = null;
                            if(orderDetail.containsKey(orderDetailEntities.get(i).getId().toString())){
                                entity= orderDetail.get(orderDetailEntities.get(i).getId().toString());
                            }else {
                                entity = orderDetailEntities.get(i);
                            }
                            OutRmatOrderDeliveryEntity orderDelivery = BeanMapper.map(entity, OutRmatOrderDeliveryEntity.class);
                            BigDecimal nums = entity.getReceiveNumsSum() == null ? BigDecimal.ZERO : entity.getReceiveNumsSum();// 接收数量
                            BigDecimal occupyNums = entity.getDeliveredNumsSum() == null ? BigDecimal.ZERO : entity.getDeliveredNumsSum();// 发货数量
                            BigDecimal surplusNums = entity.getNotDeliveredNumsSum() == null ? BigDecimal.ZERO : entity.getNotDeliveredNumsSum();// 剩余发货
                            if (orderNumsSum.compareTo(surplusNums) < 0) {//总订单量小于剩余量 取总订单量
                                orderNums = orderNumsSum;
                            } else if(i==orderDetailEntities.size()-1){
                                orderNums = orderNumsSum;
                            }else {
                                orderNums = surplusNums;
                            }
                            orderDelivery.setDeliveredNumsSum(orderNums);
                            //要修改状态订单
                            orderIds.add(entity.getOrderId());
                            //流水赋值
                            orderDelivery.setId(IdWorker.getId());
                            orderDelivery.setOrderDetailId(entity.getId());
                            orderDelivery.setDeliveryId(outRmatDeliveryDetail.getDeliveryId());
                            orderDelivery.setDeliveryDetailId(outRmatDeliveryDetail.getId());
                            //订单赋值
                            entity.setDeliveredNumsSum(occupyNums.add(orderDelivery.getDeliveredNumsSum()));
                            entity.setNotDeliveredNumsSum(nums.subtract(entity.getDeliveredNumsSum()));
                            orderNumsSum = orderNumsSum.subtract(orderNums);
                            orderDetail.put(entity.getId().toString(),entity);
                            orderDeliveryDetail.put(""+orderDelivery.getOrderDetailId()+orderDelivery.getDeliveryDetailId(),orderDelivery);
                        }
                    }
                }
            }
            logger.info("新增修改订单-----"+ JSONObject.toJSONString(orderDetail));
            if (MapUtils.isNotEmpty(orderDetail)){
                outRmatOrderDetailService.updateBatchById(orderDetail.values());
                updateOrderDeliverState(new ArrayList<>(orderDetail.values()),true);
            }
            logger.info("新增订单发货流水-----"+JSONObject.toJSONString(orderDeliveryDetail));
            if (MapUtils.isNotEmpty(orderDeliveryDetail)){
                this.saveOrUpdateBatch(orderDeliveryDetail.values());
            }
            logger.info("修改发货状态订单-----"+JSONObject.toJSONString(orderIds));
        }
    }

    //删除回显
    public void delOrderDetail(List<OutRmatDeliveryDetailEntity> detailVOS) {
        List<OutRmatOrderDetailEntity> orderDetailList = new ArrayList<>();
        List<OutRmatOrderDeliveryEntity> orderDeliveryDetailList = new ArrayList<>();
        Set<Long> orderIds = new HashSet<>();//占用的订单id
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            for (OutRmatDeliveryDetailEntity outRmatDeliveryDetail : detailVOS) {//遍历父级
                LambdaQueryWrapper<OutRmatOrderDeliveryEntity> lambda = Wrappers.<OutRmatOrderDeliveryEntity>lambdaQuery();
                lambda.eq(OutRmatOrderDeliveryEntity::getDeliveryDetailId, outRmatDeliveryDetail.getId());
                lambda.eq(OutRmatOrderDeliveryEntity::getDeliveryId, outRmatDeliveryDetail.getDeliveryId());
                List<OutRmatOrderDeliveryEntity> list = this.list(lambda);
                if (CollectionUtils.isNotEmpty(list)) {
                    for (OutRmatOrderDeliveryEntity orderDelivery: list) {//遍历子级进行计划分摊
                        OutRmatOrderDetailEntity entity = outRmatOrderDetailService.getById(orderDelivery.getOrderDetailId());
                        BigDecimal nums = entity.getReceiveNumsSum() == null ? BigDecimal.ZERO : entity.getReceiveNumsSum();// 数量
                        BigDecimal occupyNums = entity.getDeliveredNumsSum() == null ? BigDecimal.ZERO : entity.getDeliveredNumsSum();// 占用数量
                        BigDecimal orderNums = orderDelivery.getDeliveredNumsSum() == null ? BigDecimal.ZERO : orderDelivery.getDeliveredNumsSum();//订单量
                        entity.setDeliveredNumsSum(occupyNums.subtract(orderNums));
                        entity.setNotDeliveredNumsSum(nums.subtract(entity.getDeliveredNumsSum()));
                        orderDetailList.add(entity);
                        orderDeliveryDetailList.add(orderDelivery);
                        //要修改状态订单
                        orderIds.add(entity.getOrderId());
                    }
                }
            }
            logger.info("删除修改订单-----"+JSONObject.toJSONString(orderDetailList));
            if(CollectionUtils.isNotEmpty(orderDetailList)){
                outRmatOrderDetailService.updateBatchById(orderDetailList);
                updateOrderDeliverState(orderDetailList,false);
            }
            logger.info("删除订单发货流水-----"+JSONObject.toJSONString(orderDeliveryDetailList));
            if(CollectionUtils.isNotEmpty(orderDeliveryDetailList)){
                this.removeByIds(orderDeliveryDetailList.stream().map(OutRmatOrderDeliveryEntity::getId).collect(Collectors.toList()), true);
            }
        }
    }
////修改订单发货状态
//    public void updateOrderDeliverState(List<OutRmatOrderDetailEntity> orderDetailList,Boolean type){
//        List<OutRmatOrderEntity> orderDeliverState = new ArrayList<>();//要修改的订单列表
//        if(CollectionUtils.isNotEmpty(orderDetailList)){
//            Map<Long, List<OutRmatOrderDetailEntity>> collect = orderDetailList.stream().collect(Collectors.groupingBy(item -> item.getOrderId()));
//            if(MapUtils.isNotEmpty(collect)){
//                Set<Long> longs = collect.keySet();
//                QueryParam param = new QueryParam();
//                param.getParams().put("id", new Parameter(QueryParam.IN, longs));
//                List<OutRmatOrderEntity> outRmatOrderEntities = outRmatOrderService.queryList(param);
//                if(CollectionUtils.isNotEmpty(outRmatOrderEntities)){
//                    Map<Long, OutRmatOrderEntity> orderEntityMap = outRmatOrderEntities.stream().collect(Collectors.toMap(item -> item.getId(), Function.identity(), (v1, v2) -> v2));
//                    QueryParam paramDetail = new QueryParam();
//                    paramDetail.getParams().put("orderId", new Parameter(QueryParam.IN, orderEntityMap.keySet()));
//                    List<OutRmatOrderDetailEntity> orderDetailEntities = outRmatOrderDetailService.queryList(paramDetail);
//                    if (CollectionUtils.isNotEmpty(orderDetailEntities)){
//                        Map<Long, List<OutRmatOrderDetailEntity>> orderDateil = orderDetailEntities.stream().collect(Collectors.groupingBy(item -> item.getOrderId()));
//                        if(MapUtils.isNotEmpty(orderDateil)){
//                            for (Long orderId : orderDateil.keySet()) {
//                                BigDecimal receiveNumsSumTotal = orderDateil.get(orderId).stream().map(item -> {
//                                    if (null == item.getReceiveNumsSum()) {
//                                        return BigDecimal.ZERO;
//                                    }
//                                    return item.getReceiveNumsSum();
//                                }).reduce(BigDecimal.ZERO, BigDecimal::add);
//
//                                BigDecimal notDeliveredNumsSumTotal = orderDateil.get(orderId).stream().map(item -> {
//                                    if (null == item.getNotDeliveredNumsSum()) {
//                                        return BigDecimal.ZERO;
//                                    }
//                                    return item.getNotDeliveredNumsSum();
//                                }).reduce(BigDecimal.ZERO, BigDecimal::add);
//                                OutRmatOrderEntity outRmatOrderEntity = orderEntityMap.get(orderId);
//                                if(notDeliveredNumsSumTotal.compareTo(BigDecimal.ZERO)<=0){//全部
//                                    outRmatOrderEntity.setDeliverState(CommonConstant.ORDER_DELIVER_ALL);
////                                    public static final String ORDER_DELIVER_WAIT = "1"; //待送货
////                                    public static final String ORDER_DELIVER_ALL = "2"; //全部送货
////                                    public static final String ORDER_DELIVER_PART = "3"; //部分送货
//                                }else if(receiveNumsSumTotal.compareTo(notDeliveredNumsSumTotal)>0){//部分
//                                    outRmatOrderEntity.setDeliverState(CommonConstant.ORDER_DELIVER_PART);
//                                }else if(receiveNumsSumTotal.compareTo(notDeliveredNumsSumTotal)==0){//未发货
//                                    outRmatOrderEntity.setDeliverState(CommonConstant.ORDER_DELIVER_WAIT);
//                                }else {
//                                    logger.info("订单id:{},接收数量累计：{}，未发货数量累计：{}",orderId,receiveNumsSumTotal,notDeliveredNumsSumTotal);
//                                    throw new BusinessException("订单发货状态回显失败,计算发生错误！");
//                                }
//                                List<OutRmatOrderDetailEntity> orderDetailEntities1 = collect.get(orderId);
//                                outRmatOrderEntity.setOrderDetailList(orderDetailEntities1);
//                                orderDeliverState.add(outRmatOrderEntity);
//                            }
//                        }
//                    }
//                }
//            }
//        }
//        if(CollectionUtils.isNotEmpty(orderDeliverState)){
//            logger.info((type?"占用":"释放")+"要修改发货状态的订单数据集合:{}",JSONObject.toJSONString(orderDeliverState));
//
//        }
//    }

    //修改订单发货状态
    public void updateOrderDeliverState(List<OutRmatOrderDetailEntity> orderDetailList,Boolean type) {
        logger.info((type ? "占用" : "释放") + "要修改的订单明细数据集合:{}", JSONObject.toJSONString(orderDetailList));
        List<OutRmatOrderVO> orderDeliverState = new ArrayList<>();//要修改的订单列表
        if (CollectionUtils.isNotEmpty(orderDetailList)) {
            Map<Long, List<OutRmatOrderDetailEntity>> collect = orderDetailList.stream().collect(Collectors.groupingBy(item -> item.getOrderId()));
            if (MapUtils.isNotEmpty(collect)) {
                Set<Long> longs = collect.keySet();
                List<OutRmatOrderVO> outRmatOrderNumList = outRmatOrderDetailService.queryOrderNumTotal(new ArrayList<>(longs));
                if (CollectionUtils.isNotEmpty(outRmatOrderNumList)) {
                    for (OutRmatOrderVO orderVO : outRmatOrderNumList) {
                        BigDecimal receiveNumsSumTotal = orderVO.getReceiveNumsSumTotal();
                        BigDecimal notDeliveredNumsSumTotal = orderVO.getNotDeliveredNumsSumTotal();
                        if (notDeliveredNumsSumTotal.compareTo(BigDecimal.ZERO) <= 0) {//全部
                            orderVO.setDeliverState(CommonConstant.ORDER_DELIVER_ALL);
//                                    public static final String ORDER_DELIVER_WAIT = "1"; //待送货
//                                    public static final String ORDER_DELIVER_ALL = "2"; //全部送货
//                                    public static final String ORDER_DELIVER_PART = "3"; //部分送货
                        } else if (receiveNumsSumTotal.compareTo(notDeliveredNumsSumTotal) > 0) {//部分
                            orderVO.setDeliverState(CommonConstant.ORDER_DELIVER_PART);
                        } else if (receiveNumsSumTotal.compareTo(notDeliveredNumsSumTotal) == 0) {//未发货
                            orderVO.setDeliverState(CommonConstant.ORDER_DELIVER_WAIT);
                        } else {
                            logger.info("订单id:{},接收数量累计：{}，未发货数量累计：{}", orderVO.getId(), receiveNumsSumTotal, notDeliveredNumsSumTotal);
                            throw new BusinessException("订单发货状态回显失败,计算发生错误！");
                        }
                        List<OutRmatOrderDetailEntity> orderDetailEntities1 = collect.get(orderVO.getId());
                        orderVO.setOrderDetailList(BeanMapper.mapList(orderDetailEntities1, OutRmatOrderDetailVO.class));
                        orderDeliverState.add(orderVO);
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(orderDeliverState)) {
            logger.info((type ? "占用" : "释放") + "要修改发货状态的订单数据集合:{}", JSONObject.toJSONString(orderDeliverState));
            JSONArray jsonArray = JSONArray.parseArray(JSONObject.toJSONString(orderDeliverState));
            outRmatOrderService.updateBatchById(BeanMapper.mapList(orderDeliverState,OutRmatOrderEntity.class));
            receiptsApi.orderChangeStatus(jsonArray);
        }
    }
}
