package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.assist.rmat.bean.*;
import com.ejianc.business.assist.rmat.enums.*;
import com.ejianc.business.assist.rmat.mapper.ContractMapper;
import com.ejianc.business.assist.rmat.service.IChangeService;
import com.ejianc.business.assist.rmat.service.IContractFreezeService;
import com.ejianc.business.assist.rmat.service.IContractRelieveService;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.utils.ListCallable;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.rmat.utils.PushSupUtil;
import com.ejianc.business.assist.rmat.vo.ContractVO;
import com.ejianc.business.assist.rmat.vo.record.SupplementRecordVO;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.rmat.enums.DraftTypeEnum;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderRmatApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * 周转材租赁合同
 * 
 * @author generator
 * 
 */
@Service("contractService")
public class ContractServiceImpl extends BaseServiceImpl<ContractMapper, ContractEntity> implements IContractService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    private static final String BILL_CODE = "ASSIST_RMAT_RENT_IN_CONTRACT"; // 通用单据编码
    private static final String PURCHASE_CONTRACT_YNJT = "RENT_CONTRACT_MATERIAL_YNJT"; // 云南建投私有化单据编码
    private static final String OPERATE = "CONTRACT_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.辅料中心租入合同.getCode();
    private static final String BILL_NAME = BillTypeEnum.辅料中心租入合同.getName();

    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/contract/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/contract/billDel";
    
    
    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ITenderRmatApi tenderRmatApi;

    @Autowired
    private IExecutionApi executionApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private IContractService service;

    @Autowired
    private IChangeService changeService;

    @Autowired
    private IContractRelieveService relieveService;

    @Autowired
    private IContractFreezeService freezeService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Value("${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;

    @Autowired
    private ICommonSNAPI commonSNAPI;
    @Autowired
    private IOrgApi iOrgApi;


    @Override
    public ContractVO saveOrUpdate(ContractVO saveOrUpdateVO,String authority) {
        //组织编码赋值
        if (saveOrUpdateVO.getOrgId() != null && (StringUtils.isEmpty(saveOrUpdateVO.getOrgCode()) || StringUtils.isEmpty(saveOrUpdateVO.getParentOrgCode()))) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setOrgCode(orgVO.getCode());
                // 项目部
                if(5 == orgVO.getOrgType()){
                    CommonResponse<OrgVO> parentOrgResponse = iOrgApi.getOneById(orgVO.getParentId());
                    if (parentOrgResponse.isSuccess()) {
                        OrgVO parentOrgVO = parentOrgResponse.getData();
                        saveOrUpdateVO.setParentOrgId(parentOrgVO.getId());
                        saveOrUpdateVO.setParentOrgCode(parentOrgVO.getCode());
                        saveOrUpdateVO.setParentOrgName(parentOrgVO.getName());
                    }
                }
                // 非项目部
                else {
                    saveOrUpdateVO.setParentOrgId(saveOrUpdateVO.getOrgId());
                    saveOrUpdateVO.setParentOrgCode(saveOrUpdateVO.getOrgCode());
                    saveOrUpdateVO.setParentOrgName(saveOrUpdateVO.getOrgName());
                }
            }
        }
        ContractEntity entity = BeanMapper.map(saveOrUpdateVO, ContractEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }

            entity.setBillCode(getContractBillCode(saveOrUpdateVO));

            // 设置合同初始状态
            entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            if (entity.getSupplementFlag() == 1) {
                Boolean flag = addSupplementFlag(saveOrUpdateVO.getMainContractId());
                if (!flag) {
                    throw new BusinessException("当前合同存在未生效的补充协议，不能新增！");
                }
            }else {
                entity.setMainContractCreateDate(new Date());
            }
            
            // 回写定标结果占据状态
            if (entity.getTargetResultId() != null) {
                tenderRmatApi.updateById(entity.getTargetResultId(), CommonConstant.OCCUPY_STATE);
            }
        }else {
            // 若定标结果更换则回写原来定标结果为为占用状态，新定标结果为占用状态
            ContractEntity oldContractEntity = super.selectById(entity.getId());
            if (null != entity.getTargetResultId() && !entity.getTargetResultId().equals(oldContractEntity.getTargetResultId())){
                tenderRmatApi.updateById(oldContractEntity.getTargetResultId(), CommonConstant.UN_OCCUPY_STATE);
                tenderRmatApi.updateById(entity.getTargetResultId(), CommonConstant.OCCUPY_STATE);
                
                // 删除定标带出的数据
                List<Long> dailyIdsList = oldContractEntity.getDailyRentList().stream().map(BaseEntity::getId).collect(Collectors.toList());
                for (ContractDailyRentEntity dailyRentEntity : entity.getDailyRentList()) {
                    if (dailyIdsList.contains(dailyRentEntity.getId())) {
                        dailyRentEntity.setRowState("del");
                    }
                }

                List<Long> monthIdsList = oldContractEntity.getMonthRentList().stream().map(BaseEntity::getId).collect(Collectors.toList());
                for (ContractMonthRentEntity monthRentEntity : entity.getMonthRentList()) {
                    if (monthIdsList.contains(monthRentEntity.getId())) {
                        monthRentEntity.setRowState("del");
                    }
                }

                List<Long> numIdsList = oldContractEntity.getNumRentList().stream().map(BaseEntity::getId).collect(Collectors.toList());
                for (ContractNumRentEntity numRentEntity : entity.getNumRentList()) {
                    if (numIdsList.contains(numRentEntity.getId())) {
                        numRentEntity.setRowState("del");
                    }
                }
            }
            
            
        }

        if (entity.getSupplementFlag() == 1) {
            validateContract(saveOrUpdateVO.getMainContractId(), MaterialConstant.补充协议, saveOrUpdateVO.getId(), MaterialConstant.保存);
        }
        
        // 设置初始金额、变更前金额
        entity.setBaseTaxMny(entity.getContractTaxMny()); // 初始版本金额(含税)
        entity.setBaseMny(entity.getContractMny()); // 初始版本金额(不含税)
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny()); // 变更前金额(含税)
        entity.setBeforeChangeMny(entity.getContractMny()); // 变更前金额(不含税)
        
        // 设置日租、月租、工程量租剩余数量
        for (ContractDailyRentEntity dailyRentEntity : entity.getDailyRentList()) {
            dailyRentEntity.setSurplusCount(dailyRentEntity.getCount());
        }
        for (ContractMonthRentEntity monthRentEntity : entity.getMonthRentList()) {
            monthRentEntity.setSurplusCount(monthRentEntity.getCount());
        }
        for (ContractNumRentEntity numRentEntity : entity.getNumRentList()) {
            numRentEntity.setSurplusCount(numRentEntity.getCount());
        }
        if (entity.getContractFileId() != null){
            //合同旧数据
            ContractEntity contract = service.getById(entity.getId());
            if (contract != null
                    && (
                    //如果当前合同是线上起草，而且合同分类做了变更，那么删除附件
                    !contract.getContractCategoryId().equals(entity.getContractCategoryId()) ||
                            //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                            !(DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) ||
                                    DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contract.getDraftType()))
            )
                    && (
                    DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) ||
                            DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())
            )
            ) {
                if (null != contract.getContractFileId()){
                    delContractFile(contract.getContractFileId(), authority);
                }
                entity.setContractFileId(null);
                entity.setContractFilePath(null);
            }
        }
        this.saveOrUpdate(entity, false);

        ContractVO contractVO = queryDetail(entity.getId());

        // 推送目标成本
//        CommonResponse<String> response = executionApi.aggPush(targetCost(contractVO));
//        logger.info("推送目标成本入参：" + JSONObject.toJSONString(targetCost(contractVO)));
//        if (!response.isSuccess()){
//            logger.error("推送目标成本失败: , {}", response.getMsg());
//            throw new BusinessException(response.getMsg());
//        }

        return contractVO;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        ContractEntity entity = this.selectById(id);
        ContractVO vo = BeanMapper.map(entity, ContractVO.class);
        
        setRowState(vo);
        
        return vo;
    }

    //2、增加删除合同附件方法
    public Boolean delContractFile(Long fileId, String authority) {
        Map<String, Object> params = new HashMap<>();
        Map<String, String> header = new HashMap<>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);

        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get(baseHost + "ejc-file-web/attachment/delete", params, header, 10000, 10000);
        } catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse<String> delResp = JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null){
            logger.info("在线起草，删除上传合同返回信息：" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public String delete(List<ContractVO> vos) {
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
        if(ListUtil.isNotEmpty(vos)){
            for (ContractVO vo : vos) {
                ExecutionVO executionVO = this.targetCost(BeanMapper.map(this.getById(vo.getId()), ContractVO.class));
                totalExecutionVOList.add(executionVO.getTotalVO());
                
                // 删除定标占用状态
                ContractEntity contractEntity = this.getById(vo.getId());
                if (null != contractEntity.getTargetResultId()){
                    CommonResponse<String>  tender = tenderRmatApi.updateById(contractEntity.getTargetResultId(), CommonConstant.UN_OCCUPY_STATE);
                    logger.info("定标结果占用状态修改为未占用状态信息：" + tender.getMsg());
                }
            }
        }
        
        CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()){
            throw new BusinessException("目标成本删除失败！");
        }
        
        this.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()),true);
        
        
        return "删除成功！";
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // 项合同编号、目名称、合同名称、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("firstPartyEmployeeName");
        
        
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);

        param.setOrderMap(orderMap);
        IPage<ContractEntity> pageData = this.queryPage(param,false);

        // 页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = this.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("contractCount", contractAmountMap);

        return page;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("round(sum(base_tax_mny),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount");
        resp = super.getMap(wrapper);
        return resp;
        
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        // 一个主合同仅有一个未生效得补充协议、单据生效： 当单据审批通过，且签章状态为已签章
        LambdaQueryWrapper<ContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractEntity::getMainContractId, id);
        lambda.eq(ContractEntity::getSupplementFlag, ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> l.ne(ContractEntity::getSignatureStatus, String.valueOf(SignatureStatusEnum.已签章.getCode()))
                .or(c -> c.notIn(ContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()))
                .or(c -> c.eq(ContractEntity::getPerformanceStatus, String.valueOf(PerformanceStatusEnum.已作废.getCode()))));
        List<ContractEntity> supplementList = super.list(lambda);
        return supplementList.size() == 0;
        
    }

    @Override
    public SupplementRecordVO querySupplementRecord(Long id) {
        ContractEntity entity = this.selectById(id);
        SupplementRecordVO vo = new SupplementRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractMny(entity.getContractMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        
        // 查询补充协议
        LambdaQueryWrapper<ContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractEntity::getMainContractId, id);
        wrapper.orderByDesc(ContractEntity::getSignDate);
        List<ContractEntity> supplementList = super.list(wrapper);

        vo.setSupplementToalTaxMny(supplementList.stream().filter(e -> e.getContractTaxMny() != null).map(ContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementToalMny(supplementList.stream().filter(e -> e.getContractMny() != null).map(ContractEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementNum(supplementList.size());
        vo.setSupplementMnyRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo.getSupplementToalTaxMny(), vo.getContractTaxMny()), new BigDecimal("100")));
        
        vo.setDetailList(BeanMapper.mapList(supplementList, ContractVO.class));
        
        return vo;
    }
    
    public void setRowState(ContractVO vo) {
        // 日租
        if(ListUtil.isNotEmpty(vo.getDailyRentList())){
            vo.getDailyRentList().forEach(e -> e.setRowState("edit"));
        }
        // 月租
        if(ListUtil.isNotEmpty(vo.getMonthRentList())){
            vo.getMonthRentList().forEach(e -> e.setRowState("edit"));
        }
        // 工程量租
        if(ListUtil.isNotEmpty(vo.getNumRentList())){
            vo.getNumRentList().forEach(e -> e.setRowState("edit"));
        }
        // 维修
        if(ListUtil.isNotEmpty(vo.getRepairList())){
            vo.getRepairList().forEach(e -> e.setRowState("edit"));
        }
        // 报废
        if(ListUtil.isNotEmpty(vo.getScrapList())){
            vo.getScrapList().forEach(e -> e.setRowState("edit"));
        }
        // 其他费用
        if(ListUtil.isNotEmpty(vo.getOtherList())){
            vo.getOtherList().forEach(e -> e.setRowState("edit"));
        }
        // 付款计划
        if(ListUtil.isNotEmpty(vo.getPaymentList())){
            vo.getPaymentList().forEach(e -> e.setRowState("edit"));
        }
        // 合同条款
        if(ListUtil.isNotEmpty(vo.getClauseList())){
            vo.getClauseList().forEach(e -> e.setRowState("edit"));
        }
        
    }

    public ExecutionVO targetCost(ContractVO contractVO) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setBillType("BT220210000000004");
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.周转材租赁合同.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }
        totalVO.setLinkUrl(frontendBaseHost + "ejc-assistrmat-frontend/#/contract/card?id=" + contractVO.getId());
        
        executionVO.setTotalVO(totalVO);
        
        return executionVO;
    }

    /**
     * 单据推送到供方协同服务
     * @param entity
     * @return
     */
    @Override
    public Boolean pushBillToSupCenter(ContractEntity entity) {
        Boolean syncFlag = pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    /**
     * 将推送至供方的单据作废
     * @param entity
     * @return
     */
    @Override
    public Boolean delPushBill(ContractEntity entity) {
        Boolean delSuc = pushSupUtil.delPushBill((JSONObject) JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
        
    }

    /**
     * 推送合同池
     * @param vo
     * @return
     */
    @Override
    public Boolean pushContract(ContractVO vo) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(vo, data);
            data.setSourceType(ContractTypeEnum.辅料中心周转材租赁合同.getTypeCode());
            data.setContractProperty(Integer.valueOf(SettleEnum.支出.getCode()));

            String cardType = vo.getAddType() == 0 ? "targetCard" : "addCard";
            String url = null;
            if (vo.getSupplementFlag() == 0) {
                url = "/ejc-assistrmat-frontend/#/contract/contractMultiCards?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() +
                        "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus();
            }else {
                url = "/ejc-assistrmat-frontend/#/contract/supplementCard?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() +
                        "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus();
            }
            data.setPcCardUrl(url);
            
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}",vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }
        
        return null;
    }

    @Override
    public String validateContract(Long contractId, String billType, Long billId, String type) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        c1.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("bill_state", new Parameter(QueryParam.IN, "1,3"));
        c2.getParams().put("signature_status", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        c1.getComplexParams().add(c2);

        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("main_contract_id", new Parameter(QueryParam.EQ, contractId));
        queryParam.getComplexParams().add(c1);


        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam2.getComplexParams().add(c1);


        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam3.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));

        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        QueryParam param = BeanMapper.map(queryParam, QueryParam.class);
        QueryParam param2 = BeanMapper.map(queryParam2, QueryParam.class);
        QueryParam param3 = Utils.deepCopy(queryParam3);// 深拷贝
        if(billId != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, billId));
            param2.getParams().put("id", new Parameter(QueryParam.NE, billId));
            param3.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }

        Future<JSONArray> future1 = ListCallable.excute(threadPool, MaterialConstant.补充协议.equals(billType) ? param : queryParam, service); // 补充协议
        Future<JSONArray> future2 = ListCallable.excute(threadPool, MaterialConstant.变更单.equals(billType) ? param2 : queryParam2, changeService); // 变更单
        Future<JSONArray> future3 = ListCallable.excute(threadPool, MaterialConstant.解除单.equals(billType) ? param2 : queryParam2, relieveService); // 解除单
        Future<JSONArray> future4 = ListCallable.excute(threadPool, MaterialConstant.冻结单.equals(billType) ? param3 : queryParam3, freezeService); // 冻结单

        List<ContractEntity> supplementList = new ArrayList<>(); // 补充协议
        List<ChangeEntity> changeList = new ArrayList<>(); // 变更单
        List<ContractRelieveEntity> relieveList = new ArrayList<>(); // 解除单
        List<ContractFreezeEntity> freezeList = new ArrayList<>(); // 冻结单

        try {
            supplementList = JSONObject.parseArray(future1.get().toJSONString(), ContractEntity.class);
            changeList = JSONObject.parseArray(future2.get().toJSONString(), ChangeEntity.class);
            relieveList = JSONObject.parseArray(future3.get().toJSONString(), ContractRelieveEntity.class);
            freezeList = JSONObject.parseArray(future4.get().toJSONString(), ContractFreezeEntity.class);
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }
        if(ListUtil.isNotEmpty(supplementList)){
            throw new BusinessException("当前合同存在非审批通过态或未签章的补充协议，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(changeList)){
            throw new BusinessException("当前合同存在非审批通过态或未签章的变更单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(freezeList)){
            throw new BusinessException("当前合同存在非审批通过态的冻结单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(relieveList)){
            throw new BusinessException("当前合同存在非审批通过态或未签章的解除单，不允许" + type + "!");
        }

        return "校验通过！";
    }

    @Override
    public Boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);

        logger.info("将合同-{}从合同池中删除！", id);
        CommonResponse<String> delDataResp = contractPoolApi.deleteContract(c);
        if(delDataResp.isSuccess()) {
            return true;
        }

        logger.error("将合同-{}从合同池中删除失败, {}！", id, delDataResp.getMsg());
        return false;
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull(watermarkFileId, "水印合同附件不能为空！");
        CommonResponse<String> res = attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            logger.error("删除文件中心水印文件失败，原因：{}，水印文件id：{}", res.getMsg(), watermarkFileId);
            throw new BusinessException("删除文件中心水印文件失败，原因：" + res.getMsg() + "，水印文件id：" + watermarkFileId);
        }
        return true;
    }

    /**
     * 生成合同编码规则
     *
     * @param contractVo 合同vo
     * @return 生成结果
     */
    private String getContractBillCode(ContractVO contractVo) {
        String contractBillCode;
        logger.info("生成编码规则，GenerateBillCodeType=：{}", GenerateBillCodeType);

        if (Objects.equals(contractVo.getSupplementFlag(), ContractVO.CONTRACT_TYPE_SUPPLEMENT)) {
            // 查询补充协议
            LambdaQueryWrapper<ContractEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(ContractEntity::getMainContractId, contractVo.getMainContractId());
            wrapper.in(ContractEntity::getBillState, Arrays.asList(1, 3));
            List<ContractEntity> list = this.list(wrapper);

            String supplementNum = "";
            if (list.size() < 10) {
                supplementNum += "0" + (list.size() + 1);
            }else {
                supplementNum += (list.size() + 1);
            }

            contractBillCode = contractVo.getMainContractCode() + "-2-" + supplementNum;
        }else {
            switch (GenerateBillCodeType) {
                case "common":
                    BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), contractVo);
                    CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                    if (billCode.isSuccess()) {
                        contractBillCode = billCode.getData();
                    } else {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    break;
                case "ynjt":
                    BillCodeParam billCodeParamYnjt = BillCodeParam.build(PURCHASE_CONTRACT_YNJT, InvocationInfoProxy.getTenantid(), contractVo);
                    CommonResponse<String> billCodeFirstPart = billCodeApi.generateBillCode(billCodeParamYnjt);
                    if (!billCodeFirstPart.isSuccess()) {
                        logger.error("保存合同失败，自动生成合同合同失败: {}", billCodeFirstPart.getMsg());
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    // 根据合同基层单位后三位查询查询流水号
                    String orgSub = contractVo.getParentOrgCode().substring(contractVo.getParentOrgCode().length() - 3);
                    CommonSNVO commonSNVO = new CommonSNVO();
                    commonSNVO.setSnLength(4); // 流水号长度
                    commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());  // 租户Id
                    commonSNVO.setDimension(orgSub); // 流水依据
                    commonSNVO.setSourceType("YNJTCLCG"); // 单据业务类型
                    CommonResponse<String> snResp = commonSNAPI.getNext(commonSNVO);
                    if (!snResp.isSuccess()) {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    contractBillCode = billCodeFirstPart.getData() + orgSub + snResp.getData();
                    break;
                default:
                    throw new BusinessException("编码生成失败！");
            }
        }

        return contractBillCode;
    }

}
