package com.ejianc.business.outrmat.calculate.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.outrmat.calculate.bean.OutRmatCalculateEntity;
import com.ejianc.business.outrmat.calculate.service.IOutRmatCalculateService;
import com.ejianc.business.outrmat.calculate.vo.OutRmatCalculateVO;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.service.IOutRmatMaterialService;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.business.pro.rmat.enums.ReceiptsEnum;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("outRmatCalculate")
public class OutRmatCalculateBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IOutRmatCalculateService service;

	@Autowired
	private IOutRmatMaterialService materialService;

    @Autowired
    private IReceiptsApi receiptsApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
        OutRmatCalculateEntity entity = service.selectById(billId);

        if(OutRmatConstant.OUT_RMAT_CONTRACT_RENT_TYPE_IN.equals(entity.getRentType())) { //内租 推周转材
            OutRmatCalculateVO outRmatCalculateVO = BeanMapper.map(entity, OutRmatCalculateVO.class);
            logger.info("推送辅料中心数据outRmatCalculateVO：{}", JSONObject.toJSONString(outRmatCalculateVO));
            outRmatCalculateVO.setOrgId(entity.getProjectDeptId());
            outRmatCalculateVO.setOrgCode(entity.getProjectDeptCode());
            outRmatCalculateVO.setOrgName(entity.getProjectDeptName());
            outRmatCalculateVO.setParentOrgCode(entity.getProjectOrgCode());
            outRmatCalculateVO.setParentOrgId(entity.getProjectOrgId());
            outRmatCalculateVO.setParentOrgName(entity.getProjectOrgName());
            logger.info("推送辅料中心数据"+JSONObject.toJSONString(outRmatCalculateVO)+"----租金计算单");
            CommonResponse<String> response = receiptsApi.receiptsSync((JSONObject) JSONObject.toJSON(outRmatCalculateVO), ReceiptsEnum.租金计算单.getName());
            if(!response.isSuccess()){
                throw new BusinessException(response.getMsg());
            }
        }
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OutRmatCalculateEntity entity = service.selectById(billId);
		// 同一个合同只能存在一个自由态或审批中的单据
		materialService.validateContract(entity.getContractId(), null, null, MaterialConstant.弃审);
		// 校验必须大于最大单据日期
		service.validateTime(BeanMapper.map(entity, OutRmatCalculateVO.class), MaterialConstant.弃审);
		// 是否被其他单据引用
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {//单据未被下游单据引用
			return CommonResponse.error(res.getMsg());
		}
		if(null!=entity.getSettleFlag() && entity.getSettleFlag()==1){
			return CommonResponse.error("被下游引用，不能弃审！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
        // 内租推送供方
        OutRmatCalculateEntity entity = service.selectById(billId);
        if(OutRmatConstant.OUT_RMAT_CONTRACT_RENT_TYPE_IN.equals(entity.getRentType())){
            CommonResponse<String> response = receiptsApi.delReceipts(entity.getId(), ReceiptsEnum.租金计算单.getName());
            if(!response.isSuccess()){
                throw new BusinessException(response.getMsg());
            }
        }
		return CommonResponse.success();
	}

}
