package com.ejianc.business.assist.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.store.bean.AllotInEntity;
import com.ejianc.business.assist.store.bean.AllotOutEntity;
import com.ejianc.business.assist.store.consts.AllocatEnum;
import com.ejianc.business.assist.store.consts.AllocationState;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.mapper.AllotInMapper;
import com.ejianc.business.assist.store.service.IAllotInService;
import com.ejianc.business.assist.store.service.IAllotOutService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.AllotInExportVO;
import com.ejianc.business.assist.store.vo.AllotInVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 调拨入库
 *
 * @author generator
 */
@Service("allotInService")
public class AllotInServiceImpl extends BaseServiceImpl<AllotInMapper, AllotInEntity> implements IAllotInService {
    @Autowired
    private IAllotInService service;

    @Autowired
    private IAllotOutService allotOutService;

    @Autowired
    StoreManageService storeManageService;
    @Autowired
    private IOrgApi iOrgApi;

    /**
     * 确认收料
     * @param vo
     * @return
     */
    @Override
    public CommonResponse<String> sureToReceive(AllotInVO vo) {

        AllotInEntity entity = service.selectById(vo.getId());

        if ("1".equals(entity.getOutAllocaScope())){
            String msg = this.amSureToReceive(vo);
            if (null != msg){
                return CommonResponse.error(msg);
            }
        }else{



        }


        return CommonResponse.success("确认收料成功！");
    }

    @Override
    public String amSureToReceive(AllotInVO vo){
        AllotInEntity entity = service.selectById(vo.getId());
        if (entity == null) {
            return "没有找到该单据！";
        }
        LambdaUpdateWrapper<AllotInEntity> allotinWrapper = new LambdaUpdateWrapper<>();
        allotinWrapper.eq(AllotInEntity::getId, vo.getId());
        allotinWrapper.set(AllotInEntity::getReceiveDate, vo.getReceiveDate());
        allotinWrapper.set(AllotInEntity::getStoreId, vo.getStoreId());
        allotinWrapper.set(AllotInEntity::getStoreName, vo.getStoreName());
        allotinWrapper.set(AllotInEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        allotinWrapper.set(AllotInEntity::getReceiveState, Integer.parseInt(AllocationState.RECEIVED.getCode()));
        allotinWrapper.set(AllotInEntity::getPassDate, vo.getPassDate());
        allotinWrapper.set(AllotInEntity::getReceiverPersonId, vo.getReceiverPersonId());
        allotinWrapper.set(AllotInEntity::getReceiverPerson, vo.getReceiverPerson());
        boolean b = service.update(allotinWrapper);
        //生成调拨入库
        AllotInEntity allot = service.selectById(vo.getId());
        if (CollectionUtils.isNotEmpty(allot.getAllotInDetailList())){
            AllotInVO allotInVO = BeanMapper.map(allot, AllotInVO.class);
            StoreManageVO storeManageVO = vo.getStoreManageVO(allotInVO);
            storeManageService.inOutStore(storeManageVO);
        }

        //会写调拨出库
        if (b) {
            LambdaUpdateWrapper<AllotOutEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(AllotOutEntity::getId, entity.getAllotOutId());
            wrapper.set(AllotOutEntity::getReceiveState, Integer.parseInt(AllocationState.RECEIVED.getCode()));
            wrapper.set(AllotOutEntity::getReceiverPersonId, vo.getReceiverPersonId());
            wrapper.set(AllotOutEntity::getReceiverPerson, vo.getReceiverPerson());
            wrapper.set(AllotOutEntity::getInStoreId, vo.getStoreId());
            wrapper.set(AllotOutEntity::getInStoreName, vo.getStoreName());
            wrapper.set(AllotOutEntity::getReceiveDate, vo.getReceiveDate());
            allotOutService.update(wrapper);
        }

        return null;
    }


    @Override
    public CommonResponse<String> sureToReturn(AllotInVO vo) {

        AllotInEntity entity = service.selectById(vo.getId());

        if ("1".equals(entity.getOutAllocaScope())){
            String msg = this.amSureToReturn(vo);
            if (null != msg){
                return CommonResponse.error(msg);
            }
        }else{



        }

        return CommonResponse.success("确认收料成功！");
    }

    @Override
    public String amSureToReturn(AllotInVO vo){

        AllotInEntity entity = service.selectById(vo.getId());
        if (entity == null) {
            return "没有找到该单据！";
        }
        LambdaUpdateWrapper<AllotInEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(AllotInEntity::getId, entity.getId());
        wrapper.set(AllotInEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        wrapper.set(AllotInEntity::getReceiveState, Integer.parseInt(AllocationState.REJECT.getCode()));
        wrapper.set(AllotInEntity::getReceiveDate, vo.getReceiveDate());
        wrapper.set(AllotInEntity::getReceiverPersonId, vo.getReceiverPersonId());
        wrapper.set(AllotInEntity::getReceiverPerson, vo.getReceiverPerson());
        wrapper.set(AllotInEntity::getReturnReason, vo.getReturnReason());

        boolean update = service.update(wrapper);
        if (update) {

            AllotOutEntity allotOutEntity = allotOutService.selectById(entity.getAllotOutId());
            if (allotOutEntity != null) {
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setStoreId(allotOutEntity.getStoreId());
                storeManageVO.setSourceId(allotOutEntity.getId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材调拨出库);
                storeManageVO.setOutEffectiveON(true);
                ArrayList<Long> longs = new ArrayList<>();
                longs.add(allotOutEntity.getId());
                storeManageVO.setSourceIdsForRollBack(longs);
                storeManageService.inOutStoreRollback(storeManageVO);
            }

            //会写调拨出库 设置为自由态
            LambdaUpdateWrapper<AllotOutEntity> allotOutWrapper = new LambdaUpdateWrapper<>();
            allotOutWrapper.eq(AllotOutEntity::getId, entity.getAllotOutId());
            allotOutWrapper.set(AllotOutEntity::getReceiveState, Integer.parseInt(AllocationState.REJECT.getCode()));
            allotOutWrapper.set(AllotOutEntity::getBillState, BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            allotOutWrapper.set(AllotOutEntity::getReturnReason, vo.getReturnReason());
            allotOutWrapper.set(AllotOutEntity::getReceiverPersonId, vo.getReceiverPersonId());
            allotOutWrapper.set(AllotOutEntity::getReceiverPerson, vo.getReceiverPerson());
            allotOutWrapper.set(AllotOutEntity::getReceiveDate, vo.getReceiveDate());
            allotOutService.update(allotOutWrapper);
        }

        return null;
    }


    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialNames");
        fuzzyFields.add("outProjectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("receiverPerson");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AllotInEntity> list = service.queryList(param);
        List<AllotInExportVO> allotInVos = BeanMapper.mapList(list, AllotInExportVO.class);
        allotInVos.forEach(vo->{
            if (vo.getOutDate()!=null){
                vo.setAllocatDate(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getOutDate()));
            }
            if (vo.getReceiveDate()!=null){
                vo.setAllocatReceiveDate(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getReceiveDate()));
            }
            if (vo.getPassDate()!=null){
                vo.setAllocatPassDate(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getPassDate()));
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if(vo.getReceiveState()!=null){
                if (Integer.valueOf(AllocationState.TO_RECEIVING.getCode()).equals(vo.getReceiveState())){
                    vo.setReceiveStateName(AllocationState.TO_RECEIVING.getDescription());
                }
                else if (Integer.valueOf(AllocationState.RECEIVED.getCode()).equals(vo.getReceiveState())){
                    vo.setReceiveStateName(AllocationState.RECEIVED.getDescription());
                }
                else if (Integer.valueOf(AllocationState.REJECT.getCode()).equals(vo.getReceiveState())){
                    vo.setReceiveStateName(AllocationState.REJECT.getDescription());
                }
            }
            if (vo.getAllocatType()!=null){
                if (Integer.valueOf(AllocatEnum.ASSETS.getCode()).equals(vo.getAllocatType())){
                    vo.setAllocatTypeName(AllocatEnum.ASSETS.getDescription());
                }
                else {
                    vo.setAllocatTypeName(AllocatEnum.HOMEMADE.getDescription());
                }
            }
        });

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", allotInVos);
        ExcelExport.getInstance().export("allocationInExport.xlsx", beans, response);
    }
}
