/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.calculate.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.outrmat.calculate.bean.OutRmatCalculateEntity;
import com.ejianc.business.outrmat.calculate.service.IOutRmatCalculateService;
import com.ejianc.business.outrmat.calculate.vo.OutRmatCalculateVO;
import com.ejianc.business.outrmat.contract.service.IOutRmatMaterialService;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.business.pro.rmat.enums.ReceiptsEnum;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRmatCalculate")
public class OutRmatCalculateBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOutRmatCalculateService service;
    @Autowired
    private IOutRmatMaterialService materialService;
    @Autowired
    private IReceiptsApi receiptsApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutRmatCalculateEntity entity = (OutRmatCalculateEntity)((Object)this.service.selectById(billId));
        if ("1".equals(entity.getRentType())) {
            OutRmatCalculateVO outRmatCalculateVO = (OutRmatCalculateVO)BeanMapper.map((Object)((Object)entity), OutRmatCalculateVO.class);
            this.logger.info("\u63a8\u9001\u8f85\u6599\u4e2d\u5fc3\u6570\u636eoutRmatCalculateVO\uff1a{}", (Object)JSONObject.toJSONString((Object)outRmatCalculateVO));
            outRmatCalculateVO.setOrgId(entity.getProjectDeptId());
            outRmatCalculateVO.setOrgCode(entity.getProjectDeptCode());
            outRmatCalculateVO.setOrgName(entity.getProjectDeptName());
            outRmatCalculateVO.setParentOrgCode(entity.getProjectOrgCode());
            outRmatCalculateVO.setParentOrgId(entity.getProjectOrgId());
            outRmatCalculateVO.setParentOrgName(entity.getProjectOrgName());
            this.logger.info("\u63a8\u9001\u8f85\u6599\u4e2d\u5fc3\u6570\u636e" + JSONObject.toJSONString((Object)outRmatCalculateVO) + "----\u79df\u91d1\u8ba1\u7b97\u5355");
            CommonResponse response = this.receiptsApi.receiptsSync((JSONObject)JSONObject.toJSON((Object)outRmatCalculateVO), ReceiptsEnum.\u79df\u91d1\u8ba1\u7b97\u5355.getName());
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutRmatCalculateEntity entity = (OutRmatCalculateEntity)((Object)this.service.selectById(billId));
        this.materialService.validateContract(entity.getContractId(), null, null, "\u5f03\u5ba1");
        this.service.validateTime((OutRmatCalculateVO)BeanMapper.map((Object)((Object)entity), OutRmatCalculateVO.class), "\u5f03\u5ba1");
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        if (null != entity.getSettleFlag() && entity.getSettleFlag() == 1) {
            return CommonResponse.error((String)"\u88ab\u4e0b\u6e38\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse response;
        OutRmatCalculateEntity entity = (OutRmatCalculateEntity)((Object)this.service.selectById(billId));
        if ("1".equals(entity.getRentType()) && !(response = this.receiptsApi.delReceipts(entity.getId(), ReceiptsEnum.\u79df\u91d1\u8ba1\u7b97\u5355.getName())).isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        return CommonResponse.success();
    }
}

