/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.service.impl;

import com.ejianc.business.assist.store.bean.HandleDetailEntity;
import com.ejianc.business.assist.store.bean.HandleEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.IHandleService;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="handle")
public class HandleBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IStoreCheckService checkService;
    @Autowired
    private IHandleService handleService;
    @Autowired
    private StoreManageService storeManageService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(billId);
        this.handleService.handleInOut(longs, true);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse commonResponse;
        HandleEntity handleEntity = (HandleEntity)((Object)this.handleService.selectById(billId));
        if (handleEntity != null && !(commonResponse = this.checkService.checkByDate(handleEntity.getStoreId(), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)handleEntity.getHandleDate()))).isSuccess()) {
            return commonResponse;
        }
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        HandleEntity entity = (HandleEntity)((Object)this.handleService.selectById(billId));
        List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
        Boolean checkFlag = false;
        for (HandleDetailEntity item : handleSubList) {
            if (item.getHandleNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            checkFlag = true;
            break;
        }
        if (checkFlag.booleanValue()) {
            SourceIds.add(billId);
            storeManageVO.setSourceId(billId);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess()) {
                return CommonResponse.error((String)storeManageVOCommonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

