package com.ejianc.business.assist.rmat.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.assist.rmat.bean.BatchPlanDetailEntity;
/**
 * 周转材批次计划
 * 
 * @author generator
 * 
 */
 @TableName("ejc_assistrmat_batch_plan")
public class BatchPlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="estimated_mny")
    private BigDecimal estimatedMny; // 暂估金额
    @TableField(value="estimated_mny_no_tax")
    private BigDecimal estimatedMnyNoTax; // 暂估金额（无税）
    @TableField(value="tender_status")
    private Integer tenderStatus; // 招标状态,0-待采购，1-采购中，2-已采购
    @TableField(value="category_name")
    private String categoryName; // 材料分类名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(exist = false)
    private String code;
    @TableField(exist = false)
    private String name;

    @TableField(value="apply_date")
    private Date applyDate; // 申请日期
    @TableField(value="rent_type")
    private Integer rentType; // 计租方式/租赁方式(0-日租,1-月租,2-工程量租)

    @TableField(value="rental_type")
    private Integer rentalType; // 出租运输方式(1-承租方,2-租赁方)
    @TableField(value="back_type")
    private Integer backType; // 归还运输方式(1-承租方,2-租赁方)
    @TableField(value="rental_stacking")
    private Integer rentalStacking; // 出租堆码(1-承租方,2-租赁方)
    @TableField(value="back_stacking")
    private Integer backStacking; // 归还堆码堆码(1-承租方,2-租赁方)

    @TableField(value="value_type")
    private Integer valueType; // 计价方式(0-固定单价,1-浮动单价,2-固定总额)
    @TableField(value="standard")
    private String standard; // 质量标准
    @TableField(value="payment_type")
    private String paymentType; // 付款方式 1-500字


    
    
    @TableField(exist=false)
    @SubEntity(serviceName="batchPlanDetailService",pidName = "batchId")
    private List<BatchPlanDetailEntity> detailList = new ArrayList<>(); // 周转材批次计划-清单
    @TableField(exist=false)
    @SubEntity(serviceName="batchPlanRepairService",pidName = "batchId")
    private List<BatchPlanRepairEntity> repairList = new ArrayList<>(); // 周转材批次计划-维修标准
    @TableField(exist=false)
    @SubEntity(serviceName="batchPlanScrapService",pidName = "batchId")
    private List<BatchPlanScrapEntity> scrapList = new ArrayList<>(); // 周转材批次计划-报废标准

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getEstimatedMny() {
        return estimatedMny;
    }

    public void setEstimatedMny(BigDecimal estimatedMny) {
        this.estimatedMny = estimatedMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }


    public List<BatchPlanDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<BatchPlanDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Integer getTenderStatus() {
        return tenderStatus;
    }

    public void setTenderStatus(Integer tenderStatus) {
        this.tenderStatus = tenderStatus;
    }

    public Integer getRentType() {
        return rentType;
    }

    public void setRentType(Integer rentType) {
        this.rentType = rentType;
    }

    public Integer getRentalType() {
        return rentalType;
    }

    public void setRentalType(Integer rentalType) {
        this.rentalType = rentalType;
    }

    public Integer getBackType() {
        return backType;
    }

    public void setBackType(Integer backType) {
        this.backType = backType;
    }

    public Integer getRentalStacking() {
        return rentalStacking;
    }

    public void setRentalStacking(Integer rentalStacking) {
        this.rentalStacking = rentalStacking;
    }

    public Integer getBackStacking() {
        return backStacking;
    }

    public void setBackStacking(Integer backStacking) {
        this.backStacking = backStacking;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public String getStandard() {
        return standard;
    }

    public void setStandard(String standard) {
        this.standard = standard;
    }

    public List<BatchPlanRepairEntity> getRepairList() {
        return repairList;
    }

    public void setRepairList(List<BatchPlanRepairEntity> repairList) {
        this.repairList = repairList;
    }

    public List<BatchPlanScrapEntity> getScrapList() {
        return scrapList;
    }

    public void setScrapList(List<BatchPlanScrapEntity> scrapList) {
        this.scrapList = scrapList;
    }

    public BigDecimal getEstimatedMnyNoTax() {
        return estimatedMnyNoTax;
    }

    public void setEstimatedMnyNoTax(BigDecimal estimatedMnyNoTax) {
        this.estimatedMnyNoTax = estimatedMnyNoTax;
    }

    public String getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }
}
