package com.ejianc.business.outrmat.contract.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractVO;
import com.ejianc.business.outrmat.contract.vo.record.OutRmatContractSupplementRecordVO;
import com.ejianc.business.pro.pricelib.vo.PriceContractVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 周转材租赁合同
 * 
 * @author generator
 * 
 */
public interface IOutRmatContractService extends IBaseService<OutRmatContractEntity> {


    OutRmatContractVO saveOrUpdate(OutRmatContractVO saveOrUpdateVO, String authority);

    OutRmatContractVO queryDetail(Long id);

    String delete(List<OutRmatContractVO> vos);
    
    JSONObject pageList(QueryParam param);

    Map<String,Object> countContractAmount(QueryParam param);

    Boolean addSupplementFlag(Long id);

    OutRmatContractSupplementRecordVO querySupplementRecord(Long id);

    Boolean pushBillToSupCenter(OutRmatContractEntity entity);

    Boolean delPushBill(OutRmatContractEntity entity);

    /**
     * 推送合同池
     * @param vo
     * @return
     */
    Boolean pushContract(OutRmatContractVO vo);

    String validateContract(Long contractId, String billType, Long billId, String type);

    Boolean delContractFromPool(Long id);

    /**
     * 删除文件中心水印文件
     *
     * @param watermarkFileId 水印合同附件id
     * @return boolean 是否删除标识
     */
    boolean delWatermarkContractFile(Long watermarkFileId);

    /**
     * 修改合同授权委托书签订状态
     *
     * @param proxyId   合同授权委托书id
     * @param signState 签订状态1-未签订，2-已签订
     */
    void updateProxyContract(Long proxyId, Integer signState);

    /**
     * 推送合同数据到周转材（租出内租合同才推送）
     *
     * @param vo      合同vo
     * @param optType 操作类型：1推送，2删除
     * @param optBill 操作单据
     * @param rentType  租赁类型
     */
    void pushContractToRmat(JSONObject vo, Integer optType, String optBill,String rentType);

    List<PriceContractVO> queryPriceContractDataByAssistRmatOut(String initFlag);
}
