package com.ejianc.business.assist.rmat.controller.api;

import com.ejianc.business.assist.rmat.service.IBatchPlanService;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/batPlan/")
@Api(value = "批次计划API接口", tags = {"批次计划API接口"})
public class PurchaseBatchPlanApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBatchPlanService service;

    @ApiOperation("引用/释放/引用完成采购计划")
    @RequestMapping(value = "/updateBatPlanQuote", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateBatPlanQuote(@RequestParam("idList") List<String> idList,
                                                     @RequestParam("planState") Integer planState) {
        logger.info("修改采购计划【{}】状态为：[{}](计划状态（0-待采购；1-采购中；2-采购完成）)", idList == null ? null :
                idList.toString(), planState);
        service.updateBatPlanByQuoteType(idList, planState);
        return CommonResponse.success("操作成功！");
    }
}
