package com.ejianc.business.assist.rmat.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.vo.ContractVO;
import com.ejianc.business.assist.rmat.vo.record.SupplementRecordVO;
import com.ejianc.business.pro.pricelib.vo.PriceContractVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 周转材租赁合同
 * 
 * @author generator
 * 
 */
public interface IContractService extends IBaseService<ContractEntity> {


    ContractVO saveOrUpdate(ContractVO saveOrUpdateVO,String authority);

    ContractVO queryDetail(Long id);

    String delete(List<ContractVO> vos);
    
    JSONObject pageList(QueryParam param);

    Map<String,Object> countContractAmount(QueryParam param);

    Boolean addSupplementFlag(Long id);

    SupplementRecordVO querySupplementRecord(Long id);

    Boolean pushBillToSupCenter(ContractEntity entity);

    Boolean delPushBill(ContractEntity entity);

    /**
     * 推送合同池
     * @param vo
     * @return
     */
    Boolean pushContract(ContractVO vo);

    String validateContract(Long contractId, String billType, Long billId, String type);

    Boolean delContractFromPool(Long id);

    /**
     * 删除文件中心水印文件
     *
     * @param watermarkFileId 水印合同附件id
     * @return boolean 是否删除标识
     */
    boolean delWatermarkContractFile(Long watermarkFileId);

    List<PriceContractVO> queryPriceContractDataByAssistRmatIn(String initFlag);

    ParamsCheckVO checkParams(ContractVO vo);

}
