package com.ejianc.business.outrmat.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.assist.rmat.vo.StoreNumVO;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractDailyRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractMonthRentEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractNumRentEntity;
import com.ejianc.business.outrmat.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.outrmat.contract.enums.SignatureStatusEnum;
import com.ejianc.business.outrmat.contract.service.*;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractRentRefVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractVO;
import com.ejianc.business.outrmat.contract.vo.record.OutRmatContractSupplementRecordVO;
import com.ejianc.business.outrmat.utils.PageUtil;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 周转材租赁合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outRmatContract")
public class OutRmatContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IBillTypeApi billTypeApi;
   
    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    
    @Autowired
    private IOutRmatContractService service;

    @Autowired
    private IOutRmatContractDailyRentService dailyRentService;

    @Autowired
    private IOutRmatContractMonthRentService monthRentService;

    @Autowired
    private IOutRmatContractNumRentService numRentService;

    @Autowired
    private IOutRmatContractRelieveService relieveService;

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private IShareMaterialApi materialApi;
    
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutRmatContractVO> saveOrUpdate(@RequestBody OutRmatContractVO saveOrUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
    	return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveOrUpdateVO,authority));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRmatContractVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryDetail(id));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRmatContractVO> vos) {
        
        return CommonResponse.success(service.delete(vos));
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", service.pageList(param));
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        CommonResponse<JSONObject> commonResponse = this.queryList(param);
        List<OutRmatContractEntity> list = (List<OutRmatContractEntity>) commonResponse.getData().get("records");

        List<OutRmatContractVO> returnList = BeanMapper.mapList(list, OutRmatContractVO.class);
        if (ListUtil.isNotEmpty(returnList)) {
            for (OutRmatContractVO vo : returnList) {
                // 合同状态
                if (StringUtils.isBlank(vo.getPerformanceStatus())) {
                    vo.setPerformanceStatus(PerformanceStatusEnum.未签订.getDescription());
                }else {
                    vo.setPerformanceStatus(PerformanceStatusEnum.getEnumByCode(vo.getPerformanceStatus()).getDescription());
                }
                
                // 签章状态
                if (vo.getSignatureStatus() == null) {
                    vo.setSignatureStatusName(SignatureStatusEnum.未签章.getDescription());
                }else {
                    vo.setSignatureStatusName(SignatureStatusEnum.getEnumByCode(vo.getSignatureStatus()).getDescription());
                }
                // 合同履约状态
                vo.setPerformanceStatus(PerformanceStatusEnum.getEnumByCode(vo.getPerformanceStatus()).getDescription());
                // 单据状态名称
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", returnList);
        ExcelExport.getInstance().export("out-arri-contract-export.xlsx", beans, response);
    }

    @GetMapping(value = "/outRmatContractRef")
    @ResponseBody
    public CommonResponse<IPage<ContractPoolVO>> outRmatContractRef(@RequestParam("pageNumber") Integer pageNumber,
                                                                    @RequestParam("pageSize") Integer pageSize,
                                                                    String searchText,
                                                                    String searchObject,
                                                                    String condition,
                                                                    String relyCondition) throws Exception {
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchObject(searchObject);
        param.setSearchText(searchText);
        param.setFuzzyFields(Arrays.asList("billCode", "contractName", "projectName", "firstPartyName", "supplierName"));

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank(condition)) {
            JSONObject conditionJson = JSONObject.parseObject(condition);
            // 根据项目ID查询
            String projectId = conditionJson.getString("projectId");
            String orgId = conditionJson.getString("orgId");
            String orgType = conditionJson.getString("orgType");
            String rentType = conditionJson.getString("rentType");
            if(StringUtils.isBlank(projectId) && StringUtils.isBlank(orgId) && StringUtils.isBlank(orgType)) {
                return CommonResponse.error("查询失败，缺少查询参数projectId或组织过滤参数-orgId,orgType！");
            }

            if (StringUtils.isNotBlank(projectId)){
                logger.info("condition中projectId：{}", projectId);
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, Long.valueOf(projectId)));
            } else {
                if(StringUtils.isBlank(orgId)) {
                    return CommonResponse.error("查询失败，缺少组织过滤参数-orgId！");
                }
                if(StringUtils.isBlank(orgType)) {
                    return CommonResponse.error("查询失败，缺少组织过滤参数-orgType！");
                }
                //查询本下范围内日的合同
                if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(orgType)) {
                    //按项目部过滤
                    param.getParams().put("orgId", new Parameter(QueryParam.EQ, Long.valueOf(orgId)));
                } else {
                    //按组织过滤
                    CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentIdWithoutProjectDept(Long.valueOf(orgId));
                    if(!orgResp.isSuccess()) {
                        logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                        return CommonResponse.error("查询失败，获取组织信息失败！");
                    }
                    param.getParams().put("orgId", new Parameter(QueryParam.IN,
                            orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                }
            }

            // 租赁方式
            if (StringUtils.isNotBlank(rentType)) {
                param.getParams().put("rentType", new Parameter(QueryParam.EQ, rentType));
            }

            // 根据合同履约状态查询
            String performanceStatusParam = conditionJson.getString("performanceStatus");
            if(StringUtils.isNotBlank(performanceStatusParam)) {
                param.getParams().put("performanceStatus", new Parameter(QueryParam.IN, performanceStatusParam.split(",")));
            } else {
                param.getParams().put("performanceStatus", new Parameter(QueryParam.EQ, PerformanceStatusEnum.履约中.getCode()));
            }
            param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        }

        IPage<OutRmatContractEntity> page = service.queryPage(param,false);
        List<ContractPoolVO> contractLists = new ArrayList<>();
        ContractPoolVO tmp = null;
        if(CollectionUtils.isNotEmpty(page.getRecords())) {
            for(OutRmatContractEntity c : page.getRecords()) {
                tmp = BeanConvertorUtil.convert(BeanMapper.map(c, OutRmatContractVO.class), ContractPoolVO.class);
                tmp.setSourceType(ContractTypeEnum.辅料中心周转材租出合同.getTypeCode());
                tmp.setSourceTypeName(ContractTypeEnum.辅料中心周转材租出合同.getTypeName());
                contractLists.add(tmp);
            }
        }
        IPage<ContractPoolVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(contractLists);

        return CommonResponse.success(pageData);
    }
    
    /**
     * @Description 周转材租赁外租合同参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/arriContractRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRmatContractVO>> arriContractRef(@RequestParam Integer pageNumber
            , @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }

        
        param.getParams().put("performanceStatus", new Parameter(QueryParam.EQ, PerformanceStatusEnum.履约中.getCode()));
        param.getParams().put("changeStatus", new Parameter(QueryParam.IN, Arrays.asList(1,3)));

        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("orgId")) {
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            // 租赁方式
            if (condition.contains("rentType")) {
                param.getParams().put("rentType", new Parameter(QueryParam.EQ, conditionMap.get("rentType")));
            }
        }

        // 设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);
        
        IPage<OutRmatContractEntity> page = service.queryPage(param,false);
        IPage<OutRmatContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OutRmatContractVO> voList = BeanMapper.mapList(page.getRecords(), OutRmatContractVO.class);
        for (OutRmatContractVO vo :voList) {
            vo.setRentTypeName(OutRmatConstant.OUT_RMAT_CONTRACT_RENT_TYPE_OUT.equals(vo.getRentType()) ? "外租" : "内租");
        }
        pageData.setRecords(voList);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @Description 周转材租赁外租合同日租、月租、工程量租明细参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/arriContractRentRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRmatContractRentRefVO>> arriContractRentRef(@RequestParam Integer pageNumber
            , @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        
        QueryParam param = new QueryParam();
        param.setPageSize(-1);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("materialName");
        param.getFuzzyFields().add("materialTypeName");
        param.getFuzzyFields().add("materialCode");
        param.getFuzzyFields().add("spec");
        param.getFuzzyFields().add("unitName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 只要明细
        param.getParams().put("materialId", new Parameter(QueryParam.NE, null));
//        param.getParams().put("row_type", new Parameter(QueryParam.EQ, 1));

        Long contractId = null;
        Long storeId = null;
        Long orgId = null;
        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                contractId = Long.valueOf(conditionMap.get("contractId").toString());
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
            }else {
                return CommonResponse.error("当前传入合同id为空！");
            }
            if (null != conditionMap.get("storeId")) {
                storeId = Long.valueOf(conditionMap.get("storeId").toString());
            }
            if (null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
        }
        
        param.getOrderMap().put("createTime", "desc");
        
        //  查询日租明细
        IPage<OutRmatContractDailyRentEntity> dailyRentEntityIPage = dailyRentService.queryPage(param, false);
        List<OutRmatContractDailyRentEntity> dailyRentEntityList = dailyRentEntityIPage.getRecords();
        for (OutRmatContractDailyRentEntity entity : dailyRentEntityList) {
            entity.setRentCalculationType("0");
        }
        
        //  查询月租明细
        IPage<OutRmatContractMonthRentEntity> monthRentEntityIPage = monthRentService.queryPage(param, false);
        List<OutRmatContractMonthRentEntity> monthRentEntityList = monthRentEntityIPage.getRecords();
        for (OutRmatContractMonthRentEntity entity : monthRentEntityList) {
            entity.setRentCalculationType("1");
        }
        
        //  查询工程量租明细
        IPage<OutRmatContractNumRentEntity> numRentEntityIPage = numRentService.queryPage(param, false);
        List<OutRmatContractNumRentEntity> numRentEntityList = numRentEntityIPage.getRecords();
        for (OutRmatContractNumRentEntity entity : numRentEntityList) {
            entity.setRentCalculationType("2");
        }
        
        List<OutRmatContractRentRefVO> rentRefVOList = new ArrayList<>();
        rentRefVOList.addAll(BeanMapper.mapList(dailyRentEntityList, OutRmatContractRentRefVO.class));
        rentRefVOList.addAll(BeanMapper.mapList(monthRentEntityList, OutRmatContractRentRefVO.class));
        rentRefVOList.addAll(BeanMapper.mapList(numRentEntityList, OutRmatContractRentRefVO.class));
        rentRefVOList = rentRefVOList.stream().sorted(Comparator.comparing(OutRmatContractRentRefVO::getCreateTime).reversed()).collect(Collectors.toList());
        
        rentRefVOList.forEach(e->{e.setRentCalculationTypeName(CommonConstant.CONTRACT_RENT_CALCULATION_TYPE.get(e.getRentCalculationType()));});

        List<OutRmatContractRentRefVO> resultList = PageUtil.listToPage(rentRefVOList, pageNumber, pageSize);

        // 给库存可用量赋值
        this.getStoreNum(storeId, orgId, resultList);

        IPage<OutRmatContractRentRefVO> page = new Page<>();
        page.setRecords(resultList);
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        page.setTotal(resultList.size());
        
        return CommonResponse.success("查询参照数据成功！", page);
    }

    /**
     * @Description 周转材租赁外租合同日租、月租、工程量租 大类参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/arriContractRentTypeRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRmatContractRentRefVO>> arriContractRentTypeRef(@RequestParam Integer pageNumber
            , @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {

        QueryParam param = new QueryParam();
        param.setPageSize(-1);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("materialName");
        param.getFuzzyFields().add("materialTypeName");
        param.getFuzzyFields().add("materialCode");
        param.getFuzzyFields().add("spec");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 只要明细
        param.getParams().put("materialId", new Parameter(QueryParam.EQ, null));
//        param.getParams().put("row_type", new Parameter(QueryParam.EQ, 1));

        Long contractId = null;
        Long storeId = null;
        Long orgId = null;
        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                contractId = Long.valueOf(conditionMap.get("contractId").toString());
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
            }else {
                return CommonResponse.error("当前传入合同id为空！");
            }
            if (null != conditionMap.get("storeId")) {
                storeId = Long.valueOf(conditionMap.get("storeId").toString());
            }
            if (null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
        }

        param.getOrderMap().put("createTime", "desc");
        List<Long> typrList = new ArrayList<>();
        Map<Long,OutRmatContractRentRefVO> mapType = new HashMap<>();
        List<OutRmatContractRentRefVO> rentRefVOList = new ArrayList<>();
        //  查询日租明细
        IPage<OutRmatContractDailyRentEntity> dailyRentEntityIPage = dailyRentService.queryPage(param, false);
        List<OutRmatContractDailyRentEntity> dailyRentEntityList = dailyRentEntityIPage.getRecords();
        for (OutRmatContractDailyRentEntity entity : dailyRentEntityList) {
            entity.setRentCalculationType("0");
            typrList.add(entity.getMaterialTypeId());
            if(!mapType.containsKey(entity.getMaterialTypeId())){
                mapType.put(entity.getMaterialTypeId(),BeanMapper.map(entity,OutRmatContractRentRefVO.class));
            }
        }

        //  查询月租明细
        IPage<OutRmatContractMonthRentEntity> monthRentEntityIPage = monthRentService.queryPage(param, false);
        List<OutRmatContractMonthRentEntity> monthRentEntityList = monthRentEntityIPage.getRecords();
        for (OutRmatContractMonthRentEntity entity : monthRentEntityList) {
            entity.setRentCalculationType("1");
            typrList.add(entity.getMaterialTypeId());
            if(!mapType.containsKey(entity.getMaterialTypeId())){
                mapType.put(entity.getMaterialTypeId(),BeanMapper.map(entity,OutRmatContractRentRefVO.class));
            }
        }

        //  查询工程量租明细
        IPage<OutRmatContractNumRentEntity> numRentEntityIPage = numRentService.queryPage(param, false);
        List<OutRmatContractNumRentEntity> numRentEntityList = numRentEntityIPage.getRecords();
        for (OutRmatContractNumRentEntity entity : numRentEntityList) {
            entity.setRentCalculationType("2");
            typrList.add(entity.getMaterialTypeId());
            if(!mapType.containsKey(entity.getMaterialTypeId())){
                mapType.put(entity.getMaterialTypeId(),BeanMapper.map(entity,OutRmatContractRentRefVO.class));
            }
        }

        if(CollectionUtils.isNotEmpty(typrList)){
            CommonResponse<List<MaterialVO>> respType =  materialApi.queryMaterialByCategoryId(typrList);
            if(respType.isSuccess() && CollectionUtils.isNotEmpty(respType.getData())){
                List<MaterialVO> listType = respType.getData();
                if(CollectionUtils.isNotEmpty(listType)){
                    listType.forEach(e->{
                        OutRmatContractRentRefVO outRmatContractRentRefVO = BeanMapper.map(mapType.get(e.getCategoryId()),OutRmatContractRentRefVO.class);
                        outRmatContractRentRefVO.setId(e.getId());//分类id设置成材料id,防止参照显示不出来
                        outRmatContractRentRefVO.setMaterialId(e.getId());
                        outRmatContractRentRefVO.setMaterialCode(e.getCode());
                        outRmatContractRentRefVO.setSpec(e.getSpec());
                        outRmatContractRentRefVO.setUnitMId(e.getUnitId());
                        outRmatContractRentRefVO.setUnitMName(e.getUnitName());
                        outRmatContractRentRefVO.setMaterialName(e.getName());
                        rentRefVOList.add(outRmatContractRentRefVO);
                    });
                }
            }
        }

//        rentRefVOList = rentRefVOList.stream().sorted(Comparator.comparing(OutRmatContractRentRefVO::getCreateTime).reversed()).collect(Collectors.toList());

        rentRefVOList.forEach(e->{e.setRentCalculationTypeName(CommonConstant.CONTRACT_RENT_CALCULATION_TYPE.get(e.getRentCalculationType()));});





        List<OutRmatContractRentRefVO> resultList = PageUtil.listToPage(rentRefVOList, pageNumber, pageSize);

        // 给库存可用量赋值
        this.getStoreNum(storeId, orgId, resultList);

        IPage<OutRmatContractRentRefVO> page = new Page<>();
        page.setRecords(resultList);
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        page.setTotal(rentRefVOList.size());

        return CommonResponse.success("查询参照数据成功！", page);
    }
    /**
     * 给库存可用量赋值
     * @param storeId
     * @param orgId
     * @param list
     */
    private void getStoreNum(Long storeId, Long orgId, List<OutRmatContractRentRefVO> list) {
//        OutRmatContractEntity contract = service.selectById(contractId);
        List<StoreNumVO> vos = new ArrayList<>();
        for(OutRmatContractRentRefVO detail : list){
            StoreNumVO vo = new StoreNumVO();
            vo.setOrgId(orgId);
            vo.setMaterialId(detail.getMaterialId());
            vo.setUnitMId(detail.getUnitMId());
            vo.setUnitId(detail.getUnitId());
            vo.setStoreId(orgId);
            vo.setSourceType(RmatCommonConsts.RENT_OUT);
            if(storeId != null){
                vo.setStoreId(storeId);
                vo.setSourceType(RmatCommonConsts.PURCHASE_OUT);
            }
            vos.add(vo);
        }
        vos = materialService.getStoreNum(vos);
        Map<String, StoreNumVO> storeMap = vos.stream().collect(Collectors.toMap(x->x.getStoreId() + "|" + x.getMaterialId(), x->x));
        for(OutRmatContractRentRefVO detail : list){
            String key = storeId != null ? storeId + "|" + detail.getMaterialId() : orgId + "|" + detail.getMaterialId();
            if(storeMap.containsKey(key)){
                detail.setSurplusCount(storeMap.get(key).getAssistNum());
                detail.setSurplusM(storeMap.get(key).getStoreNum());
                detail.setTransScale(storeMap.get(key).getTransScale());
                detail.setDeviationRate(storeMap.get(key).getDeviationRate());
            }
        }
    }
    
    
    /**
     * 根据合同Id查询合同文件管理信息
     *
     * @param contractId 合同Id
     * @return
     */
    @GetMapping(value = "/getContractFileMgrInfo")
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value = "contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        CommonResponse<BillTypeVO> billTypeResp = billTypeApi.getByRefCode(CommonConstant.OUT_RMAT_CONTRACT_REFCODE);
        if(!billTypeResp.isSuccess()) {
            logger.error("根据refCode-{}查询对应元数据失败, 原因：{}", CommonConstant.OUT_RMAT_CONTRACT_REFCODE, billTypeResp.getMsg());
            return CommonResponse.error("查询元数据信息失败");
        }

        OutRmatContractEntity outRmatContractEntity = service.selectById(contractId);
        CommonResponse<TemplateCategoryVO> categoryResp = templateCategoryApi.queryTmplCategoryById(outRmatContractEntity.getContractCategoryId());
        if(!categoryResp.isSuccess()) {
            logger.error("根据合同类别I的-{}查询对应合同类别信息失败, 原因：{}", outRmatContractEntity.getContractCategoryId(), categoryResp.getMsg());
            return CommonResponse.error("查询合同类别信息失败");
        }
        TemplateCategoryVO category = categoryResp.getData();
        resp.put("contactId", outRmatContractEntity.getId());
        resp.put("contractBillTypeCode", billTypeResp.getData().getBillCode());
        resp.put("contractCategoryId", category.getId());
        resp.put("boBillType", category.getBillTypeCode());

        return CommonResponse.success("查询成功！", resp);
    }

    /**
     * 判断当前合同是否能新增补充协议
     * @param id
     * @return
     */
    @RequestMapping(value = "/addSupplementFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = service.addSupplementFlag(id);
        if (flag){
            return CommonResponse.success("校验通过，该合同可以新增补充协议！");
        }
        return CommonResponse.error("当前合同存在未生效的补充协议，不能新增！");
    }

    /**
     * 合同补充协议历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRmatContractSupplementRecordVO> querySupplementRecord(@RequestParam Long id) {
        OutRmatContractSupplementRecordVO vo = service.querySupplementRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 判断当前合同能否新增合同解除单据
     * @param id 合同主键
     * @return boolean
     */
    @RequestMapping(value = "/addRelieveFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> addRelieveFlag(Long id) {
        Boolean flag = relieveService.addRelieveFlag(id);
        return CommonResponse.success("校验该合同新增合同解除单据成功！", flag);
    }
    
    /**
     * 辅料中心租入合同分类参照
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/arriContractCategoryRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OutRmatContractRentRefVO>> arriContractCategoryRef(@RequestParam("contractId") Long contractId,
                @RequestParam(value = "storeId", required = false) Long storeId) {
        QueryParam param = new QueryParam();
        
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("row_type", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        param.getOrderMap().put("createTime", "desc");

        //  查询日租明细
        IPage<OutRmatContractDailyRentEntity> dailyRentEntityIPage = dailyRentService.queryPage(param, false);
        List<OutRmatContractDailyRentEntity> dailyRentEntityList = dailyRentEntityIPage.getRecords();
        for (OutRmatContractDailyRentEntity entity : dailyRentEntityList) {
            entity.setRentCalculationType("0");
        }

        //  查询月租明细
        IPage<OutRmatContractMonthRentEntity> monthRentEntityIPage = monthRentService.queryPage(param, false);
        List<OutRmatContractMonthRentEntity> monthRentEntityList = monthRentEntityIPage.getRecords();
        for (OutRmatContractMonthRentEntity entity : monthRentEntityList) {
            entity.setRentCalculationType("1");
        }

        //  查询工程量租明细
        IPage<OutRmatContractNumRentEntity> numRentEntityIPage = numRentService.queryPage(param, false);
        List<OutRmatContractNumRentEntity> numRentEntityList = numRentEntityIPage.getRecords();
        for (OutRmatContractNumRentEntity entity : numRentEntityList) {
            entity.setRentCalculationType("2");
        }

        List<OutRmatContractRentRefVO> rentRefVOList = new ArrayList<>();
        rentRefVOList.addAll(BeanMapper.mapList(dailyRentEntityList, OutRmatContractRentRefVO.class));
        rentRefVOList.addAll(BeanMapper.mapList(monthRentEntityList, OutRmatContractRentRefVO.class));
        rentRefVOList.addAll(BeanMapper.mapList(numRentEntityList, OutRmatContractRentRefVO.class));

        // 将合同大类转换成物料明细
        rentRefVOList = this.getMaterialByCategory(rentRefVOList);

        rentRefVOList = rentRefVOList.stream().sorted(Comparator.comparing(OutRmatContractRentRefVO::getCreateTime).reversed()).collect(Collectors.toList());

        rentRefVOList.forEach(e->{e.setRentCalculationTypeName(CommonConstant.CONTRACT_RENT_CALCULATION_TYPE.get(e.getRentCalculationType()));});

        // 给库存可用量赋值
        this.getStoreNum(storeId, contractId, rentRefVOList);

        return CommonResponse.success("查询参照数据成功！", rentRefVOList);
    }

    /**
     * 将合同大类转换成物料明细
     * @param rentRefVOList
     * @return
     */
    private List<OutRmatContractRentRefVO> getMaterialByCategory(List<OutRmatContractRentRefVO> rentRefVOList) {
        Map<Long, OutRmatContractRentRefVO> rentRefVOMap = rentRefVOList.stream().collect(Collectors.toMap(OutRmatContractRentRefVO::getMaterialTypeId, x->x));
        rentRefVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(rentRefVOMap.keySet())){
            CommonResponse<List<MaterialVO>> materialResp = materialApi.queryMaterialByCategoryId(new ArrayList<>(rentRefVOMap.keySet()));
            if(materialResp.isSuccess() && CollectionUtils.isNotEmpty(materialResp.getData())){
                for(MaterialVO item : materialResp.getData()){
                    OutRmatContractRentRefVO vo = new OutRmatContractRentRefVO();
                    vo.setId(item.getId());
                    vo.setMaterialId(item.getId());
                    vo.setMaterialCode(item.getCode());
                    vo.setSpec(item.getSpec());
                    vo.setMaterialTypeId(item.getCategoryId());
                    vo.setMaterialTypeName(item.getCategoryName());
                    vo.setMaterialName(item.getName());
                    vo.setCreateTime(item.getCreateTime());
                    vo.setUnitMId(item.getUnitId());
                    vo.setUnitMName(item.getUnitName());
                    OutRmatContractRentRefVO category = rentRefVOMap.get(item.getCategoryId());
                    vo.setUnitId(category.getUnitId());
                    vo.setUnitName(category.getUnitName());
                    vo.setRentCalculationType(category.getRentCalculationType());
                    vo.setCount(category.getCount());
                }
            }
        }
        return rentRefVOList;
    }

    /**
     *  校验同一个合同只能存在一个自由态或审批中的单据（补充协议、变更单、冻结单、解除单）
     * @param contractId    合同主键
     * @param billType  待校验单据类型
     * @param billId    待校验单据主键
     * @return
     */
    @RequestMapping(value = "/validateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam("contractId") Long contractId, @RequestParam(value = "billType", required = false) String billType
            , @RequestParam(value = "billId", required = false) Long billId, @RequestParam(value = "type", required = false) String type) {
        String msg = service.validateContract(contractId, billType, billId, type);
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * 单据管控 合同金额大于总计划金额*X%
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody OutRmatContractVO contractVO) {
        return CommonResponse.success("参数校验成功！", service.checkParams(contractVO));
    }
}
