/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.common.util;

import com.ejianc.framework.core.exception.BusinessException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static Logger logger = LoggerFactory.getLogger(DateUtils.class);
    public static final String YYYY_MM_DD = "yyyy-MM-dd";

    private DateUtils() {
    }

    public static int[] dayCompare(Date fromDate, Date toDate) {
        Instant instant = fromDate.toInstant();
        Instant instant1 = toDate.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate one = instant.atZone(zoneId).toLocalDate();
        LocalDate two = instant1.atZone(zoneId).toLocalDate();
        int year = Period.between(one, two).getYears();
        int month = Period.between(one, two).getMonths();
        int day = Period.between(one, two).getDays();
        month = year * 12 + month;
        return new int[]{month, day};
    }

    public static Integer daysBetween(Date smdate, Date bdate) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
            Calendar cal = Calendar.getInstance();
            cal.setTime(smdate);
            long time1 = cal.getTimeInMillis();
            cal.setTime(bdate);
            long time2 = cal.getTimeInMillis();
            long between_days = (time2 - time1) / 86400000L;
            return Integer.parseInt(String.valueOf(between_days));
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u65e5\u671f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new BusinessException("\u8ba1\u7b97\u65e5\u671f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    public static Date calculationMonth(Date date, Integer month) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(2, month);
        return calendar.getTime();
    }

    public static Date calculationDay(Date date, Integer days) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, days);
        return calendar.getTime();
    }

    public static Date createDate(String date) {
        return DateUtils.createDate(date, YYYY_MM_DD);
    }

    public static Date createDate(String date, String pattern) {
        try {
            return new SimpleDateFormat(pattern).parse(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String transformationDate(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String transformationDefaultDate(Date date) {
        return DateUtils.transformationDate(date, YYYY_MM_DD);
    }

    public static Date formatDate(Date date, String pattern) {
        return DateUtils.createDate(DateUtils.transformationDate(date, pattern), pattern);
    }
}

