package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.rmat.bean.ChangeEntity;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.enums.*;
import com.ejianc.business.assist.rmat.service.IChangeService;
import com.ejianc.business.assist.rmat.service.IContractAsyncService;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.vo.ChangeVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@Service("change") 
public class ChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";


	@Autowired
	private IChangeService service;

	@Autowired
	private IContractService contractService;

	@Autowired
	private IParamConfigApi paramConfigApi;

	@Autowired
	private ISignatureCommonApi signatureCommonApi;

	@Autowired
	private IContractAsyncService contractAsyncService;

	@Autowired
	private IAttachmentApi attachmentApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ChangeEntity changeEntity = service.selectById(billId);

		if (DraftTypeEnum.线下签订.getCode().equals(changeEntity.getChangeDraftType())){
			// 调用生效回写服务
			service.effectiveSaveWriteContract(billId, billTypeCode, false);
		}else {
			LambdaUpdateWrapper<ChangeEntity> wrapper = new LambdaUpdateWrapper<>();
			wrapper.set(ChangeEntity::getCommitDate, new Date());
			wrapper.eq(ChangeEntity::getId, billId);
			service.update(wrapper);
			
			// 回写主合同信息
			LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.set(ContractEntity::getChangeStatus, ChangeStatusEnum.变更单据审批通过.getCode());
			updateWrapper.eq(ContractEntity::getId, changeEntity.getContractId());
			contractService.update(updateWrapper);
		}
		checkContractFile(changeEntity);
		// 水印系统参数
		CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
		if (!response.isSuccess() || response.getData() == null) {
			throw new BusinessException("获取水印系统参数请求失败，失败原因：" + response.getMsg());
		}
		String valueData = response.getData().getValueData();
		Assert.hasText(valueData, "获取的水印系统参数不能为空!");

		// 是否限制： 0:不限制，1:限制
		if ("0".equals(valueData)) {
			// 转换水印参数配置：默认规则
			WatermarkVO watermarkVO = signatureCommonApi.fetchWatermarkConfig(changeEntity.getChangeFileId(), changeEntity.getId(),
					changeEntity.getBillCode(), BillTypeEnum.辅料中心租入合同变更.getCode(), "arContractChange");
			Assert.notNull(watermarkVO, "获取水印系统参数失败!");
			// 获取上下文并异步调用添加水印
			HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
			HashMap<String, String> headers = new HashMap<>();
			headers.put("authority", request.getHeader("authority"));
			headers.put("ejc-token", request.getHeader("ejc-token"));
			contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return doBpmBack(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * @param billId
	 * @param state
	 * @param billTypeCode
	 * @return
	 */
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> resp = null;
		//提交通过、且未签章则可弃审
		ChangeEntity changeEntity = service.selectById(billId);

		// 审批可以撤回的签章状态集合
		List<Integer> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());


		//使用电子签章且已有签章流程则不允许撤回
		if (!DraftTypeEnum.线下签订.getCode().equals(changeEntity.getChangeDraftType())
				&& !statusList.contains(changeEntity.getSignatureStatus())) {
			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
		}
		else if (SignatureStatusEnum.已签章.getCode().toString().equals(String.valueOf(changeEntity.getSignatureStatus()))) {
			changeEntity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
		}// 合同变更 线下签订不适用电子签章，已生效的不允许撤回
		else if (DraftTypeEnum.线下签订.getCode().equals(changeEntity.getChangeDraftType()) && SignatureStatusEnum.已签章.getCode().toString().equals(String.valueOf(changeEntity.getSignatureStatus()))) {
			return CommonResponse.error("合同变更已生效，不能撤回!");
		}
		// 删除文件中心水印文件
		if(changeEntity.getWatermarkContractChangeFileId() != null) {
			boolean delWatermarkflag = contractService.delWatermarkContractFile(changeEntity.getWatermarkContractChangeFileId());
			if (delWatermarkflag) {
				changeEntity.setWatermarkContractChangeFileId(null);
			}
		}
		changeEntity.setCommitDate(null);
//		changeEntity.setCommitUserCode(null);
//		changeEntity.setCommitUserName(null);
		changeEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
		service.saveOrUpdate(changeEntity);
		logger.info("撤回更新变更表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(changeEntity));

		ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
		contractEntity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
		contractService.saveOrUpdate(contractEntity, false);
		logger.info("撤回更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));

		return CommonResponse.success("执行变更单撤回回调逻辑成功！");
	}

	/**
	 * 检查合同文件
	 *
	 * @param changeEntity
	 */
	private void checkContractFile(ChangeEntity changeEntity) {
		//查询合同对饮附件是否存在
		CommonResponse<AttachmentVO> attachResp = attachmentApi.queryDetail(changeEntity.getChangeFileId().toString());
		if(!attachResp.isSuccess() || null == attachResp.getData()) {
			logger.info("合同存储文件Id-{}在文件中心不存在，根据参数sourceId-{}, sourceType-{}, billType-{} 查询对应文件信息",
					changeEntity.getChangeFileId(),
					changeEntity.getId(),
					"contractChangeFile",
					BillTypeEnum.辅料中心租入合同变更.getCode());
			//合同附件不存在，根据合同Id、业务类型、查询是否存在对应的文件信息，若存在则更新到合同中，否则抛出异常
			CommonResponse<List<AttachmentVO>> attachListResp = attachmentApi.queryListBySourceId(changeEntity.getId(),
					BillTypeEnum.辅料中心租入合同变更.getCode(),
					"contractChangeFile", "desc");

			logger.info("根据参数sourceId-{}, sourceType-{}, billType-{} 查询对应文件信息结果：{}",
					changeEntity.getId(),
					"contractChangeFile",
					BillTypeEnum.辅料中心租入合同变更.getCode(),
					JSONObject.toJSONString(attachListResp));
			if(attachListResp.isSuccess() || CollectionUtils.isEmpty(attachListResp.getData())) {
				AttachmentVO attachmentVO = attachListResp.getData().get(0);
				logger.info("将合同id-{}对应合同文件Id-{}改为{}", changeEntity.getId(), changeEntity.getChangeFileId(), attachmentVO.getId());
				changeEntity.setChangeFileId(attachmentVO.getId());
				changeEntity.setChangeFilePath(attachmentVO.getTruePath());
			} else {
				throw new BusinessException("审批失败，获取合同文件信息失败, 请检查合同文件！");
			}
		}
	}

	@Override
	public CommonResponse<JSONObject> getBpmVariable(Long billId, String billTypeCode) {
		ChangeEntity e = service.selectById(billId);
		List<ParamsCheckVO> list = service.historyPriceCtrlContractPrice(BeanMapper.map(e,ChangeVO.class));
		JSONObject object = new JSONObject();
		if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list)){
			object.put("priceFlag","是");//是单价异常
			logger.info("单价异常-----"+JSONObject.toJSONString(list));
		}else{
			object.put("priceFlag","否");//否 单价异常
			logger.info("单价正常-----");
		}
		return CommonResponse.success(object);
	}
}
