package com.ejianc.business.assist.material.service;


import com.ejianc.business.assist.material.bean.MaterialDeliveryDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialDeliveryEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 周转材租赁-送货单
 * 
 * @author generator
 * 
 */
public interface IMaterialDeliveryService extends IBaseService<MaterialDeliveryEntity> {

    /**
     * 单据保存
     *
     * @param request
     */
    String saveSyncBill(HttpServletRequest request);

    /**
     * 单据确认
     *
     * @param entity
     */
    String updateBillConfirmState(MaterialDeliveryEntity entity);

    /**
     * 单据作废
     *
     * @param entity
     * @return
     */
    String billDel(MaterialDeliveryEntity entity);


    void submitChangeDeliveryNums(List<MaterialDeliveryDetailEntity> deliveryDetailList);

    void backChangeDeliveryNums(List<MaterialDeliveryDetailEntity> deliveryDetailList);

    void submitChangeDeliveryState(Long orderId, List<MaterialDeliveryDetailEntity> detailEntities);

    void backChangeDeliveryState(Long orderId, List<MaterialDeliveryDetailEntity> detailEntities);


    /**
     * 改状态
     * @param entity
     * @return
     */
    String changeCloseState(MaterialDeliveryEntity entity);

}
