/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.material.bean.MaterialChangeClauseEntity;
import com.ejianc.business.assist.material.bean.MaterialChangeDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialChangeEntity;
import com.ejianc.business.assist.material.bean.MaterialChangeOtherEntity;
import com.ejianc.business.assist.material.bean.MaterialChangePaymentEntity;
import com.ejianc.business.assist.material.bean.MaterialContractClauseEntity;
import com.ejianc.business.assist.material.bean.MaterialContractDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.bean.MaterialContractOtherEntity;
import com.ejianc.business.assist.material.bean.MaterialContractPaymentEntity;
import com.ejianc.business.assist.material.bean.MaterialRecordClauseEntity;
import com.ejianc.business.assist.material.bean.MaterialRecordDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialRecordEntity;
import com.ejianc.business.assist.material.bean.MaterialRecordOtherEntity;
import com.ejianc.business.assist.material.bean.MaterialRecordPaymentEntity;
import com.ejianc.business.assist.material.consts.MaterialConstant;
import com.ejianc.business.assist.material.consts.MaterialPriceHistoryApiVO;
import com.ejianc.business.assist.material.consts.PriceCheckCodeEnum;
import com.ejianc.business.assist.material.enums.BillTypeEnum;
import com.ejianc.business.assist.material.mapper.MaterialChangeMapper;
import com.ejianc.business.assist.material.service.IMaterialChangeService;
import com.ejianc.business.assist.material.service.IMaterialContractClauseService;
import com.ejianc.business.assist.material.service.IMaterialContractDetailService;
import com.ejianc.business.assist.material.service.IMaterialContractFileService;
import com.ejianc.business.assist.material.service.IMaterialContractOtherService;
import com.ejianc.business.assist.material.service.IMaterialContractPaymentService;
import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.assist.material.service.IMaterialRecordService;
import com.ejianc.business.assist.material.vo.MaterialChangeClauseVO;
import com.ejianc.business.assist.material.vo.MaterialChangeDetailVO;
import com.ejianc.business.assist.material.vo.MaterialChangeOtherVO;
import com.ejianc.business.assist.material.vo.MaterialChangePaymentVO;
import com.ejianc.business.assist.material.vo.MaterialChangeVO;
import com.ejianc.business.assist.material.vo.MaterialContractVO;
import com.ejianc.business.assist.material.vo.compare.MaterialChangeCompareVO;
import com.ejianc.business.assist.material.vo.record.MaterialChangeRecordVO;
import com.ejianc.business.assist.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.assist.rmat.enums.ChangeStatusEnum;
import com.ejianc.business.assist.rmat.enums.DraftTypeEnum;
import com.ejianc.business.assist.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.assist.rmat.enums.SettleEnum;
import com.ejianc.business.assist.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.assist.rmat.vo.ChangePaymentVO;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialChangeService")
public class MaterialChangeServiceImpl
extends BaseServiceImpl<MaterialChangeMapper, MaterialChangeEntity>
implements IMaterialChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ASSISTMATERIAL_CONTRACT_CHANGE";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IMaterialContractService contractService;
    @Autowired
    private IMaterialRecordService recordService;
    @Autowired
    private IMaterialContractDetailService detailService;
    @Autowired
    private IMaterialContractOtherService otherService;
    @Autowired
    private IMaterialContractPaymentService paymentService;
    @Autowired
    private IMaterialContractClauseService clauseService;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IMaterialContractFileService fileService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;

    @Override
    public MaterialChangeVO saveOrUpdate(MaterialChangeVO saveOrUpdateVO) {
        MaterialChangeEntity entity;
        MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)this.contractService.selectById(saveOrUpdateVO.getMainContractId()));
        if (ListUtil.isNotEmpty((List)saveOrUpdateVO.getAttachIds()) && null != contractEntity.getContractFileId()) {
            saveOrUpdateVO.getAttachIds().remove(contractEntity.getContractFileId());
        }
        if ((entity = (MaterialChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialChangeEntity.class))).getId() == null || entity.getId() == 0L) {
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            if (null == entity.getChangeVersion() || entity.getChangeVersion() == 0) {
                entity.setChangeVersion(1);
            } else {
                entity.setChangeVersion(entity.getChangeVersion() + 1);
            }
            if (entity.getChangeVersion() < 10) {
                entity.setBillCode(entity.getMainContractCode() + "-1-0" + entity.getChangeVersion());
            } else {
                entity.setBillCode(entity.getMainContractCode() + "-1-" + entity.getChangeVersion());
            }
            this.clearDetailList(entity);
        }
        this.contractService.validateContract(saveOrUpdateVO.getMainContractId(), "\u53d8\u66f4\u5355", saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        entity.setContractId(entity.getMainContractId());
        entity.setBeforeContractName(entity.getMainContractName());
        entity.setChangeContractName(entity.getContractName());
        this.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(MaterialContractEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(MaterialContractEntity::getChangingMny, (Object)entity.getContractMny());
        updateWrapper.set(MaterialContractEntity::getChangingTaxMny, (Object)entity.getContractTaxMny());
        updateWrapper.set(MaterialContractEntity::getChangeCode, (Object)entity.getBillCode());
        updateWrapper.set(MaterialContractEntity::getChangeVersion, (Object)entity.getChangeVersion());
        updateWrapper.set(MaterialContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(MaterialContractEntity::getChangeDate, (Object)entity.getChangeDate());
        updateWrapper.set(MaterialContractEntity::getChangeDraftType, (Object)entity.getChangeDraftType());
        updateWrapper.set(MaterialContractEntity::getChangeContractSignatureStatus, (Object)entity.getSignatureStatus());
        updateWrapper.set(MaterialContractEntity::getChangeFileId, (Object)entity.getChangeFileId());
        updateWrapper.set(MaterialContractEntity::getChangeContractName, (Object)entity.getContractName());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getMainContractId());
        this.contractService.update((Wrapper)updateWrapper);
        return (MaterialChangeVO)BeanMapper.map((Object)this.selectById(entity.getId()), MaterialChangeVO.class);
    }

    @Override
    public void deleteByIds(List<MaterialChangeVO> vos) {
        for (MaterialChangeVO vo : vos) {
            MaterialChangeEntity changeEntity = (MaterialChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            LambdaUpdateWrapper lambdaUpdate = new LambdaUpdateWrapper();
            if (changeEntity.getChangeVersion() == 1) {
                lambdaUpdate.set(MaterialContractEntity::getChangeStatus, (Object)1);
            } else {
                lambdaUpdate.set(MaterialContractEntity::getChangeStatus, (Object)3);
            }
            lambdaUpdate.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
            this.contractService.update((Wrapper)lambdaUpdate);
            super.removeById((Serializable)vo, false);
        }
    }

    @Override
    public MaterialChangeRecordVO queryChangeRecord(Long id) {
        MaterialContractEntity entity = (MaterialContractEntity)((Object)this.contractService.selectById(id));
        MaterialChangeRecordVO vo = new MaterialChangeRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setBaseMny(entity.getBaseMny());
        vo.setBaseTaxMny(entity.getBaseTaxMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MaterialChangeEntity::getContractId, (Object)id);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List changeList = super.list((Wrapper)wrapper);
        vo.setTotalChangeMny(ComputeUtil.safeSub((BigDecimal)vo.getContractMny(), (BigDecimal)vo.getBaseMny()));
        vo.setTotalChangeTaxMny(ComputeUtil.safeSub((BigDecimal)vo.getContractTaxMny(), (BigDecimal)vo.getBaseTaxMny()));
        vo.setTotalChangeNum(Integer.valueOf(changeList.size()));
        vo.setTotalChangeRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getTotalChangeMny(), (BigDecimal)vo.getBaseTaxMny()), (BigDecimal)new BigDecimal("100")));
        vo.setDetailList(BeanMapper.mapList((Iterable)changeList, MaterialChangeVO.class));
        return vo;
    }

    @Override
    public MaterialChangeVO queryContractRecordDetail(Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MaterialRecordEntity::getChangeId, (Object)id);
        List list = this.recordService.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list)) {
            return (MaterialChangeVO)BeanMapper.map((Object)this.recordService.selectById(((MaterialRecordEntity)((Object)list.get(0))).getId()), MaterialChangeVO.class);
        }
        return new MaterialChangeVO();
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState) {
        MaterialChangeEntity changeEntity = (MaterialChangeEntity)((Object)this.selectById(changeBillId));
        MaterialContractVO contractVO = this.contractService.queryDetail(changeEntity.getContractId());
        this.writeBackRecord(changeEntity, contractVO);
        this.writeBackContract(changeEntity, contractVO);
        changeEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        changeEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        changeEntity.setCommitDate(new Date());
        this.saveOrUpdate((Object)changeEntity);
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(changeEntity.getChangeDraftType()) || DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().equals(changeEntity.getChangeDraftType())) {
            this.fileService.getSignedFileInfo(changeBillId, "contractChange");
        }
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u751f\u6548\uff0c\u56de\u5199\u5408\u540c\u6210\u529f\uff01");
    }

    @Override
    public Boolean pushContract(MaterialContractVO vo, String updateLevel) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            this.contractService.delContractFromPool(vo.getId());
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            data.setSourceType(ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u91c7\u8d2d\u5408\u540c.getTypeCode());
            data.setContractProperty(Integer.valueOf(SettleEnum.\u652f\u51fa.getCode()));
            MaterialChangeRecordVO changeRecordVO = this.queryChangeRecord(vo.getId());
            data.setTotalChangeMny(changeRecordVO.getTotalChangeMny());
            data.setTotalChangeTaxMny(changeRecordVO.getTotalChangeTaxMny());
            data.setTotalChangeTax(ComputeUtil.safeSub((BigDecimal)data.getTotalChangeTaxMny(), (BigDecimal)data.getTotalChangeMny()));
            data.setTaotalChangeScale(changeRecordVO.getTotalChangeRate());
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return null;
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        MaterialChangeEntity changeEntity = (MaterialChangeEntity)((Object)this.selectById(id));
        MaterialChangeCompareVO changeCompareVO = (MaterialChangeCompareVO)BeanMapper.map((Object)((Object)changeEntity), MaterialChangeCompareVO.class);
        MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        MaterialChangeCompareVO beforeChangeVO = new MaterialChangeCompareVO();
        boolean flag = false;
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(changeEntity.getBillState())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(MaterialRecordEntity::getChangeId, (Object)id);
            wrapper.eq(MaterialRecordEntity::getContractId, (Object)changeEntity.getContractId());
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            List recordEntityList = this.recordService.list((Wrapper)wrapper);
            if (ListUtil.isNotEmpty((List)recordEntityList)) {
                beforeChangeVO = (MaterialChangeCompareVO)BeanMapper.map((Object)this.recordService.selectById(((MaterialRecordEntity)((Object)recordEntityList.get(0))).getId()), MaterialChangeCompareVO.class);
            }
        } else {
            beforeChangeVO = (MaterialChangeCompareVO)BeanMapper.map((Object)((Object)contractEntity), MaterialChangeCompareVO.class);
            flag = true;
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            MaterialChangeDetailVO beforeVO;
            if (ListUtil.isNotEmpty((List)changeCompareVO.getDetailList())) {
                List detailList = beforeChangeVO.getDetailList();
                Map<Object, Object> beforeDetailMap = new HashMap();
                beforeDetailMap = flag ? detailList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : detailList.stream().collect(Collectors.toMap(MaterialChangeDetailVO::getSourceBid, Function.identity()));
                for (Object vo : changeCompareVO.getDetailList()) {
                    if (!StringUtils.isNotEmpty((CharSequence)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (MaterialChangeDetailVO)beforeDetailMap.get(vo.getSourceBid());
                    vo.setBcBrand(beforeVO.getBrand());
                    vo.setBcCount(beforeVO.getCount());
                    vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                    vo.setBcUnitName(beforeVO.getUnitName());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcTaxMny(beforeVO.getTaxMny());
                    vo.setBcMemo(beforeVO.getMemo());
                }
                changeCompareVO.setDetailList(changeCompareVO.getDetailList().stream().filter(daily -> StringUtils.isNotEmpty((CharSequence)daily.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getOtherList())) {
                List otherList = beforeChangeVO.getOtherList();
                Map<Object, Object> beforeOtherMap = new HashMap();
                beforeOtherMap = flag ? otherList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : otherList.stream().collect(Collectors.toMap(MaterialChangeOtherVO::getSourceBid, Function.identity()));
                for (Object vo : changeCompareVO.getOtherList()) {
                    if (!StringUtils.isNotEmpty((CharSequence)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (MaterialChangeOtherVO)beforeOtherMap.get(vo.getSourceBid());
                    vo.setBcCostName(beforeVO.getCostName());
                    vo.setBcCount(beforeVO.getCount());
                    vo.setBcUnitTaxPrice(BigDecimal.ZERO);
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcMemo(beforeVO.getMemo());
                }
                changeCompareVO.setOtherList(changeCompareVO.getOtherList().stream().filter(other -> StringUtils.isNotEmpty((CharSequence)other.getChangeType())).collect(Collectors.toList()));
            }
            ArrayList<MaterialChangePaymentVO> newPayList = new ArrayList<MaterialChangePaymentVO>();
            Map<Object, Object> beforePayMap = new HashMap();
            beforePayMap = flag ? beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(BaseVO::getId, item -> item, (v1, v2) -> v2)) : beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(MaterialChangePaymentVO::getSourceBid, item -> item, (v1, v2) -> v2));
            if (ListUtil.isNotEmpty((List)changeCompareVO.getPaymentList())) {
                MaterialChangePaymentVO beforeVo = null;
                for (MaterialChangePaymentVO vo : changeCompareVO.getPaymentList()) {
                    if (vo.getSourceBid() == null) {
                        vo.setChangeType(MaterialConstant.CHANGE_TYPE_ADD.toString());
                        newPayList.add(vo);
                        continue;
                    }
                    if (!beforePayMap.containsKey(vo.getSourceBid())) continue;
                    beforeVo = (MaterialChangePaymentVO)beforePayMap.get(vo.getSourceBid());
                    if (!beforeVo.getPaymentName().equals(vo.getPaymentName()) || !beforeVo.getPaymentScale().equals(vo.getPaymentScale())) {
                        vo.setBcPaymentName(beforeVo.getPaymentName());
                        vo.setBcPaymentScale(beforeVo.getPaymentScale());
                        vo.setChangeType(MaterialConstant.CHANGE_TYPE_CONTENT_CHANGE.toString());
                        newPayList.add(vo);
                    }
                    beforePayMap.remove(vo.getSourceBid());
                }
            }
            if (MapUtils.isNotEmpty(beforePayMap)) {
                beforePayMap.values().forEach(c -> {
                    c.setChangeType(MaterialConstant.CHANGE_TYPE_DEL.toString());
                    newPayList.add((MaterialChangePaymentVO)c);
                });
            }
            changeCompareVO.setPaymentList(newPayList);
            ArrayList<MaterialChangeClauseVO> newClauses = new ArrayList<MaterialChangeClauseVO>();
            Map<Object, Object> beforeClauseMap = new HashMap();
            beforeClauseMap = flag ? beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(BaseVO::getId, clause -> clause, (v1, v2) -> v2)) : beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(MaterialChangeClauseVO::getSourceBid, clause -> clause, (v1, v2) -> v2));
            if (ListUtil.isNotEmpty((List)changeCompareVO.getClauseList())) {
                MaterialChangeClauseVO beforeVo = null;
                for (MaterialChangeClauseVO vo : changeCompareVO.getClauseList()) {
                    if (vo.getSourceBid() == null) {
                        vo.setChangeType(MaterialConstant.CHANGE_TYPE_ADD.toString());
                        newClauses.add(vo);
                        continue;
                    }
                    if (!beforeClauseMap.containsKey(vo.getSourceBid())) continue;
                    beforeVo = (MaterialChangeClauseVO)beforeClauseMap.get(vo.getSourceBid());
                    if (!Objects.equals(beforeVo.getClauseNameId(), vo.getClauseNameId()) || !Objects.equals(beforeVo.getClauseContent(), vo.getClauseContent())) {
                        vo.setBcClauseName(beforeVo.getClauseName());
                        vo.setBcClauseContent(beforeVo.getClauseContent());
                        vo.setChangeType(ChangePaymentVO.CHANGE_TYPE_CONTENT_CHANGE.toString());
                        newClauses.add(vo);
                    }
                    beforeClauseMap.remove(vo.getSourceBid());
                }
            }
            if (MapUtils.isNotEmpty(beforeClauseMap)) {
                beforeClauseMap.values().forEach(c -> {
                    c.setChangeType(MaterialConstant.CHANGE_TYPE_DEL.toString());
                    newClauses.add((MaterialChangeClauseVO)c);
                });
            }
            changeCompareVO.setClauseList(newClauses);
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }

    @Override
    public ParamsCheckVO priceCheckParams(MaterialChangeVO materialContractVO) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialPriceHistoryApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)materialContractVO.getDetailList())) {
            for (MaterialChangeDetailVO detailVO : materialContractVO.getDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getUnitPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getUnitTaxPrice());
                priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                priceHistoryApiVO.setGuideTaxPriceArea(detailVO.getGuideTaxPriceArea());
                priceHistoryApiVO.setGuidePriceArea(detailVO.getGuidePriceArea());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        materialPriceHistoryApiVO.setOrgId(materialContractVO.getOrgId());
        ParamsCheckVO paramsCheckVO = this.priceCheckParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    public ParamsCheckVO priceCheckParams(MaterialPriceHistoryApiVO materialPriceHistoryApiVO) {
        StringBuffer stringBuffer;
        ParamsCheckDsVO paramsCheckDsVO;
        BigDecimal price;
        BigDecimal minPrice;
        BigDecimal maxPrice;
        String[] split;
        String getHistoryPriceArea;
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        List detailList = materialPriceHistoryApiVO.getMaterialPriceHistoryApiVOList();
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            this.logger.info("detailList\u4e3a\u7a7a\u76f4\u63a5\u8fd4\u56de\u7ed3\u679c");
            return paramsCheckVO;
        }
        String MAX_CODE = PriceCheckCodeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u91c7\u8d2d\u6700\u9ad8\u4ef7.getCode();
        String MIN_CODE = PriceCheckCodeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u91c7\u8d2d\u6700\u4f4e\u4ef7.getCode();
        Long orgId = materialPriceHistoryApiVO.getOrgId();
        if (null == orgId) {
            this.logger.info("orgId\u4e3a\u7a7a");
            return paramsCheckVO;
        }
        CommonResponse maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MAX_CODE, orgId);
        if (!maxParamByCode.isSuccess() && null == maxParamByCode.getData()) {
            this.logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
        }
        CommonResponse minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MIN_CODE, orgId);
        if (!minParamByCode.isSuccess() && null == minParamByCode.getData()) {
            this.logger.info(minParamByCode.getMsg());
            return paramsCheckVO;
        }
        List maxParamVOS = (List)maxParamByCode.getData();
        List minParamVOS = (List)minParamByCode.getData();
        this.logger.info("\u8f85\u6599\u4e2d\u5fc3\u5386\u53f2\u9ad8\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        this.logger.info("\u8f85\u6599\u4e2d\u5fc3\u5386\u53f2\u4f4e\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)minParamVOS));
        boolean flag = true;
        this.logger.info("\u4f20\u5165\u53c2\u6570--{}", (Object)JSONObject.toJSONString((Object)PrinceDepotEnum.\u6750\u6599\u4ef7\u683c\u5e93.getCode()));
        CommonResponse commonResponse = this.priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.\u6750\u6599\u4ef7\u683c\u5e93.getCode());
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        List data = (List)commonResponse.getData();
        Integer priorityFlag = ((PriceDepotParamSetDTO)data.get(0)).getPriorityFlag();
        if (null != priorityFlag && 2 == priorityFlag) {
            flag = false;
        }
        if (CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                for (MaterialPriceHistoryApiVO detailVO : detailList) {
                    BigDecimal maxPriceParam;
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u7269\u8d44\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName() + detailVO.getSpec(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPrice() == null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName("\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOMax);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)minParamVOS)) {
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);
                for (MaterialPriceHistoryApiVO detailVO : detailList) {
                    BigDecimal minPriceParam;
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u7269\u8d44\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName() + detailVO.getSpec(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPrice() == null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName("\u5355\u4ef7\u5c0f\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOS.add(paramsCheckVOMin);
            }
        }
        String[] paramsArr = new String[]{"alert", "warn", "none"};
        HashMap<String, List> map = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArr) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public void writeBackRecord(MaterialChangeEntity changeEntity, MaterialContractVO contractVO) {
        MaterialRecordEntity recordEntity = (MaterialRecordEntity)((Object)BeanMapper.map((Object)contractVO, MaterialRecordEntity.class));
        recordEntity.setContractId(changeEntity.getContractId());
        recordEntity.setId(null);
        if (ListUtil.isNotEmpty(recordEntity.getDetailList())) {
            for (MaterialRecordDetailEntity materialRecordDetailEntity : recordEntity.getDetailList()) {
                materialRecordDetailEntity.setSourceBid(materialRecordDetailEntity.getId());
                materialRecordDetailEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getOtherList())) {
            for (MaterialRecordOtherEntity materialRecordOtherEntity : recordEntity.getOtherList()) {
                materialRecordOtherEntity.setSourceBid(materialRecordOtherEntity.getId());
                materialRecordOtherEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getClauseList())) {
            for (MaterialRecordClauseEntity materialRecordClauseEntity : recordEntity.getClauseList()) {
                materialRecordClauseEntity.setSourceBid(materialRecordClauseEntity.getId());
                materialRecordClauseEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getPaymentList())) {
            for (MaterialRecordPaymentEntity materialRecordPaymentEntity : recordEntity.getPaymentList()) {
                materialRecordPaymentEntity.setSourceBid(materialRecordPaymentEntity.getId());
                materialRecordPaymentEntity.setId(null);
            }
        }
        this.recordService.saveOrUpdate((Object)recordEntity, false);
        this.logger.info("\u5ba1\u6279-\u53d8\u66f4\u8bb0\u5f55\u8868\u4fdd\u5b58\u4e3b\u5408\u540c\u6570\u636e\u6210\u529f\uff01");
        this.logger.info("\u540c\u6b65\u9644\u4ef6");
        CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractVO.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u91c7\u8d2d\u5408\u540c.getCode(), "amContract", String.valueOf(recordEntity.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u91c7\u8d2d\u5408\u540c\u8bb0\u5f55.getCode(), "amContractRecord");
        this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + JSONObject.toJSONString((Object)response));
        this.logger.info("\u540c\u6b65\u9644\u4ef6");
        CommonResponse commonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractVO.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u91c7\u8d2d\u5408\u540c.getCode(), "amContractFile", String.valueOf(recordEntity.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u91c7\u8d2d\u5408\u540c\u8bb0\u5f55.getCode(), "amContractRecordFile");
        this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + JSONObject.toJSONString((Object)commonResponse));
    }

    public void writeBackContract(MaterialChangeEntity changeEntity, MaterialContractVO contractVO) {
        List clauseList;
        List paymentList;
        List otherList;
        List detailList;
        MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)BeanMapper.map((Object)contractVO, MaterialContractEntity.class));
        contractEntity.setFirstPartyProjectManagerId(changeEntity.getFirstPartyProjectManagerId());
        contractEntity.setFirstPartyProjectManagerName(changeEntity.getFirstPartyProjectManagerName());
        contractEntity.setFirstPartyEmployeeId(changeEntity.getFirstPartyEmployeeId());
        contractEntity.setFirstPartyEmployeeName(changeEntity.getFirstPartyEmployeeName());
        contractEntity.setFirstPartyPhone(changeEntity.getFirstPartyPhone());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSupplierEmployeeId(changeEntity.getSupplierEmployeeId());
        contractEntity.setSupplierEmployeeName(changeEntity.getSupplierEmployeeName());
        contractEntity.setSupplierPhone(changeEntity.getSupplierPhone());
        contractEntity.setFirstPartyEntrustedAgentId(changeEntity.getFirstPartyEntrustedAgentId());
        contractEntity.setFirstPartyEntrustedAgentName(changeEntity.getFirstPartyEntrustedAgentName());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setChangingMny(null);
        contractEntity.setChangingTaxMny(null);
        contractEntity.setDetailTaxMny(changeEntity.getDetailTaxMny());
        contractEntity.setDetailMny(changeEntity.getDetailMny());
        contractEntity.setDetailTax(changeEntity.getDetailTax());
        contractEntity.setOtherTaxMny(changeEntity.getOtherTaxMny());
        contractEntity.setOtherMny(changeEntity.getOtherMny());
        contractEntity.setOtherTax(changeEntity.getOtherTax());
        contractEntity.setPurchaseId(changeEntity.getPurchaseId());
        contractEntity.setPurchaseName(changeEntity.getPurchaseName());
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setChangeContractName(changeEntity.getContractName());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setSignAddress(changeEntity.getSignAddress());
        contractEntity.setReceiptAddress(changeEntity.getReceiptAddress());
        contractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        contractEntity.setChangeContractSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString());
        contractEntity.setChangeDraftType(changeEntity.getChangeDraftType());
        contractEntity.setChangeFileId(changeEntity.getChangeFileId());
        if (ListUtil.isNotEmpty((List)contractVO.getDetailList())) {
            this.detailService.removeByIds(contractVO.getDetailList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(detailList = BeanMapper.mapList(changeEntity.getDetailList(), MaterialContractDetailEntity.class)))) {
            for (Object entity : detailList) {
                ((MaterialContractDetailEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((MaterialContractDetailEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setDetailList(detailList);
        if (ListUtil.isNotEmpty((List)contractVO.getOtherList())) {
            this.otherService.removeByIds(contractVO.getOtherList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(otherList = BeanMapper.mapList(changeEntity.getOtherList(), MaterialContractOtherEntity.class)))) {
            for (Object entity : otherList) {
                ((MaterialContractOtherEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((MaterialContractOtherEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setOtherList(otherList);
        if (ListUtil.isNotEmpty((List)contractVO.getPaymentList())) {
            this.paymentService.removeByIds(contractVO.getPaymentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(paymentList = BeanMapper.mapList(changeEntity.getPaymentList(), MaterialContractPaymentEntity.class)))) {
            for (Object entity : paymentList) {
                ((MaterialContractPaymentEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((MaterialContractPaymentEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setPaymentList(paymentList);
        if (ListUtil.isNotEmpty((List)contractVO.getClauseList())) {
            this.clauseService.removeByIds(contractVO.getClauseList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(clauseList = BeanMapper.mapList(changeEntity.getClauseList(), MaterialContractClauseEntity.class)))) {
            for (MaterialContractClauseEntity entity : clauseList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setClauseList(clauseList);
        Boolean pushResult = this.pushContract((MaterialContractVO)BeanMapper.map((Object)((Object)contractEntity), MaterialContractVO.class), UpdateLevelEnum.\u5168\u91cf\u8986\u76d6\u66f4\u65b0.getLevelCode());
        if (pushResult.booleanValue()) {
            contractEntity.setPushPoolFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            contractEntity.setPushPoolFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u540c\u6b65\u9644\u4ef6");
        CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(changeEntity.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u91c7\u8d2d\u5408\u540c\u53d8\u66f4.getCode(), "amContractChange", String.valueOf(contractEntity.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u91c7\u8d2d\u5408\u540c.getCode(), "amContract");
        this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + JSONObject.toJSONString((Object)response));
    }

    public void clearDetailList(MaterialChangeEntity changeEntity) {
        if (ListUtil.isNotEmpty(changeEntity.getDetailList())) {
            for (MaterialChangeDetailEntity materialChangeDetailEntity : changeEntity.getDetailList()) {
                if (materialChangeDetailEntity.getId() != null) {
                    materialChangeDetailEntity.setSourceBid(materialChangeDetailEntity.getId());
                }
                materialChangeDetailEntity.setId(null);
                materialChangeDetailEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getOtherList())) {
            for (MaterialChangeOtherEntity materialChangeOtherEntity : changeEntity.getOtherList()) {
                if (materialChangeOtherEntity.getId() != null) {
                    materialChangeOtherEntity.setSourceBid(materialChangeOtherEntity.getId());
                }
                materialChangeOtherEntity.setId(null);
                materialChangeOtherEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getPaymentList())) {
            for (MaterialChangePaymentEntity materialChangePaymentEntity : changeEntity.getPaymentList()) {
                if (materialChangePaymentEntity.getId() != null) {
                    materialChangePaymentEntity.setSourceBid(materialChangePaymentEntity.getId());
                }
                materialChangePaymentEntity.setId(null);
                materialChangePaymentEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getClauseList())) {
            for (MaterialChangeClauseEntity materialChangeClauseEntity : changeEntity.getClauseList()) {
                if (materialChangeClauseEntity.getId() != null) {
                    materialChangeClauseEntity.setSourceBid(materialChangeClauseEntity.getId());
                }
                materialChangeClauseEntity.setId(null);
                materialChangeClauseEntity.setContractId(changeEntity.getMainContractId());
            }
        }
    }
}

