/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.material.bean.MaterialCheckDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialCheckEntity;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.bean.MaterialSettleEntity;
import com.ejianc.business.assist.material.enums.BillTypeEnum;
import com.ejianc.business.assist.material.mapper.MaterialSettleMapper;
import com.ejianc.business.assist.material.service.IMaterialCheckDetailService;
import com.ejianc.business.assist.material.service.IMaterialCheckService;
import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.assist.material.service.IMaterialSettleService;
import com.ejianc.business.assist.material.vo.MaterialCheckDetailVO;
import com.ejianc.business.assist.material.vo.MaterialSettleVO;
import com.ejianc.business.assist.material.vo.record.MaterialSettleRecordVO;
import com.ejianc.business.assist.rmat.enums.SettleEnum;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.vo.report.RmatConSettleReportVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.rmat.utils.PushSupUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialSettleService")
public class MaterialSettleServiceImpl
extends BaseServiceImpl<MaterialSettleMapper, MaterialSettleEntity>
implements IMaterialSettleService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ASSISTMATERIAL_CONTRACT_SETTLE";
    private static final String OPERATE = "SETTLE_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u91c7\u8d2d\u5408\u540c\u7ed3\u7b97\u5355.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u91c7\u8d2d\u5408\u540c\u7ed3\u7b97\u5355.getName();
    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistmaterial/settle/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistmaterial/settle/billDel";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialContractService contractService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IMaterialCheckService checkService;
    @Autowired
    private IMaterialCheckDetailService checkDetailService;
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private MaterialSettleMapper materialSettleMapper;

    @Override
    public MaterialSettleVO saveOrUpdate(MaterialSettleVO saveOrUpdateVO) {
        int compareDate;
        MaterialSettleEntity entity = (MaterialSettleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialSettleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setSupplierSignStatus(0);
        }
        this.validateContract(entity.getContractId(), entity.getId());
        MaterialSettleVO lastVo = this.queryLastSettleTaxMny(entity.getContractId(), entity.getId());
        if (lastVo.getId() != null && (compareDate = DateUtil.compareDate((Date)lastVo.getSettleDate(), (Date)entity.getSettleDate())) > 0) {
            throw new BusinessException("\u672c\u6b21\u7ed3\u7b97\u65e5\u671f" + DateUtil.formatDate((Date)entity.getSettleDate()) + "\u4e0d\u80fd\u5c0f\u4e8e\u4e0a\u6b21\u7ed3\u7b97\u65e5\u671f" + DateUtil.formatDate((Date)lastVo.getSettleDate()));
        }
        this.saveOrUpdate((Object)entity, false);
        return (MaterialSettleVO)BeanMapper.map((Object)this.selectById(entity.getId()), MaterialSettleVO.class);
    }

    @Override
    public String validateContract(Long contractId, Long billId) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        if (billId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        if (ListUtil.isNotEmpty((List)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u7ed3\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public MaterialSettleVO queryLastSettleTaxMny(Long contractId, Long billId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MaterialSettleEntity::getContractId, (Object)contractId);
        wrapper.in(MaterialSettleEntity::getBillState, Arrays.asList(1, 3));
        if (billId != null) {
            wrapper.ne(BaseEntity::getId, (Object)billId);
        }
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new MaterialSettleVO();
        }
        return (MaterialSettleVO)BeanMapper.map(list.get(0), MaterialSettleVO.class);
    }

    @Override
    public List<MaterialCheckDetailVO> queryCheckData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MaterialCheckEntity::getContractId, (Object)contractId);
        wrapper.eq(MaterialCheckEntity::getSettleFlag, (Object)0);
        wrapper.in(MaterialCheckEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        if (StringUtils.isBlank((CharSequence)lastSettleDate)) {
            wrapper.le(MaterialCheckEntity::getCheckDate, (Object)settleDate);
        } else {
            wrapper.between(MaterialCheckEntity::getCheckDate, (Object)lastSettleDate, (Object)settleDate);
        }
        List list = this.checkService.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<MaterialCheckDetailVO>();
        }
        List idsList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(MaterialCheckDetailEntity::getCheckId, idsList);
        List detailList = this.checkDetailService.list((Wrapper)queryWrapper);
        if (ListUtil.isEmpty((List)detailList)) {
            return new ArrayList<MaterialCheckDetailVO>();
        }
        return BeanMapper.mapList((Iterable)detailList, MaterialCheckDetailVO.class);
    }

    @Override
    public MaterialSettleRecordVO querySettleRecord(Long id) {
        MaterialContractEntity entity = (MaterialContractEntity)((Object)this.contractService.selectById(id));
        MaterialSettleRecordVO vo = new MaterialSettleRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MaterialSettleEntity::getContractId, (Object)id);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List settleList = super.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)settleList)) {
            vo.setTotalSettleTaxMny(((MaterialSettleEntity)((Object)settleList.get(0))).getTotalSettleTaxMny());
            vo.setTotalSettleMny(((MaterialSettleEntity)((Object)settleList.get(0))).getTotalSettleMny());
            vo.setSettleRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getTotalSettleTaxMny(), (BigDecimal)vo.getTotalSettleMny()), (BigDecimal)new BigDecimal("100")));
        }
        vo.setDetailList(BeanMapper.mapList((Iterable)settleList, MaterialSettleVO.class));
        return vo;
    }

    @Override
    public Boolean pushSettleToPool(MaterialSettleVO vo) {
        SettlePoolVO poolVO = new SettlePoolVO();
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb");
            BeanConvertorUtil.convert((Object)vo, (Object)poolVO);
            poolVO.setSourceId(vo.getId());
            poolVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            poolVO.setSourceType(SettleSourceTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u91c7\u8d2d\u7ed3\u7b97.getCode());
            poolVO.setSourceTypeName(SettleSourceTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u91c7\u8d2d\u7ed3\u7b97.getName());
            poolVO.setSettleProperty(Integer.valueOf(SettleEnum.\u652f\u51fa.getCode()));
            poolVO.setSettlePropertyName(SettleEnum.\u652f\u51fa.getName());
            poolVO.setUltimateFlag(Integer.valueOf(vo.getSettleType()));
            MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)this.contractService.selectById(vo.getContractId()));
            poolVO.setSupplementFlag(contractEntity.getSupplementFlag());
            poolVO.setMaiContractId(contractEntity.getId());
            poolVO.setMaiContractCode(contractEntity.getBillCode());
            poolVO.setMaiContractName(contractEntity.getContractName());
            poolVO.setSignDate(contractEntity.getSignDate());
            poolVO.setContractType(ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u91c7\u8d2d\u5408\u540c.getTypeCode());
            poolVO.setContractTypeName(ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u91c7\u8d2d\u5408\u540c.getTypeName());
            poolVO.setContractFlag(Integer.valueOf(1));
            poolVO.setCreateTime(vo.getCreateTime());
            poolVO.setCreateUserCode(vo.getCreateUserCode());
            poolVO.setUpdateTime(vo.getUpdateTime());
            poolVO.setUpdateUserCode(vo.getUpdateUserCode());
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(poolVO);
            if (res.isSuccess()) {
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId());
                return true;
            }
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)vo.getId(), (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId(), (Object)e);
        }
        return false;
    }

    @Override
    public Boolean delSettleFromPool(Long id) {
        SettlePoolVO poolVO = new SettlePoolVO();
        poolVO.setSourceId(id);
        CommonResponse res = this.settlePoolApi.deleteSettle(poolVO);
        if (res.isSuccess()) {
            this.logger.info("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)id);
            return true;
        }
        this.logger.error("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
        return false;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        MaterialSettleEntity entity = (MaterialSettleEntity)((Object)super.selectById((Serializable)((Object)billId)));
        String msg = this.pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject)JSONObject.toJSON((Object)((Object)entity)), MaterialSettleEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        this.logger.info("\u8fd4\u56de\u6d88\u606fmsg" + msg);
        return msg;
    }

    @Override
    public Boolean pushBillToSupCenter(MaterialSettleEntity entity) {
        Boolean syncFlag = this.pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    @Override
    public Boolean delPushBill(MaterialSettleEntity entity) {
        Boolean delSuc = this.pushSupUtil.delPushBill((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }

    @Override
    public Map<String, Object> count(Map<String, Object> paramMap) {
        HashMap<String, Object> resp = new HashMap<String, Object>();
        Map<String, Object> rs = this.materialSettleMapper.countSettleInfo(paramMap);
        if (null == rs) {
            rs = new HashMap<String, Object>();
        }
        resp.put("total", null == rs.get("total") ? 0 : Integer.valueOf(rs.get("total").toString()));
        resp.put("curTotalSettleMny", null == rs.get("curTotalSettleMny") ? BigDecimal.ZERO : new BigDecimal(rs.get("curTotalSettleMny").toString()));
        resp.put("curTotalSettleTaxMny", null == rs.get("curTotalSettleTaxMny") ? BigDecimal.ZERO : new BigDecimal(rs.get("curTotalSettleTaxMny").toString()));
        resp.put("totalSettleMnyThisYear", null == rs.get("totalSettleMnyThisYear") ? BigDecimal.ZERO : new BigDecimal(rs.get("totalSettleMnyThisYear").toString()));
        resp.put("totalSettleTaxMnyThisYear", null == rs.get("totalSettleTaxMnyThisYear") ? BigDecimal.ZERO : new BigDecimal(rs.get("totalSettleTaxMnyThisYear").toString()));
        resp.put("totalStartSettleMny", null == rs.get("totalStartSettleMny") ? BigDecimal.ZERO : new BigDecimal(rs.get("totalStartSettleMny").toString()));
        resp.put("totalStartSettleTaxMny", null == rs.get("totalStartSettleTaxMny") ? BigDecimal.ZERO : new BigDecimal(rs.get("totalStartSettleTaxMny").toString()));
        return resp;
    }

    @Override
    public List<RmatConSettleReportVO> pageList(Map<String, Object> paramMap) {
        return this.materialSettleMapper.pageList(paramMap);
    }
}

