/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.rmat.bean.ChangeEntity;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.ChangeStatusEnum;
import com.ejianc.business.assist.rmat.enums.DraftTypeEnum;
import com.ejianc.business.assist.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.assist.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.assist.rmat.service.IChangeService;
import com.ejianc.business.assist.rmat.service.IContractAsyncService;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.vo.ChangeVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="change")
public class ChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    @Autowired
    private IChangeService service;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IContractAsyncService contractAsyncService;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.service.selectById(billId));
        if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().equals(changeEntity.getChangeDraftType())) {
            this.service.effectiveSaveWriteContract(billId, billTypeCode, false);
        } else {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(ChangeEntity::getCommitDate, (Object)new Date());
            wrapper.eq(BaseEntity::getId, (Object)billId);
            this.service.update((Wrapper)wrapper);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(ContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u5355\u636e\u5ba1\u6279\u901a\u8fc7.getCode());
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
            this.contractService.update((Wrapper)updateWrapper);
        }
        this.checkContractFile(changeEntity);
        CommonResponse response = this.paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("0".equals(valueData)) {
            WatermarkVO watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(changeEntity.getChangeFileId(), changeEntity.getId(), changeEntity.getBillCode(), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c\u53d8\u66f4.getCode(), "arContractChange");
            Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            this.contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
        boolean delWatermarkflag;
        Object resp = null;
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.service.selectById(billId));
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u9000\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u64a4\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u8fc7\u671f.getCode());
        if (!DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().equals(changeEntity.getChangeDraftType()) && !statusList.contains(changeEntity.getSignatureStatus())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString().equals(String.valueOf(changeEntity.getSignatureStatus()))) {
            changeEntity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        } else if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().equals(changeEntity.getChangeDraftType()) && SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString().equals(String.valueOf(changeEntity.getSignatureStatus()))) {
            return CommonResponse.error((String)"\u5408\u540c\u53d8\u66f4\u5df2\u751f\u6548\uff0c\u4e0d\u80fd\u64a4\u56de!");
        }
        if (changeEntity.getWatermarkContractChangeFileId() != null && (delWatermarkflag = this.contractService.delWatermarkContractFile(changeEntity.getWatermarkContractChangeFileId()))) {
            changeEntity.setWatermarkContractChangeFileId(null);
        }
        changeEntity.setCommitDate(null);
        changeEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        this.service.saveOrUpdate((Object)changeEntity);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        contractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        return CommonResponse.success((String)"\u6267\u884c\u53d8\u66f4\u5355\u64a4\u56de\u56de\u8c03\u903b\u8f91\u6210\u529f\uff01");
    }

    private void checkContractFile(ChangeEntity changeEntity) {
        CommonResponse attachResp = this.attachmentApi.queryDetail(changeEntity.getChangeFileId().toString());
        if (!attachResp.isSuccess() || null == attachResp.getData()) {
            this.logger.info("\u5408\u540c\u5b58\u50a8\u6587\u4ef6Id-{}\u5728\u6587\u4ef6\u4e2d\u5fc3\u4e0d\u5b58\u5728\uff0c\u6839\u636e\u53c2\u6570sourceId-{}, sourceType-{}, billType-{} \u67e5\u8be2\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f", new Object[]{changeEntity.getChangeFileId(), changeEntity.getId(), "contractChangeFile", BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c\u53d8\u66f4.getCode()});
            CommonResponse attachListResp = this.attachmentApi.queryListBySourceId(changeEntity.getId(), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c\u53d8\u66f4.getCode(), "contractChangeFile", "desc");
            this.logger.info("\u6839\u636e\u53c2\u6570sourceId-{}, sourceType-{}, billType-{} \u67e5\u8be2\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u7ed3\u679c\uff1a{}", new Object[]{changeEntity.getId(), "contractChangeFile", BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c\u53d8\u66f4.getCode(), JSONObject.toJSONString((Object)attachListResp)});
            if (attachListResp.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)attachListResp.getData()))) {
                AttachmentVO attachmentVO = (AttachmentVO)((List)attachListResp.getData()).get(0);
                this.logger.info("\u5c06\u5408\u540cid-{}\u5bf9\u5e94\u5408\u540c\u6587\u4ef6Id-{}\u6539\u4e3a{}", new Object[]{changeEntity.getId(), changeEntity.getChangeFileId(), attachmentVO.getId()});
                changeEntity.setChangeFileId(attachmentVO.getId());
                changeEntity.setChangeFilePath(attachmentVO.getTruePath());
            } else {
                throw new BusinessException("\u5ba1\u6279\u5931\u8d25\uff0c\u83b7\u53d6\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u5931\u8d25, \u8bf7\u68c0\u67e5\u5408\u540c\u6587\u4ef6\uff01");
            }
        }
    }

    public CommonResponse<JSONObject> getBpmVariable(Long billId, String billTypeCode) {
        ChangeEntity e = (ChangeEntity)((Object)this.service.selectById(billId));
        List<ParamsCheckVO> list = this.service.historyPriceCtrlContractPrice((ChangeVO)BeanMapper.map((Object)((Object)e), ChangeVO.class));
        JSONObject object = new JSONObject();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list)) {
            object.put("priceFlag", (Object)"\u662f");
            this.logger.info("\u5355\u4ef7\u5f02\u5e38-----" + JSONObject.toJSONString(list));
        } else {
            object.put("priceFlag", (Object)"\u5426");
            this.logger.info("\u5355\u4ef7\u6b63\u5e38-----");
        }
        return CommonResponse.success((Object)object);
    }
}

