/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.rmat.bean.TotalPlanChangeEntity;
import com.ejianc.business.assist.rmat.bean.TotalPlanDetailChangeEntity;
import com.ejianc.business.assist.rmat.bean.TotalPlanEntity;
import com.ejianc.business.assist.rmat.mapper.TotalPlanChangeMapper;
import com.ejianc.business.assist.rmat.service.ITotalPlanChangeService;
import com.ejianc.business.assist.rmat.service.ITotalPlanDetailChangeService;
import com.ejianc.business.assist.rmat.service.ITotalPlanService;
import com.ejianc.business.assist.rmat.utils.SortUtil;
import com.ejianc.business.assist.rmat.utils.TreeNodeBUtil;
import com.ejianc.business.assist.rmat.vo.TotalPlanChangeVO;
import com.ejianc.business.assist.rmat.vo.TotalPlanDetailChangeVO;
import com.ejianc.business.assist.rmat.vo.TotalPlanVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="totalPlanChangeService")
public class TotalPlanChangeServiceImpl
extends BaseServiceImpl<TotalPlanChangeMapper, TotalPlanChangeEntity>
implements ITotalPlanChangeService {
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private ITotalPlanDetailChangeService detailChangeService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IShareMaterialApi materialApi;

    @Override
    public TotalPlanChangeVO queryDetailChange(Long id) {
        TotalPlanEntity entity = (TotalPlanEntity)((Object)this.totalPlanService.selectById(id));
        if (entity != null) {
            TotalPlanChangeVO vo = (TotalPlanChangeVO)BeanMapper.map((Object)((Object)entity), TotalPlanChangeVO.class);
            List detailVoListDb = vo.getDetailList();
            ArrayList detailVoList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)detailVoListDb)) {
                detailVoListDb.forEach(detailEntity -> {
                    if (null == detailEntity.getChangeType() || 2 != detailEntity.getChangeType()) {
                        detailVoList.add(detailEntity);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(detailVoList)) {
                for (TotalPlanDetailChangeVO cdEntity : detailVoList) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("add");
                }
                new SortUtil().entryListToSort(detailVoList, "treeIndex");
                vo.setDetailList(TreeNodeBUtil.buildTree(detailVoList));
            }
            vo.setTotalId(entity.getId());
            vo.setId(null);
            vo.setBillState(null);
            vo.setCreateUserCode(null);
            vo.setCreateTime(null);
            vo.setUpdateUserCode(null);
            vo.setUpdateTime(null);
            vo.setChangeReason(null);
            vo.setBeforeChangeMny(vo.getEstimatedMny());
            vo.setChangeVersion(Integer.valueOf(vo.getChangeVersion() + 1));
            return vo;
        }
        return null;
    }

    @Override
    public TotalPlanChangeVO saveOrUpdate(TotalPlanChangeVO saveOrUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        TotalPlanChangeEntity entity = null;
        String operateType = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L) {
            entity = (TotalPlanChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TotalPlanChangeEntity.class));
            operateType = "edit";
        } else {
            entity = (TotalPlanChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TotalPlanChangeEntity.class));
            operateType = "add";
        }
        super.saveOrUpdate((Object)entity);
        if ("edit".equals(operateType)) {
            ((TotalPlanChangeMapper)this.baseMapper).delByPlanId(entity.getId());
        }
        List<TotalPlanDetailChangeEntity> detailEntityList = entity.getDetailList();
        ArrayList<TotalPlanDetailChangeEntity> detailEntitys = new ArrayList<TotalPlanDetailChangeEntity>();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (TotalPlanDetailChangeEntity cdEntity : detailEntityList) {
                cdEntity.setId(IdWorker.getId());
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (TotalPlanDetailChangeEntity cdEntity : detailEntityList) {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                }
                cdEntity.setChangeId(entity.getId());
                if ("del".equals(cdEntity.getRowState())) continue;
                detailEntitys.add(cdEntity);
            }
            if (detailEntitys.size() > 0) {
                this.detailChangeService.saveOrUpdateBatch(detailEntitys, detailEntitys.size(), false);
            }
        }
        LambdaUpdateWrapper lambdaUpdate = new LambdaUpdateWrapper();
        lambdaUpdate.set(TotalPlanEntity::getChangingMny, (Object)entity.getEstimatedMny());
        lambdaUpdate.set(TotalPlanEntity::getChangeStatus, (Object)2);
        lambdaUpdate.set(TotalPlanEntity::getChangeCode, (Object)entity.getBillCode());
        lambdaUpdate.set(TotalPlanEntity::getChangeId, (Object)entity.getId());
        lambdaUpdate.eq(BaseEntity::getId, (Object)entity.getTotalId());
        this.totalPlanService.update((Wrapper)lambdaUpdate);
        TotalPlanChangeVO totalPlanChangeVO = this.queryDetail(entity.getId(), true);
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        TotalPlanEntity masterPlanEntity = (TotalPlanEntity)((Object)this.totalPlanService.selectById(entity.getTotalId()));
        ExecutionVO executionVO1 = this.totalPlanService.targetCost((TotalPlanVO)BeanMapper.map((Object)((Object)masterPlanEntity), TotalPlanVO.class), "");
        totalExecutionVOList.add(executionVO1.getTotalVO());
        this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
        CommonResponse response1 = this.executionApi.aggDel(totalExecutionVOList);
        if (!response1.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response1.getMsg());
        }
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        String linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/changeCard?id=" + entity.getId();
        ExecutionVO executionVO = this.totalPlanService.targetCost((TotalPlanVO)BeanMapper.map((Object)this.queryDetail(entity.getId(), false), TotalPlanVO.class), linkUrl);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return totalPlanChangeVO;
    }

    @Override
    public TotalPlanChangeVO queryDetail(Long id, boolean detailHasChildren) {
        TotalPlanChangeEntity entity = (TotalPlanChangeEntity)((Object)super.selectById((Serializable)id));
        TotalPlanChangeVO vo = (TotalPlanChangeVO)BeanMapper.map((Object)((Object)entity), TotalPlanChangeVO.class);
        List detailVoListDb = vo.getDetailList();
        ArrayList detailVoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailVoListDb)) {
            detailVoListDb.forEach(detailEntity -> {
                if (null == detailEntity.getChangeType() || 2 != detailEntity.getChangeType()) {
                    detailVoList.add(detailEntity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailVoList)) {
            for (TotalPlanDetailChangeVO cdEntity : detailVoList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("add");
            }
            new SortUtil().entryListToSort(detailVoList, "treeIndex");
            if (detailHasChildren) {
                vo.setDetailList(TreeNodeBUtil.buildTree(detailVoList));
            } else {
                vo.setDetailList(detailVoList);
            }
        }
        return vo;
    }

    @Override
    public void deleteByIds(List<TotalPlanChangeVO> vos) {
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        ArrayList<TotalPlanVO> masterPlanEntityList = new ArrayList<TotalPlanVO>();
        for (TotalPlanChangeVO vo : vos) {
            TotalPlanChangeEntity masterPlanChangeEntity = (TotalPlanChangeEntity)((Object)((TotalPlanChangeMapper)this.baseMapper).selectById(vo.getId()));
            ExecutionVO executionVO = this.totalPlanService.targetCost((TotalPlanVO)BeanMapper.map((Object)((Object)masterPlanChangeEntity), TotalPlanVO.class), "");
            totalExecutionVOList.add(executionVO.getTotalVO());
            masterPlanEntityList.add(this.totalPlanService.queryDetail(masterPlanChangeEntity.getTotalId(), false));
            TotalPlanChangeEntity changeEntity = (TotalPlanChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            LambdaUpdateWrapper lambdaUpdate = new LambdaUpdateWrapper();
            lambdaUpdate.set(TotalPlanEntity::getChangingMny, null);
            if (changeEntity.getChangeVersion() == 2) {
                lambdaUpdate.set(TotalPlanEntity::getChangeStatus, (Object)1);
            } else {
                lambdaUpdate.set(TotalPlanEntity::getChangeStatus, (Object)3);
            }
            lambdaUpdate.set(TotalPlanEntity::getChangeCode, null);
            lambdaUpdate.set(TotalPlanEntity::getChangeId, null);
            lambdaUpdate.eq(BaseEntity::getId, (Object)changeEntity.getTotalId());
            this.totalPlanService.update((Wrapper)lambdaUpdate);
            super.removeById((Serializable)vo, false);
        }
        this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
        CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        for (TotalPlanVO masterPlanEntity : masterPlanEntityList) {
            String linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + masterPlanEntity.getId();
            ExecutionVO executionVO1 = this.totalPlanService.targetCost(masterPlanEntity, linkUrl);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO1));
            CommonResponse response1 = this.executionApi.aggPush(executionVO1);
            if (response1.isSuccess()) continue;
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
    }

    @Override
    public List<TotalPlanChangeVO> queryChangeHistory(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List changeEntities = ((TotalPlanChangeMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"total_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object)"used_time"));
        if (null != changeEntities && changeEntities.size() > 0) {
            List changeVos = BeanMapper.mapList((Iterable)changeEntities, TotalPlanChangeVO.class);
            for (TotalPlanChangeVO cvo : changeVos) {
                String historyBillCode = cvo.getBillCode() + "-" + cvo.getChangeVersion();
                cvo.setHistoryBillCode(historyBillCode);
            }
            return changeVos;
        }
        return null;
    }
}

