package com.ejianc.business.assist.material.mapper;

import com.ejianc.business.assist.material.bean.MaterialContractDetailEntity;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 辅料中心采购合同
 * 
 * @author generator
 * 
 */
@Mapper
public interface MaterialContractMapper extends BaseCrudMapper<MaterialContractEntity> {
    
    @Select("select * from ejc_assistmaterial_contract where create_time >= #{time} or update_time >= #{time}")
    List<MaterialContractEntity> getContractListByTime(Date qDate);

    @Select({
            "<script>",
            "select * from ejc_assistmaterial_contract_detail where material_id is not null and contract_id in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<MaterialContractDetailEntity> getContractDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);
}
