package com.ejianc.business.assist.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.material.bean.MaterialBatchPlanDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialBatchPlanEntity;
import com.ejianc.business.assist.material.mapper.MaterialBatchPlanMapper;
import com.ejianc.business.assist.material.service.IMaterialBatchPlanDetailService;
import com.ejianc.business.assist.material.service.IMaterialBatchPlanService;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanDetailVO;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanEnum;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * 周转材批次计划
 *
 * @author generator
 */
@Service("materialBatchPlanService")
public class MaterialBatchPlanServiceImpl extends BaseServiceImpl<MaterialBatchPlanMapper, MaterialBatchPlanEntity> implements IMaterialBatchPlanService {
    private static final String BILL_CODE = "MATERIAL_BATCH_PLAN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialBatchPlanDetailService batchPlanDetailService;


    private Logger logger = LoggerFactory.getLogger(this.getClass());
    //【周转材历史最高价】 控【周转材采购申请价格】
    private final String HISTORY_MAX_PRICE_CTRL_PLAN_PRICE = "P-171zh80280";
    //【周转材历史最低价】 控【周转材采购申请价格】
    private final String HISTORY_MIN_PRICE_CTRL_PLAN_PRICE = "P-dB7t950279";
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Override
    public MaterialBatchPlanVO saveOrUpdate(MaterialBatchPlanVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MaterialBatchPlanEntity entity = null;
        String operateType = null;
        saveorUpdateVO.setTenderStatus(0);
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            entity = BeanMapper.map(saveorUpdateVO, MaterialBatchPlanEntity.class);
            operateType = "edit";
        } else {
            //新增
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveorUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            entity = BeanMapper.map(saveorUpdateVO, MaterialBatchPlanEntity.class);
            operateType = "add";
        }
        List<MaterialBatchPlanDetailVO> detailList = saveorUpdateVO.getDetailList();
        String categoryName = "";
        List<String> nameList = new ArrayList<>();
        for (MaterialBatchPlanDetailVO detailVO : detailList) {
            if (!nameList.contains(detailVO.getMaterialTypeName())) {
                if (categoryName.length() > 0) {
                    categoryName = categoryName + "," + detailVO.getMaterialTypeName();
                } else {
                    categoryName = detailVO.getMaterialTypeName();
                }
                nameList.add(detailVO.getMaterialTypeName());
                if (categoryName.length() > 100) {
                    break;
                }
            }
        }
        entity.setCategoryName(categoryName);
        super.saveOrUpdate(entity);
        //更新子表信息
        if ("edit".equals(operateType)) {
            baseMapper.delByBatchId(entity.getId());
        }
        List<MaterialBatchPlanDetailEntity> detailEntityList = BeanMapper.mapList(detailList,MaterialBatchPlanDetailEntity.class);
        if (detailEntityList.size() > 0) {
            for(MaterialBatchPlanDetailEntity detailEntity : detailEntityList){
                detailEntity.setBatchId(entity.getId());
            }
            batchPlanDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
        }
        return queryDetail(entity.getId());
    }

    @Override
    public MaterialBatchPlanVO queryDetail(Long id) {
        MaterialBatchPlanEntity MaterialBatchPlanEntity = super.selectById(id);
        MaterialBatchPlanVO vo = BeanMapper.map(MaterialBatchPlanEntity,MaterialBatchPlanVO.class);
        return vo;
    }

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState) {
        if (StringUtils.isEmpty(MaterialBatchPlanEnum.getDescriptionByStateCode(planState))) {
            throw new BusinessException("计划状态错误");
        }
        // 批量更改
        if (CollectionUtils.isNotEmpty(idList)) {
            List<MaterialBatchPlanEntity> entityList = (List<MaterialBatchPlanEntity>) super.listByIds(idList);
            if (CollectionUtils.isNotEmpty(entityList)) {
                for (MaterialBatchPlanEntity entity : entityList) {
                    // 采购完成不允许做其他操作
                    if (MaterialBatchPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getTenderStatus())) {
                        throw new BusinessException("租赁申请编码【" + entity.getBillCode() + "】项目名称【" +
                                entity.getProjectName() + "】已采购完成！");
                    }

                    entity.setTenderStatus(planState);
                }
//                entityList.forEach(entity -> {
//                    entity.setPlanState(planState);
//                });
                super.saveOrUpdateBatch(entityList);
            }
        }
    }

    @Override
    public ParamsCheckVO checkParams(MaterialBatchPlanVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");

        // 历史价控 总计划价
        paramsCheckVOS.addAll(this.historyPriceCtrlPlanPrice(vo));

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> historyPriceCtrlPlanPrice(MaterialBatchPlanVO batchPlanVO) {
        logger.info("assistrmat---MaterialBatchPlanServiceImpl---historyPriceCtrlPlanPrice()--- 历史价控采购申请单价入参：{}", JSONObject.toJSONString(batchPlanVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        CommonResponse<List<BillParamVO>> minParamByCode = new CommonResponse<>();
        List<MaterialBatchPlanDetailVO> detailList = batchPlanVO.getDetailList();

        maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MAX_PRICE_CTRL_PLAN_PRICE, batchPlanVO.getOrgId());
        minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MIN_PRICE_CTRL_PLAN_PRICE, batchPlanVO.getOrgId());

        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(maxParamByCode));


        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("周转材租赁合同历史高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info("周转材租赁合同历史低价控制信息返回："+JSONObject.toJSONString(minParamVOS));
        //todo 取优先级
        boolean flag = true;
        logger.info("传入参数--{}",JSONObject.toJSONString(PrinceDepotEnum.材料价格库.getCode()));
        CommonResponse<List<PriceDepotParamSetDTO>> commonResponse = priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.材料价格库.getCode());
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }
        List<PriceDepotParamSetDTO> data = commonResponse.getData();
        Integer priorityFlag = data.get(0).getPriorityFlag();
        if(null!=priorityFlag&&2==priorityFlag){
            //指导价优先
            flag = false;
        }
        if(CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                //日租
                for (MaterialBatchPlanDetailVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("明细：{}--高价：{}---低价：{}",detailVO.getMaterialName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPrice()==null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if(CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//低价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[minParamVO.getControlType()])) {
                    continue;
                }
                //日租
                for (MaterialBatchPlanDetailVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getMaterialName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPrice()==null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }

        return paramsCheckVOList;
    }
}
