package com.ejianc.framework.auth.session;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.context.InvocationInfoProxy;

/**
 * 用户登录信息
 * 
 * @author guominga
 * @date 2019年4月15日
 */
public class UserContext implements Serializable {

	public static final String SESSION_PREFIX = "ICOP_SESSION_USER:";
	private static final long serialVersionUID = 6176124873649049051L;

	/**
	 * 当前时间
	 */
	private String currentTs;

	/**
	 * 皮肤
	 */
	private String userSkin;

	/**
	 * 用户类型
	 */
	private String userType;

	/**
	 * 用户账号
	 */
	private String userCode;

	/**
	 * 用户姓名
	 */
	private String userName;

	/**
	 * 用户头像
	 */
	private String userAvator;

	/**
	 * 当前组织ID
	 */
	private Long orgId;

	/**
	 * 组织编号
	 */
	private String orgCode;

	/**
	 * 组织名称
	 */
	private String orgName;

	/**
	 * 组织类型
	 */
	private Integer orgType;

	/**
	 * 是否有孩子
	 */
	private Boolean isParent;

	/**
	 * 部门ID
	 */
	private Long deptId;

	/**
	 * 部门编号
	 */
	private String deptCode;

	/**
	 * 部门名称
	 */
	private String deptName;

	/**
	 * 企业名称
	 */
	private String enterpriseName;

	/**
	 * log
	 */
	private String logoPath;

	/**
	 * 员工ID
	 */
	private Long employeeId;

	/**** usercontext cookie ***/
	private Long tenantid;
	private String token;
	private String u_logints;
	private String u_usercode;
	private Long userId;

	public String getCurrentTs() {
		return currentTs;
	}

	public void setCurrentTs(String currentTs) {
		this.currentTs = currentTs;
	}

	public String getUserSkin() {
		return userSkin;
	}

	public void setUserSkin(String userSkin) {
		this.userSkin = userSkin;
	}

	public String getUserType() {
		return userType;
	}

	public void setUserType(String userType) {
		this.userType = userType;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getUserAvator() {
		return userAvator;
	}

	public void setUserAvator(String userAvator) {
		this.userAvator = userAvator;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Integer getOrgType() {
		return orgType;
	}

	public void setOrgType(Integer orgType) {
		this.orgType = orgType;
	}

	public Long getDeptId() {
		return deptId;
	}

	public void setDeptId(Long deptId) {
		this.deptId = deptId;
	}

	public String getDeptCode() {
		return deptCode;
	}

	public void setDeptCode(String deptCode) {
		this.deptCode = deptCode;
	}

	public String getDeptName() {
		return deptName;
	}

	public void setDeptName(String deptName) {
		this.deptName = deptName;
	}

	public String getEnterpriseName() {
		return enterpriseName;
	}

	public void setEnterpriseName(String enterpriseName) {
		this.enterpriseName = enterpriseName;
	}

	public String getLogoPath() {
		return logoPath;
	}

	public void setLogoPath(String logoPath) {
		this.logoPath = logoPath;
	}

	public Long getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public Long getTenantid() {
		return tenantid;
	}

	public void setTenantid(Long tenantid) {
		this.tenantid = tenantid;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getU_logints() {
		return u_logints;
	}

	public void setU_logints(String u_logints) {
		this.u_logints = u_logints;
	}

	public String getU_usercode() {
		return u_usercode;
	}

	public void setU_usercode(String u_usercode) {
		this.u_usercode = u_usercode;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getUserCode() {
		return userCode;
	}

	public void setUserCode(String userCode) {
		this.userCode = userCode;
	}

	public Boolean getIsParent() {
		return isParent;
	}

	public void setIsParent(Boolean isParent) {
		this.isParent = isParent;
	}

	public static UserContext copy(UserContext source, UserContext target) {
		if (StringUtils.isNotBlank(source.getUserSkin())) {
			target.setUserSkin(source.getUserSkin());
		}
		if (StringUtils.isNotBlank(source.getUserType())) {
			target.setUserType(source.getUserType());
		}
		if (StringUtils.isNotBlank(source.getUserName())) {
			target.setUserName(source.getUserName());
		}
		if (StringUtils.isNotBlank(source.getUserAvator())) {
			target.setUserAvator(source.getUserAvator());
		}
		if (StringUtils.isNotBlank(source.getUserCode())) {
			target.setUserCode(source.getUserCode());
		}
		if (source.getOrgId() != null) {
			target.setOrgId(source.getOrgId());
		}
		if (StringUtils.isNotBlank(source.getOrgCode())) {
			target.setOrgCode(source.getOrgCode());
		}
		if (StringUtils.isNotBlank(source.getOrgName())) {
			target.setOrgName(source.getOrgName());
		}
		if (source.getOrgType() != null) {
			target.setOrgType(source.getOrgType());
		}
		if (source.getIsParent() != null) {
			target.setIsParent(source.getIsParent());
		}
		if (source.getDeptId() != null) {
			target.setDeptId(source.getDeptId());
		}
		if (StringUtils.isNotBlank(source.getDeptCode())) {
			target.setDeptCode(source.getDeptCode());
		}
		if (StringUtils.isNotBlank(source.getDeptName())) {
			target.setDeptName(source.getDeptName());
		}
		if (StringUtils.isNotBlank(source.getEnterpriseName())) {
			target.setEnterpriseName(source.getEnterpriseName());
		}
		if (StringUtils.isNotBlank(source.getLogoPath())) {
			target.setLogoPath(source.getLogoPath());
		}
		if (source.getEmployeeId() != null) {
			target.setEmployeeId(source.getEmployeeId());
		}
		return target;
	}

	private static SessionManager sessionManager = SpringContextTools.getBean(SessionManager.class);

	public static UserContext getUserContext() {
		String sid = SESSION_PREFIX + InvocationInfoProxy.getUserid();
		String userContextStr = (String) sessionManager.getSessionCacheAttribute(sid, InvocationInfoProxy.getToken());
		UserContext userContext = JSONObject.parseObject(userContextStr, UserContext.class);
		return userContext;
	}

	@Override
	public String toString() {
		return "UserContext [currentTs=" + currentTs + ", userSkin=" + userSkin + ", userType=" + userType
				+ ", userCode=" + userCode + ", userName=" + userName + ", userAvator=" + userAvator + ", orgId="
				+ orgId + ", orgCode=" + orgCode + ", orgName=" + orgName + ", orgType=" + orgType + ", deptId="
				+ deptId + ", deptCode=" + deptCode + ", deptName=" + deptName + ", enterpriseName=" + enterpriseName
				+ ", logoPath=" + logoPath + ", employeeId=" + employeeId + ", tenantid=" + tenantid + ", token=" + token
				+ ", u_logints=" + u_logints + ", u_usercode=" + u_usercode + ", userId=" + userId + "]";
	}

}
