package com.ejianc.framework.auth.shiro;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import com.ejianc.framework.auth.token.ITokenProcessor;
import com.ejianc.framework.auth.token.TokenFactory;
import com.ejianc.framework.core.util.CookieUtil;

public class LogoutFilter extends StatelessLogoutFilter {
	
	@Autowired
	private TokenFactory tokenFactory;

	@Override
    protected void doLogout(HttpServletRequest request, HttpServletResponse response) {
		
		String token = CookieUtil.findCookieValue(request.getCookies(), AuthConstants.PARAM_TOKEN);
		String userId = CookieUtil.findCookieValue(request.getCookies(), AuthConstants.PARAM_USERID);
		if(StringUtils.isNotBlank(token)){
			ITokenProcessor tokenProcessor = tokenFactory.getTokenProcessor(token);
			Cookie[] cookies = tokenProcessor.getLogoutCookie(token, userId);
			for (int i = 0; i < cookies.length; i++) {
				response.addCookie(cookies[i]);
			}
		}
    }

}
