package com.ejianc.business.bid.consts;

import java.util.HashMap;
import java.util.Map;

/**
 * @author songlx
 * @version 1.0
 * @description: 微信公众号消息类型
 * @date 2021/10/20
 */
public enum NoticeEnum {

    /**
     * 投标报名
     * 开标日期 提前7/5/3天进行三次预警
     * 单位负责人
     */
        BID_ENROLL("开标通知单位负责人", "开标通知", "请不要忘记");

    private String desc;

    private String subject;

    private String key1;


    private static Map<NoticeEnum, String> mobileContentMap = new HashMap<>();

    private static Map<NoticeEnum, String> mobileUrlMap = new HashMap<>();

    private static Map<NoticeEnum, String> pcContentMap = new HashMap<>();


    static {
        pcContentMap.put(BID_ENROLL, "你有 #NUM# 条投标报名即将开标需要处理，投标报名【#ENGINEERINGNAME#】<a href=" + '"' + "#BASEHOST#ejc-bid-frontend/#/enroll" + '"' + ">点击查看详情</a>");
    }

    NoticeEnum(String desc, String subject, String key1) {
        this.desc = desc;
        this.subject = subject;
        this.key1 = key1;
    }

    public static String getMobileUrl(NoticeEnum notice, Map<String, String> map) {

        String url = mobileUrlMap.get(notice);

        for (Map.Entry<String, String> entry : map.entrySet()) {
            url = url.replace(entry.getKey(), entry.getValue());
        }
        return url.contains("?") ? url + "&" : url + "?";
    }

    public static String getMobileContent(NoticeEnum notice, HashMap<String, String> map) {
        String url = mobileContentMap.get(notice);

        for (Map.Entry<String, String> entry : map.entrySet()) {
            url = url.replace(entry.getKey(), entry.getValue());
        }
        return url;
    }


    public static String getPcContent(NoticeEnum notice, HashMap<String, String> map) {
        String url = pcContentMap.get(notice);

        for (Map.Entry<String, String> entry : map.entrySet()) {
            url = url.replace(entry.getKey(), entry.getValue());
        }
        return url;
    }


    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }


    public String getKey1() {
        return key1;
    }

    public void setKey1(String key1) {
        this.key1 = key1;
    }


}
