package com.ejianc.business.bid.vo;

import java.util.Date;
import java.util.List;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 投标信息跟踪中止
 * 
 * @author generator
 * 
 */
@ApiModel("投标信息跟踪中止")
public class InfoTrackStopVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("投标信息跟踪ID")
    private java.lang.Long infoTrackId;
    @ApiModelProperty("单据编码")
    private java.lang.String billCode;
    @ApiModelProperty("工程名称")
    private java.lang.String engineeringName;
    @ApiModelProperty("工程编码")
    private java.lang.String engineeringCode;
    @ApiModelProperty("申请日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private java.util.Date applyDate;
    @ApiModelProperty("终止原因")
    private java.lang.String stopReason;
    @ApiModelProperty("备注")
    private java.lang.String remark;
    @ApiModelProperty("编制人")
    private Long employeeId;
    @ApiModelProperty("编制人名称")
    private String employeeName;
    @ApiModelProperty("编制日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private java.util.Date billDate;
    @ApiModelProperty("单据状态（审批必须字段）")
    private java.lang.Integer billState;
    @ApiModelProperty("所属组织")
    private java.lang.Long orgId;
    @ApiModelProperty("所属组织名称")
    private java.lang.String orgName;

    //单据状态名称
    private String billStateName;

    //投标记录
    private List<RecordVO> records;

    public List<RecordVO> getRecords() {
        return records;
    }

    public void setRecords(List<RecordVO> records) {
        this.records = records;
    }

    /**
     * 投标信息跟踪ID
     */
    @ReferSerialTransfer(referCode = "bid-info-track")
    public Long getInfoTrackId() {
        return infoTrackId;
    }
    /**
     * 投标信息跟踪ID
     */
    @ReferDeserialTransfer
    public void setInfoTrackId(Long infoTrackId) {
        this.infoTrackId = infoTrackId;
    }

    /**
     * 单据编码
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 工程名称
     */
    public java.lang.String getEngineeringName() {
        return engineeringName;
    }

    /**
     * 工程名称
     */
    public void setEngineeringName(java.lang.String engineeringName) {
        this.engineeringName = engineeringName;
    }

    /**
     * 工程编码
     */
    public String getEngineeringCode() {
        return engineeringCode;
    }

    /**
     * 工程编码
     */
    public void setEngineeringCode(String engineeringCode) {
        this.engineeringCode = engineeringCode;
    }

    /**
     * 申请日期
     */
    public java.util.Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请日期
     */
    public void setApplyDate(java.util.Date applyDate) {
        this.applyDate = applyDate;
    }
    /**
     * 终止原因
     */
    public java.lang.String getStopReason() {
        return stopReason;
    }

    /**
     * 终止原因
     */
    public void setStopReason(java.lang.String stopReason) {
        this.stopReason = stopReason;
    }
    /**
     * 备注
     */
    public java.lang.String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(java.lang.String remark) {
        this.remark = remark;
    }

    /**
     * 编制人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    /**
     * 编制人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }
    /**
     * 编制人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 编制人日期
     */
    public Date getBillDate() {
        return billDate;
    }
    /**
     * 编制人日期
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 所属组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    @ReferDeserialTransfer
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
