package com.ejianc.business.bid.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.List;


/**
 * 投标文件评审
 * 
 * @author generator
 * 
 */
public class BidFileReviewVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long engineeringId; // 工程
    private String engineeringCode; // 工程编码
    private String engineeringName; // 工程名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date reviewDate; // 评审日期
    private Integer reviewResult; // 评审结论编码 0同意投标1采取措施后投标2不投标
    private String reviewResultName; // 评审结论
    private String builtConstructor; // 建造师
    private String remark; // 备注
    private Long orgId; // 组织ID
    private String orgName; // 组织名称
    private Long enrollId; // 报名ID
    private Integer isStop; // 是否中止
    private Long employeeId; // 编制人
    private String employeeName; // 编制人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date billDate; // 编制日期
    private Long makeOrgId; // 编制机构
    private String makeOrgName; // 编制机构
    private Long builtConstructorId; // 建造师id

    //投标记录
    private List<RecordVO> records;
    private String billStateName;
    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<RecordVO> getRecords() {
        return records;
    }

    public void setRecords(List<RecordVO> records) {
        this.records = records;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 工程
     */
    @ReferSerialTransfer(referCode = "bid-enroll")
    public Long getEngineeringId() {
        return engineeringId;
    }

    /**
     * 工程
     */
    @ReferDeserialTransfer
    public void setEngineeringId(Long engineeringId) {
        this.engineeringId = engineeringId;
    }
    /**
     * 工程编码
     */
    public String getEngineeringCode() {
        return engineeringCode;
    }

    /**
     * 工程编码
     */
    public void setEngineeringCode(String engineeringCode) {
        this.engineeringCode = engineeringCode;
    }
    /**
     * 工程名称
     */
    public String getEngineeringName() {
        return engineeringName;
    }

    /**
     * 工程名称
     */
    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    /**
     * 评审日期
     */
    public java.util.Date getReviewDate() {
        return reviewDate;
    }

    /**
     * 评审日期
     */
    public void setReviewDate(java.util.Date reviewDate) {
        this.reviewDate = reviewDate;
    }
    /**
     * 评审结论编码 0同意投标1采取措施后投标2不投标
     */
    public Integer getReviewResult() {
        return reviewResult;
    }

    /**
     * 评审结论编码 0同意投标1采取措施后投标2不投标
     */
    public void setReviewResult(Integer reviewResult) {
        this.reviewResult = reviewResult;
    }
    /**
     * 评审结论
     */
    public String getReviewResultName() {
        return reviewResultName;
    }
    /**
     * 评审结论
     */
    public void setReviewResultName(String reviewResultName) {
        this.reviewResultName = reviewResultName;
    }

    /**
     * 建造师
     */
    public String getBuiltConstructor() {
        return builtConstructor;
    }

    /**
     * 建造师
     */
    public void setBuiltConstructor(String builtConstructor) {
        this.builtConstructor = builtConstructor;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }
    /**
     * 组织ID
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织ID
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 报名ID
     */
    public Long getEnrollId() {
        return enrollId;
    }

    /**
     * 报名ID
     */
    public void setEnrollId(Long enrollId) {
        this.enrollId = enrollId;
    }
    /**
     * 是否中止
     */
    public Integer getIsStop() {
        return isStop;
    }

    /**
     * 是否中止
     */
    public void setIsStop(Integer isStop) {
        this.isStop = isStop;
    }
    /**
     * 编制人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 编制日期
     */
    public java.util.Date getBillDate() {
        return billDate;
    }

    /**
     * 编制日期
     */
    public void setBillDate(java.util.Date billDate) {
        this.billDate = billDate;
    }
    /**
     * 编制机构
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getMakeOrgId() {
        return makeOrgId;
    }

    /**
     * 编制机构
     */
    @ReferDeserialTransfer
    public void setMakeOrgId(Long makeOrgId) {
        this.makeOrgId = makeOrgId;
    }
    /**
     * 编制机构
     */
    public String getMakeOrgName() {
        return makeOrgName;
    }

    /**
     * 编制机构
     */
    public void setMakeOrgName(String makeOrgName) {
        this.makeOrgName = makeOrgName;
    }
     @ReferSerialTransfer(referCode = "JzsInfo")
    public Long getBuiltConstructorId() {
        return builtConstructorId;
    }
    @ReferDeserialTransfer
    public void setBuiltConstructorId(Long builtConstructorId) {
        this.builtConstructorId = builtConstructorId;
    }
}
