package com.ejianc.business.bid.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;


/**
 * 投标报名
 *
 * @author generator
 */
@ApiModel("投标报名")
public class EnrollVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("所属组织")
    private Long orgId;
    @ApiModelProperty("所属组织")
    private String orgName;
    @ApiModelProperty("工程名称")
    private String engineeringName;
    @ApiModelProperty("公告发布日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date publishDate;
    @ApiModelProperty("信息来源")
    private Long infoSource;
    @ApiModelProperty("信息来源名称")
    private String infoSourceName;
    @ApiModelProperty("投标单位")
    private Long bidOrgId;
    @ApiModelProperty("投标单位名称")
    private String bidOrgName;
    @ApiModelProperty("标段数量")
    private Integer bidNum;
    @ApiModelProperty("单位负责人")
    private Long followPerson;
    @ApiModelProperty("负责人名称")
    private String followPersonName;
    @ApiModelProperty("负责人电话")
    private String followPersonPhone;
    @ApiModelProperty("项目投标主管")
    private Long projectManager;
    @ApiModelProperty("项目投标主管名称")
    private String projectManagerName;
    @ApiModelProperty("项目投标主管联系方式")
    private String projectManagerPhone;
    @ApiModelProperty("招标代理机构")
    private String bidAgentOrg;
    @ApiModelProperty("编制机构")
    private Long makeOrgId;
    @ApiModelProperty("编制机构名称")
    private String makeOrgName;
    @ApiModelProperty("招标文件下载日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date bidFileDate;
    @ApiModelProperty("报名日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date signDate;
    @ApiModelProperty("是否资格预审")
    private Integer isPrecheck;
    @ApiModelProperty("是否直接发包")
    private Integer isGive;
    @ApiModelProperty("投标状态")
    private Integer bidState;
    @ApiModelProperty("地区")
    private String area;
    @ApiModelProperty("工程地点")
    private String address;
    @ApiModelProperty("建设单位")
    private Long constructionUnit;
    @ApiModelProperty("建设单位名称")
    private String constructionUnitName;
    @ApiModelProperty("建设单位性质")
    private Long constructionUnitType;
    @ApiModelProperty("建设单位性质名称")
    private String constructionUnitTypeName;
    @ApiModelProperty("业主委托人")
    private String ownerClient;
    @ApiModelProperty("业主委托人联系方式")
    private String ownerClientPhone;
    @ApiModelProperty("投资主体")
    private Long investor;
    @ApiModelProperty("投资主体名称")
    private String investorName;
    @ApiModelProperty("资金来源")
    private Long fundsSource;
    @ApiModelProperty("资金来源")
    private String fundsSourceName;
    @ApiModelProperty("投资金额")
    private java.math.BigDecimal costTotal;
    @ApiModelProperty("招标形式")
    private Integer biddingForm;
    @ApiModelProperty("开标日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date biddingDate;
    @ApiModelProperty("投标范围")
    private String bidScope;
    @ApiModelProperty("计划工期")
    private java.math.BigDecimal planDay;
    @ApiModelProperty("工程类别")
    private Long engineeringType;
    @ApiModelProperty("工程类别")
    private String engineeringTypeName;
    @ApiModelProperty("质量要求")
    private Long qualityLeave;
    @ApiModelProperty("质量要求")
    private String qualityLeaveName;
    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty("是否中止1是0否")
    private Integer isStop;
    @ApiModelProperty("投标阶段1报名3预审5标前7投标评审9投标总结")
    private Integer bidStage;
    @ApiModelProperty("1新增0信息跟踪")
    private Integer sourceType;
    @ApiModelProperty("信息跟踪来源id")
    private Long sourceId;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("省份")
    private String province;
    @ApiModelProperty("市")
    private String city;
    @ApiModelProperty("区县")
    private String region;
    @ApiModelProperty("编制人")
    private Long employeeId;
    @ApiModelProperty("编制人")
    private String employeeName;
    @ApiModelProperty("编制日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date billDate;
    @ApiModelProperty("区划编码")
    private java.lang.String adcode;


    //投标状态名称
    private String bidStateName;

    private String biddingFormName;

    private String billStateName;

    private String bidStageName;

    //投标记录
    private List<RecordVO> records;

    @ApiModelProperty("已资格预审")
    private java.lang.Integer isPreChecked;
    @ApiModelProperty("已投标文件评审")
    private java.lang.Integer isBidChecked;
    @ApiModelProperty("已招标文件评审")
    private java.lang.Integer isBidddingChecked;

    @ApiModelProperty("所属组织编码")
    private String orgCode;

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getIsPreChecked() {
        return isPreChecked;
    }

    public void setIsPreChecked(Integer isPreChecked) {
        this.isPreChecked = isPreChecked;
    }

    public Integer getIsBidChecked() {
        return isBidChecked;
    }

    public void setIsBidChecked(Integer isBidChecked) {
        this.isBidChecked = isBidChecked;
    }

    public Integer getIsBidddingChecked() {
        return isBidddingChecked;
    }

    public void setIsBidddingChecked(Integer isBidddingChecked) {
        this.isBidddingChecked = isBidddingChecked;
    }

    public List<RecordVO> getRecords() {
        return records;
    }

    public void setRecords(List<RecordVO> records) {
        this.records = records;
    }

    public String getBidStageName() {
        return bidStageName;
    }

    public void setBidStageName(String bidStageName) {
        this.bidStageName = bidStageName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    public String getBidStateName() {
        return bidStateName;
    }

    public void setBidStateName(String bidStateName) {
        this.bidStateName = bidStateName;
    }

    public String getBiddingFormName() {
        return biddingFormName;
    }

    public void setBiddingFormName(String biddingFormName) {
        this.biddingFormName = biddingFormName;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 所属组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 所属组织
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 工程名称
     */
    public String getEngineeringName() {
        return engineeringName;
    }

    /**
     * 工程名称
     */
    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }

    /**
     * 公告发布日期
     */
    public java.util.Date getPublishDate() {
        return publishDate;
    }

    /**
     * 公告发布日期
     */
    public void setPublishDate(java.util.Date publishDate) {
        this.publishDate = publishDate;
    }

    /**
     * 信息来源
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getInfoSource() {
        return infoSource;
    }

    /**
     * 信息来源
     */
    @ReferDeserialTransfer
    public void setInfoSource(Long infoSource) {
        this.infoSource = infoSource;
    }

    /**
     * 信息来源名称
     */
    public String getInfoSourceName() {
        return infoSourceName;
    }

    /**
     * 信息来源名称
     */
    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }

    /**
     * 投标单位
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getBidOrgId() {
        return bidOrgId;
    }

    /**
     * 投标单位
     */
    @ReferDeserialTransfer
    public void setBidOrgId(Long bidOrgId) {
        this.bidOrgId = bidOrgId;
    }

    /**
     * 投标单位名称
     */
    public String getBidOrgName() {
        return bidOrgName;
    }

    /**
     * 投标单位名称
     */
    public void setBidOrgName(String bidOrgName) {
        this.bidOrgName = bidOrgName;
    }

    /**
     * 标段数量
     */
    public Integer getBidNum() {
        return bidNum;
    }

    /**
     * 标段数量
     */
    public void setBidNum(Integer bidNum) {
        this.bidNum = bidNum;
    }

    /**
     * 单位负责人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getFollowPerson() {
        return followPerson;
    }

    /**
     * 单位负责人
     */
    @ReferDeserialTransfer
    public void setFollowPerson(Long followPerson) {
        this.followPerson = followPerson;
    }

    /**
     * 负责人名称
     */
    public String getFollowPersonName() {
        return followPersonName;
    }

    /**
     * 负责人名称
     */
    public void setFollowPersonName(String followPersonName) {
        this.followPersonName = followPersonName;
    }

    /**
     * 负责人电话
     */
    public String getFollowPersonPhone() {
        return followPersonPhone;
    }

    /**
     * 负责人电话
     */
    public void setFollowPersonPhone(String followPersonPhone) {
        this.followPersonPhone = followPersonPhone;
    }

    /**
     * 项目投标主管
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getProjectManager() {
        return projectManager;
    }

    /**
     * 项目投标主管
     */
    @ReferDeserialTransfer
    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    /**
     * 项目投标主管名称
     */
    public String getProjectManagerName() {
        return projectManagerName;
    }

    /**
     * 项目投标主管名称
     */
    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    /**
     * 项目投标主管联系方式
     */
    public String getProjectManagerPhone() {
        return projectManagerPhone;
    }

    /**
     * 项目投标主管联系方式
     */
    public void setProjectManagerPhone(String projectManagerPhone) {
        this.projectManagerPhone = projectManagerPhone;
    }

    /**
     * 招标代理机构
     */
    public String getBidAgentOrg() {
        return bidAgentOrg;
    }

    /**
     * 招标代理机构
     */
    public void setBidAgentOrg(String bidAgentOrg) {
        this.bidAgentOrg = bidAgentOrg;
    }

    /**
     * 编制机构
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getMakeOrgId() {
        return makeOrgId;
    }

    /**
     * 编制机构
     */
    @ReferDeserialTransfer
    public void setMakeOrgId(Long makeOrgId) {
        this.makeOrgId = makeOrgId;
    }

    /**
     * 编制机构名称
     */
    public String getMakeOrgName() {
        return makeOrgName;
    }

    /**
     * 编制机构名称
     */
    public void setMakeOrgName(String makeOrgName) {
        this.makeOrgName = makeOrgName;
    }

    /**
     * 招标文件下载日期
     */
    public java.util.Date getBidFileDate() {
        return bidFileDate;
    }

    /**
     * 招标文件下载日期
     */
    public void setBidFileDate(java.util.Date bidFileDate) {
        this.bidFileDate = bidFileDate;
    }

    /**
     * 报名日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 报名日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }

    /**
     * 是否资格预审
     */
    public Integer getIsPrecheck() {
        return isPrecheck;
    }

    /**
     * 是否资格预审
     */
    public void setIsPrecheck(Integer isPrecheck) {
        this.isPrecheck = isPrecheck;
    }

    /**
     * 是否直接发包
     */
    public Integer getIsGive() {
        return isGive;
    }

    /**
     * 是否直接发包
     */
    public void setIsGive(Integer isGive) {
        this.isGive = isGive;
    }

    /**
     * 投标状态
     */
    public Integer getBidState() {
        return bidState;
    }

    /**
     * 投标状态
     */
    public void setBidState(Integer bidState) {
        this.bidState = bidState;
    }

    /**
     * 地区
     */
    public String getArea() {
        return area;
    }

    /**
     * 地区
     */
    public void setArea(String area) {
        this.area = area;
    }

    /**
     * 工程地点
     */
    public String getAddress() {
        return address;
    }

    /**
     * 工程地点
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 建设单位
     */
    @ReferSerialTransfer(referCode = "support-customer")
    public Long getConstructionUnit() {
        return constructionUnit;
    }

    /**
     * 建设单位
     */
    @ReferDeserialTransfer
    public void setConstructionUnit(Long constructionUnit) {
        this.constructionUnit = constructionUnit;
    }

    /**
     * 建设单位名称
     */
    public String getConstructionUnitName() {
        return constructionUnitName;
    }

    /**
     * 建设单位名称
     */
    public void setConstructionUnitName(String constructionUnitName) {
        this.constructionUnitName = constructionUnitName;
    }

    /**
     * 建设单位性质
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getConstructionUnitType() {
        return constructionUnitType;
    }

    /**
     * 建设单位性质
     */
    @ReferDeserialTransfer
    public void setConstructionUnitType(Long constructionUnitType) {
        this.constructionUnitType = constructionUnitType;
    }

    /**
     * 建设单位性质名称
     */
    public String getConstructionUnitTypeName() {
        return constructionUnitTypeName;
    }

    /**
     * 建设单位性质名称
     */
    public void setConstructionUnitTypeName(String constructionUnitTypeName) {
        this.constructionUnitTypeName = constructionUnitTypeName;
    }

    /**
     * 业主委托人
     */
    public String getOwnerClient() {
        return ownerClient;
    }

    /**
     * 业主委托人
     */
    public void setOwnerClient(String ownerClient) {
        this.ownerClient = ownerClient;
    }

    /**
     * 业主委托人联系方式
     */
    public String getOwnerClientPhone() {
        return ownerClientPhone;
    }

    /**
     * 业主委托人联系方式
     */
    public void setOwnerClientPhone(String ownerClientPhone) {
        this.ownerClientPhone = ownerClientPhone;
    }

    /**
     * 投资主体
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getInvestor() {
        return investor;
    }

    /**
     * 投资主体
     */
    @ReferDeserialTransfer
    public void setInvestor(Long investor) {
        this.investor = investor;
    }

    /**
     * 投资主体名称
     */
    public String getInvestorName() {
        return investorName;
    }

    /**
     * 投资主体名称
     */
    public void setInvestorName(String investorName) {
        this.investorName = investorName;
    }

    /**
     * 资金来源
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFundsSource() {
        return fundsSource;
    }

    /**
     * 资金来源
     */
    @ReferDeserialTransfer
    public void setFundsSource(Long fundsSource) {
        this.fundsSource = fundsSource;
    }

    /**
     * 资金来源
     */
    public String getFundsSourceName() {
        return fundsSourceName;
    }

    /**
     * 资金来源
     */
    public void setFundsSourceName(String fundsSourceName) {
        this.fundsSourceName = fundsSourceName;
    }

    /**
     * 投资金额
     */
    public java.math.BigDecimal getCostTotal() {
        return costTotal;
    }

    /**
     * 投资金额
     */
    public void setCostTotal(java.math.BigDecimal costTotal) {
        this.costTotal = costTotal;
    }

    /**
     * 招标形式
     */
    public Integer getBiddingForm() {
        return biddingForm;
    }

    /**
     * 招标形式
     */
    public void setBiddingForm(Integer biddingForm) {
        this.biddingForm = biddingForm;
    }

    /**
     * 开标日期
     */
    public java.util.Date getBiddingDate() {
        return biddingDate;
    }

    /**
     * 开标日期
     */
    public void setBiddingDate(java.util.Date biddingDate) {
        this.biddingDate = biddingDate;
    }

    /**
     * 投标范围
     */
    public String getBidScope() {
        return bidScope;
    }

    /**
     * 投标范围
     */
    public void setBidScope(String bidScope) {
        this.bidScope = bidScope;
    }

    /**
     * 计划工期
     */
    public java.math.BigDecimal getPlanDay() {
        return planDay;
    }

    /**
     * 计划工期
     */
    public void setPlanDay(java.math.BigDecimal planDay) {
        this.planDay = planDay;
    }

    /**
     * 工程类别
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringType() {
        return engineeringType;
    }

    /**
     * 工程类别
     */
    @ReferDeserialTransfer
    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    /**
     * 工程类别
     */
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    /**
     * 工程类别
     */
    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    /**
     * 质量要求
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getQualityLeave() {
        return qualityLeave;
    }

    /**
     * 质量要求
     */
    @ReferDeserialTransfer
    public void setQualityLeave(Long qualityLeave) {
        this.qualityLeave = qualityLeave;
    }

    /**
     * 质量要求
     */
    public String getQualityLeaveName() {
        return qualityLeaveName;
    }

    /**
     * 质量要求
     */
    public void setQualityLeaveName(String qualityLeaveName) {
        this.qualityLeaveName = qualityLeaveName;
    }

    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 是否中止1是0否
     */
    public Integer getIsStop() {
        return isStop;
    }

    /**
     * 是否中止1是0否
     */
    public void setIsStop(Integer isStop) {
        this.isStop = isStop;
    }

    /**
     * 投标阶段1报名3预审5标前7投标评审9投标总结
     */
    public Integer getBidStage() {
        return bidStage;
    }

    /**
     * 投标阶段 参看BidStageEnum
     */
    public void setBidStage(Integer bidStage) {
        this.bidStage = bidStage;
    }

    /**
     * 1新增0信息跟踪
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 1新增0信息跟踪
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    /**
     * 信息跟踪来源id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 信息跟踪来源id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 省份
     */
    public String getProvince() {
        return province;
    }

    /**
     * 省份
     */
    public void setProvince(String province) {
        this.province = province;
    }

    /**
     * 市
     */
    public String getCity() {
        return city;
    }

    /**
     * 市
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 区县
     */
    public String getRegion() {
        return region;
    }

    /**
     * 区县
     */
    public void setRegion(String region) {
        this.region = region;
    }

    /**
     * 编制人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    /**
     * 编制人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /**
     * 编制日期
     */
    public java.util.Date getBillDate() {
        return billDate;
    }

    /**
     * 编制日期
     */
    public void setBillDate(java.util.Date billDate) {
        this.billDate = billDate;
    }

    public String getAdcode() {
        return adcode;
    }

    public void setAdcode(String adcode) {
        this.adcode = adcode;
    }
}
