package com.ejianc.business.bid.api;


import com.ejianc.business.bid.hystrix.UndertakeHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;


/**
 * @description:承揽任务登记
 *
 */
@FeignClient(name = "ejc-bid-web", url = "${common.env.feign-client-url}", path = "ejc-bid-web", fallback = UndertakeHystrix.class)
public interface UndertakeApi {
    /**
     * 根据id修改项目立项使用状态
     */
    @GetMapping(value = "/api/bid/getContractValueByOrgId")
    public CommonResponse<BigDecimal> getContractValueByOrgId(@RequestParam(value = "orgId", required = true) Long orgId);

}
