package com.ejianc.business.lock.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * CA锁使用登记表
 * 
 * @author generator
 * 
 */
public class LockUseRegisterVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人
    private String operatorCode; // 经办人联系方式
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long lockId; // 锁id
    private String lockName; // 锁名称
    private String lockProperty; // 锁性质
    private String lockModel; // 锁型号
    private String biddingPurposes; // 招标用途
    private Long projectId; // 项目
    private String projectName; // 项目名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outOfTime; // 借出日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date returnTime; // 归还日期
    private Long contactPersonId; // 项目对接人id
    private String contactPersonName; // 项目对接人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date deadline; // 锁有效期
    private String leaderApproval; // 已报领导审批
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    @ReferSerialTransfer(referCode="bid_lock")
    public Long getLockId() {
        return lockId;
    }
    @ReferDeserialTransfer
    public void setLockId(Long lockId) {
        this.lockId = lockId;
    }
    public String getLockName() {
        return lockName;
    }

    public void setLockName(String lockName) {
        this.lockName = lockName;
    }
    public String getLockProperty() {
        return lockProperty;
    }

    public void setLockProperty(String lockProperty) {
        this.lockProperty = lockProperty;
    }
    public String getLockModel() {
        return lockModel;
    }

    public void setLockModel(String lockModel) {
        this.lockModel = lockModel;
    }
    public String getBiddingPurposes() {
        return biddingPurposes;
    }

    public void setBiddingPurposes(String biddingPurposes) {
        this.biddingPurposes = biddingPurposes;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getOutOfTime() {
        return outOfTime;
    }

    public void setOutOfTime(Date outOfTime) {
        this.outOfTime = outOfTime;
    }
    public Date getReturnTime() {
        return returnTime;
    }

    public void setReturnTime(Date returnTime) {
        this.returnTime = returnTime;
    }
    public Long getContactPersonId() {
        return contactPersonId;
    }

    public void setContactPersonId(Long contactPersonId) {
        this.contactPersonId = contactPersonId;
    }
    public String getContactPersonName() {
        return contactPersonName;
    }

    public void setContactPersonName(String contactPersonName) {
        this.contactPersonName = contactPersonName;
    }
    public Date getDeadline() {
        return deadline;
    }

    public void setDeadline(Date deadline) {
        this.deadline = deadline;
    }
    public String getLeaderApproval() {
        return leaderApproval;
    }

    public void setLeaderApproval(String leaderApproval) {
        this.leaderApproval = leaderApproval;
    }
    
}
