package com.ejianc.business.bid.api;


import com.ejianc.business.bid.hystrix.UndertakeHystrix;
import com.ejianc.business.bid.vo.DeptOrderApiVO;
import com.ejianc.business.bid.vo.UndertakeApiVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;


/**
 * @description:承揽任务登记
 *
 */
@FeignClient(name = "ejc-bid-web", url = "${common.env.feign-client-url}", path = "ejc-bid-web", fallback = UndertakeHystrix.class)
public interface UndertakeApi {
    /**
     * 获取合同总金额（组织本下）
     * year == 0时，取所有年份的,当year为其他年份时取当年的 ，如year = 2022就取2022年的全年产值
     * @param orgId
     * @return
     */
    @GetMapping(value = "/api/bid/getContractValueByOrgId")
    public CommonResponse<BigDecimal> getContractValueByOrgId(@RequestParam(value = "orgId", required = true) Long orgId,
                                                              @RequestParam(value = "year") Integer year);

    /**
     * 获取饼状图信息（组织本下）
     * time  1：月度  2：季度  3：年度
     */
    @GetMapping(value = "/api/bid/getUndertakeInfo")
    public CommonResponse<List<UndertakeApiVO>> getUndertakeInfo(
            @RequestParam(value = "orgId", required = true) Long orgId,
            @RequestParam(value = "time", required = true) Integer time
    );
    /**
     * 获取子分单位排名
     *@param type 1：承揽金额   2：产值统计
     *@param time 1：月度  2：季度  3：年度
     */
    @GetMapping(value = "/api/bid/getDeptOrder")
    public CommonResponse<List<DeptOrderApiVO>> getDeptOrder(@RequestParam(value = "type", required = true) Integer type,
                                                             @RequestParam(value = "time", required = true) Integer time
    );

}
