package com.ejianc.business.bid.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 投标文件评审-商务
 * 
 * @author generator
 * 
 */
public class BidFileReviewBisVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long engineeringId; // 工程
    private String engineeringCode; // 工程编码
    private String engineeringName; // 工程名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reviewDate; // 评审日期
    private Integer reviewResult; // 评审结论编码 0同意投标1采取措施后投标2不投标
    private String reviewResultName; // 评审结论
    private String builtConstructor; // 建造师
    private Integer bidFileType; // 0:纸质标1：电子标
    private String remark; // 备注
    private Long orgId; // 组织ID
    private String orgCode; // 所属组织编码
    private String orgName; // 组织名称
    private Long enrollId; // 报名ID
    private Integer isStop; // 是否中止
    private Long employeeId; // 编制人
    private String employeeName; // 编制人
    private String employeeCode; // 编制人编码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 编制日期
    private Long makeOrgId; // 编制机构
    private String makeOrgName; // 编制机构
    private Long builtConstructorId; // 建造师id
    private String zcbh; // 注册编号
    private Long pid; // 建造师人员表id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date biddingDate; // 开标日期

    //投标记录
    private List<RecordVO> records;
    private String billStateName;


    public List<RecordVO> getRecords() {
        return records;
    }

    public void setRecords(List<RecordVO> records) {
        this.records = records;
    }
    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "bid-enroll")
    public Long getEngineeringId() {
        return engineeringId;
    }
    @ReferDeserialTransfer
    public void setEngineeringId(Long engineeringId) {
        this.engineeringId = engineeringId;
    }
    public String getEngineeringCode() {
        return engineeringCode;
    }

    public void setEngineeringCode(String engineeringCode) {
        this.engineeringCode = engineeringCode;
    }
    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    public Date getReviewDate() {
        return reviewDate;
    }

    public void setReviewDate(Date reviewDate) {
        this.reviewDate = reviewDate;
    }
    public Integer getReviewResult() {
        return reviewResult;
    }

    public void setReviewResult(Integer reviewResult) {
        this.reviewResult = reviewResult;
    }
    public String getReviewResultName() {
        return reviewResultName;
    }

    public void setReviewResultName(String reviewResultName) {
        this.reviewResultName = reviewResultName;
    }
    public String getBuiltConstructor() {
        return builtConstructor;
    }

    public void setBuiltConstructor(String builtConstructor) {
        this.builtConstructor = builtConstructor;
    }
    public Integer getBidFileType() {
        return bidFileType;
    }

    public void setBidFileType(Integer bidFileType) {
        this.bidFileType = bidFileType;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEnrollId() {
        return enrollId;
    }

    public void setEnrollId(Long enrollId) {
        this.enrollId = enrollId;
    }
    public Integer getIsStop() {
        return isStop;
    }

    public void setIsStop(Integer isStop) {
        this.isStop = isStop;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getMakeOrgId() {
        return makeOrgId;
    }
    @ReferDeserialTransfer
    public void setMakeOrgId(Long makeOrgId) {
        this.makeOrgId = makeOrgId;
    }
    public String getMakeOrgName() {
        return makeOrgName;
    }

    public void setMakeOrgName(String makeOrgName) {
        this.makeOrgName = makeOrgName;
    }
    public Long getBuiltConstructorId() {
        return builtConstructorId;
    }

    public void setBuiltConstructorId(Long builtConstructorId) {
        this.builtConstructorId = builtConstructorId;
    }
    public String getZcbh() {
        return zcbh;
    }

    public void setZcbh(String zcbh) {
        this.zcbh = zcbh;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public Date getBiddingDate() {
        return biddingDate;
    }

    public void setBiddingDate(Date biddingDate) {
        this.biddingDate = biddingDate;
    }
    
}
