package com.ejianc.business.bid.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


/**
 * 投标报名
 *
 * @author generator
 */
@ApiModel("投标报名")
public class EnrollVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 招标编号
    private Long orgId; // 所属组织
    private String orgName; // 所属组织
    private String engineeringName; // 投标项目名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date publishDate; // 经办日期
    private Long infoSource; // 信息来源
    private String infoSourceName; // 信息来源名称
    private Long bidOrgId; // 申请单位
    private String bidOrgName; // 申请单位名称
    private Integer bidNum; // 标段数量
    private Long followPerson; // 项目联系人
    private String followPersonName; // 项目联系人名称
    private String followPersonPhone; // 项目联系人电话
    private Long projectManager; // 申请人员
    private String projectManagerName; // 申请人员名称
    private String projectManagerPhone; // 申请人员电话
    private String bidAgentOrg; // 招标代理机构
    private Long makeOrgId; // 编制机构
    private String makeOrgName; // 编制机构名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date bidFileDate; // 招标文件下载日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 申请日期
    private Integer isPrecheck; // 是否需要资格预审
    private Integer isGive; // 是否直接发包
    private Integer bidState; // 投标状态
    private String area; // 地区
    private String address; // 工程地点
    private Long constructionUnit; // 建设单位
    private String constructionUnitName; // 建设单位名称
    private Long constructionUnitType; // 建设单位性质
    private String constructionUnitTypeName; // 建设单位性质名称
    private String ownerClient; // 业主委托人
    private String ownerClientPhone; // 业主委托人联系方式
    private Long investor; // 投资主体
    private String investorName; // 投资主体名称
    private Long fundsSource; // 资金来源
    private String fundsSourceName; // 资金来源
    private BigDecimal costTotal; // 投资金额
    private Integer biddingForm; // 招标形式
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date biddingDate; // 开标日期
    private String bidScope; // 投标范围
    private BigDecimal planDay; // 计划工期
    private Long engineeringType; // 工程类别
    private String engineeringTypeName; // 工程类别
    private Long qualityLeave; // 质量要求
    private String qualityLeaveName; // 质量要求
    private String remark; // 备注
    private Integer isStop; // 是否中止1是0否
    private Integer bidStage; // 投标阶段
    private Integer sourceType; // 1新增0信息跟踪
    private Long sourceId; // 信息跟踪来源id
    private Integer billState; // 单据状态（审批必须字段）
    private String province; // 省份
    private String city; // 市
    private String region; // 区县
    private Long employeeId; // 编制人
    private String employeeName; // 编制人
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 编制日期
    private String adcode; // 区划编码
    private Integer isPreChecked; // 已资格预审
    private Integer isBidChecked; // 已投标文件评审
    private Integer isBidddingChecked; // 已招标文件评审
    private String orgCode; // 所属组织编码
    private Integer flagTec; // 技术评审标识 0没有 1已提交
    private Integer flagBis; // 商务评审标识 0没有 1已提交
    private Integer flagValue; // 价格评审标识 0没有 1已提交
    private String depositBank; // 开户银行
    private String accountName; // 开户名称
    private String accountNumber; // 开户账号
    private Integer needSupportProject; // 需支持项目(0：标书费，1:资政文件，2：其他)
    private String needSupportProjectInfo; // 需支持项目信息
    private Integer cashDiscount; // 是否现金支付(0：否，1：是)
    private BigDecimal tenderFee; // 标书费用
    private String tenderFeeCapital; // 费用金额(大写）
    private String analysisReport; // 投标项目信息分析报告
    private Long analysisReportId; // 投标项目信息分析报告id
    private Long deptId; // 经办部门id
    private String deptName; // 经办部门名称
    private String deptCode; // 经办部门code



    //投标状态名称
    private String bidStateName;

    private String biddingFormName;

    private String billStateName;

    private String bidStageName;

    //投标记录
    private List<RecordVO> records;



    public Integer getFlagTec() {
        return flagTec;
    }

    public void setFlagTec(Integer flagTec) {
        this.flagTec = flagTec;
    }

    public Integer getFlagBis() {
        return flagBis;
    }

    public void setFlagBis(Integer flagBis) {
        this.flagBis = flagBis;
    }

    public Integer getFlagValue() {
        return flagValue;
    }

    public void setFlagValue(Integer flagValue) {
        this.flagValue = flagValue;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getIsPreChecked() {
        return isPreChecked;
    }

    public void setIsPreChecked(Integer isPreChecked) {
        this.isPreChecked = isPreChecked;
    }

    public Integer getIsBidChecked() {
        return isBidChecked;
    }

    public void setIsBidChecked(Integer isBidChecked) {
        this.isBidChecked = isBidChecked;
    }

    public Integer getIsBidddingChecked() {
        return isBidddingChecked;
    }

    public void setIsBidddingChecked(Integer isBidddingChecked) {
        this.isBidddingChecked = isBidddingChecked;
    }

    public List<RecordVO> getRecords() {
        return records;
    }

    public void setRecords(List<RecordVO> records) {
        this.records = records;
    }

    public String getBidStageName() {
        return bidStageName;
    }

    public void setBidStageName(String bidStageName) {
        this.bidStageName = bidStageName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    public String getBidStateName() {
        return bidStateName;
    }

    public void setBidStateName(String bidStateName) {
        this.bidStateName = bidStateName;
    }

    public String getBiddingFormName() {
        return biddingFormName;
    }

    public void setBiddingFormName(String biddingFormName) {
        this.biddingFormName = biddingFormName;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 所属组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 所属组织
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 工程名称
     */
    public String getEngineeringName() {
        return engineeringName;
    }

    /**
     * 工程名称
     */
    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }

    /**
     * 公告发布日期
     */
    public Date getPublishDate() {
        return publishDate;
    }

    /**
     * 公告发布日期
     */
    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }

    /**
     * 信息来源
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getInfoSource() {
        return infoSource;
    }

    /**
     * 信息来源
     */
    @ReferDeserialTransfer
    public void setInfoSource(Long infoSource) {
        this.infoSource = infoSource;
    }

    /**
     * 信息来源名称
     */
    public String getInfoSourceName() {
        return infoSourceName;
    }

    /**
     * 信息来源名称
     */
    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }

    /**
     * 投标单位
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getBidOrgId() {
        return bidOrgId;
    }

    /**
     * 投标单位
     */
    @ReferDeserialTransfer
    public void setBidOrgId(Long bidOrgId) {
        this.bidOrgId = bidOrgId;
    }

    /**
     * 投标单位名称
     */
    public String getBidOrgName() {
        return bidOrgName;
    }

    /**
     * 投标单位名称
     */
    public void setBidOrgName(String bidOrgName) {
        this.bidOrgName = bidOrgName;
    }

    /**
     * 标段数量
     */
    public Integer getBidNum() {
        return bidNum;
    }

    /**
     * 标段数量
     */
    public void setBidNum(Integer bidNum) {
        this.bidNum = bidNum;
    }

    /**
     * 单位负责人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getFollowPerson() {
        return followPerson;
    }

    /**
     * 单位负责人
     */
    @ReferDeserialTransfer
    public void setFollowPerson(Long followPerson) {
        this.followPerson = followPerson;
    }

    /**
     * 负责人名称
     */
    public String getFollowPersonName() {
        return followPersonName;
    }

    /**
     * 负责人名称
     */
    public void setFollowPersonName(String followPersonName) {
        this.followPersonName = followPersonName;
    }

    /**
     * 负责人电话
     */
    public String getFollowPersonPhone() {
        return followPersonPhone;
    }

    /**
     * 负责人电话
     */
    public void setFollowPersonPhone(String followPersonPhone) {
        this.followPersonPhone = followPersonPhone;
    }

    /**
     * 申请人员
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getProjectManager() {
        return projectManager;
    }

    /**
     * 申请人员
     */
    @ReferDeserialTransfer
    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    /**
     * 申请人员名称
     */
    public String getProjectManagerName() {
        return projectManagerName;
    }

    /**
     * 申请人员名称
     */
    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    /**
     * 申请人员联系方式
     */
    public String getProjectManagerPhone() {
        return projectManagerPhone;
    }

    /**
     * 申请人员联系方式
     */
    public void setProjectManagerPhone(String projectManagerPhone) {
        this.projectManagerPhone = projectManagerPhone;
    }

    /**
     * 招标代理机构
     */
    public String getBidAgentOrg() {
        return bidAgentOrg;
    }

    /**
     * 招标代理机构
     */
    public void setBidAgentOrg(String bidAgentOrg) {
        this.bidAgentOrg = bidAgentOrg;
    }

    /**
     * 编制机构
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getMakeOrgId() {
        return makeOrgId;
    }

    /**
     * 编制机构
     */
    @ReferDeserialTransfer
    public void setMakeOrgId(Long makeOrgId) {
        this.makeOrgId = makeOrgId;
    }

    /**
     * 编制机构名称
     */
    public String getMakeOrgName() {
        return makeOrgName;
    }

    /**
     * 编制机构名称
     */
    public void setMakeOrgName(String makeOrgName) {
        this.makeOrgName = makeOrgName;
    }

    /**
     * 招标文件下载日期
     */
    public Date getBidFileDate() {
        return bidFileDate;
    }

    /**
     * 招标文件下载日期
     */
    public void setBidFileDate(Date bidFileDate) {
        this.bidFileDate = bidFileDate;
    }

    /**
     * 报名日期
     */
    public Date getSignDate() {
        return signDate;
    }

    /**
     * 报名日期
     */
    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    /**
     * 是否资格预审
     */
    public Integer getIsPrecheck() {
        return isPrecheck;
    }

    /**
     * 是否资格预审
     */
    public void setIsPrecheck(Integer isPrecheck) {
        this.isPrecheck = isPrecheck;
    }

    /**
     * 是否直接发包
     */
    public Integer getIsGive() {
        return isGive;
    }

    /**
     * 是否直接发包
     */
    public void setIsGive(Integer isGive) {
        this.isGive = isGive;
    }

    /**
     * 投标状态
     */
    public Integer getBidState() {
        return bidState;
    }

    /**
     * 投标状态
     */
    public void setBidState(Integer bidState) {
        this.bidState = bidState;
    }

    /**
     * 地区
     */
    public String getArea() {
        return area;
    }

    /**
     * 地区
     */
    public void setArea(String area) {
        this.area = area;
    }

    /**
     * 工程地点
     */
    public String getAddress() {
        return address;
    }

    /**
     * 工程地点
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 建设单位
     */
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getConstructionUnit() {
        return constructionUnit;
    }

    /**
     * 建设单位
     */
    @ReferDeserialTransfer
    public void setConstructionUnit(Long constructionUnit) {
        this.constructionUnit = constructionUnit;
    }

    /**
     * 建设单位名称
     */
    public String getConstructionUnitName() {
        return constructionUnitName;
    }

    /**
     * 建设单位名称
     */
    public void setConstructionUnitName(String constructionUnitName) {
        this.constructionUnitName = constructionUnitName;
    }

    /**
     * 建设单位性质
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getConstructionUnitType() {
        return constructionUnitType;
    }

    /**
     * 建设单位性质
     */
    @ReferDeserialTransfer
    public void setConstructionUnitType(Long constructionUnitType) {
        this.constructionUnitType = constructionUnitType;
    }

    /**
     * 建设单位性质名称
     */
    public String getConstructionUnitTypeName() {
        return constructionUnitTypeName;
    }

    /**
     * 建设单位性质名称
     */
    public void setConstructionUnitTypeName(String constructionUnitTypeName) {
        this.constructionUnitTypeName = constructionUnitTypeName;
    }

    /**
     * 业主委托人
     */
    public String getOwnerClient() {
        return ownerClient;
    }

    /**
     * 业主委托人
     */
    public void setOwnerClient(String ownerClient) {
        this.ownerClient = ownerClient;
    }

    /**
     * 业主委托人联系方式
     */
    public String getOwnerClientPhone() {
        return ownerClientPhone;
    }

    /**
     * 业主委托人联系方式
     */
    public void setOwnerClientPhone(String ownerClientPhone) {
        this.ownerClientPhone = ownerClientPhone;
    }

    /**
     * 投资主体
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getInvestor() {
        return investor;
    }

    /**
     * 投资主体
     */
    @ReferDeserialTransfer
    public void setInvestor(Long investor) {
        this.investor = investor;
    }

    /**
     * 投资主体名称
     */
    public String getInvestorName() {
        return investorName;
    }

    /**
     * 投资主体名称
     */
    public void setInvestorName(String investorName) {
        this.investorName = investorName;
    }

    /**
     * 资金来源
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFundsSource() {
        return fundsSource;
    }

    /**
     * 资金来源
     */
    @ReferDeserialTransfer
    public void setFundsSource(Long fundsSource) {
        this.fundsSource = fundsSource;
    }

    /**
     * 资金来源
     */
    public String getFundsSourceName() {
        return fundsSourceName;
    }

    /**
     * 资金来源
     */
    public void setFundsSourceName(String fundsSourceName) {
        this.fundsSourceName = fundsSourceName;
    }

    /**
     * 投资金额
     */
    public java.math.BigDecimal getCostTotal() {
        return costTotal;
    }

    /**
     * 投资金额
     */
    public void setCostTotal(java.math.BigDecimal costTotal) {
        this.costTotal = costTotal;
    }

    /**
     * 招标形式
     */
    public Integer getBiddingForm() {
        return biddingForm;
    }

    /**
     * 招标形式
     */
    public void setBiddingForm(Integer biddingForm) {
        this.biddingForm = biddingForm;
    }

    /**
     * 开标日期
     */
    public Date getBiddingDate() {
        return biddingDate;
    }

    /**
     * 开标日期
     */
    public void setBiddingDate(Date biddingDate) {
        this.biddingDate = biddingDate;
    }

    /**
     * 投标范围
     */
    public String getBidScope() {
        return bidScope;
    }

    /**
     * 投标范围
     */
    public void setBidScope(String bidScope) {
        this.bidScope = bidScope;
    }

    /**
     * 计划工期
     */
    public java.math.BigDecimal getPlanDay() {
        return planDay;
    }

    /**
     * 计划工期
     */
    public void setPlanDay(java.math.BigDecimal planDay) {
        this.planDay = planDay;
    }

    /**
     * 工程类别
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringType() {
        return engineeringType;
    }

    /**
     * 工程类别
     */
    @ReferDeserialTransfer
    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    /**
     * 工程类别
     */
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    /**
     * 工程类别
     */
    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    /**
     * 质量要求
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getQualityLeave() {
        return qualityLeave;
    }

    /**
     * 质量要求
     */
    @ReferDeserialTransfer
    public void setQualityLeave(Long qualityLeave) {
        this.qualityLeave = qualityLeave;
    }

    /**
     * 质量要求
     */
    public String getQualityLeaveName() {
        return qualityLeaveName;
    }

    /**
     * 质量要求
     */
    public void setQualityLeaveName(String qualityLeaveName) {
        this.qualityLeaveName = qualityLeaveName;
    }

    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 是否中止1是0否
     */
    public Integer getIsStop() {
        return isStop;
    }

    /**
     * 是否中止1是0否
     */
    public void setIsStop(Integer isStop) {
        this.isStop = isStop;
    }

    /**
     * 投标阶段1报名3预审5标前7投标评审9投标总结
     */
    public Integer getBidStage() {
        return bidStage;
    }

    /**
     * 投标阶段 参看BidStageEnum
     */
    public void setBidStage(Integer bidStage) {
        this.bidStage = bidStage;
    }

    /**
     * 1新增0信息跟踪
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 1新增0信息跟踪
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    /**
     * 信息跟踪来源id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 信息跟踪来源id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 省份
     */
    public String getProvince() {
        return province;
    }

    /**
     * 省份
     */
    public void setProvince(String province) {
        this.province = province;
    }

    /**
     * 市
     */
    public String getCity() {
        return city;
    }

    /**
     * 市
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 区县
     */
    public String getRegion() {
        return region;
    }

    /**
     * 区县
     */
    public void setRegion(String region) {
        this.region = region;
    }

    /**
     * 编制人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    /**
     * 编制人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /**
     * 编制日期
     */
    public Date getBillDate() {
        return billDate;
    }

    /**
     * 编制日期
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public String getAdcode() {
        return adcode;
    }

    public void setAdcode(String adcode) {
        this.adcode = adcode;
    }

    public String getDepositBank() {
        return depositBank;
    }

    public void setDepositBank(String depositBank) {
        this.depositBank = depositBank;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Integer getNeedSupportProject() {
        return needSupportProject;
    }

    public void setNeedSupportProject(Integer needSupportProject) {
        this.needSupportProject = needSupportProject;
    }

    public String getNeedSupportProjectInfo() {
        return needSupportProjectInfo;
    }

    public void setNeedSupportProjectInfo(String needSupportProjectInfo) {
        this.needSupportProjectInfo = needSupportProjectInfo;
    }

    public Integer getCashDiscount() {
        return cashDiscount;
    }

    public void setCashDiscount(Integer cashDiscount) {
        this.cashDiscount = cashDiscount;
    }

    public BigDecimal getTenderFee() {
        return tenderFee;
    }

    public void setTenderFee(BigDecimal tenderFee) {
        this.tenderFee = tenderFee;
    }

    public String getTenderFeeCapital() {
        return tenderFeeCapital;
    }

    public void setTenderFeeCapital(String tenderFeeCapital) {
        this.tenderFeeCapital = tenderFeeCapital;
    }

    public String getAnalysisReport() {
        return analysisReport;
    }

    public void setAnalysisReport(String analysisReport) {
        this.analysisReport = analysisReport;
    }

    public Long getAnalysisReportId() {
        return analysisReportId;
    }

    public void setAnalysisReportId(Long analysisReportId) {
        this.analysisReportId = analysisReportId;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getDeptCode() {
        return deptCode;
    }

    public void setDeptCode(String deptCode) {
        this.deptCode = deptCode;
    }
}
