package com.ejianc.business.bid.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 投标交底表
 * 
 * @author generator
 * 
 */
public class DisclosureVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long engineeringId; // 投标项目id
    private String engineeringCode; // 投标项目code
    private String engineeringName; // 投标项目名称
    private Long disclosureDutyId; // 交底责任人
    private String disclosureDutyName; // 交底责任人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date disclosureTime; // 交底日期
    private String attachmentName; // 附件名称
    private String attachmentId; // 附件id
    private String remark; // 备注
    private Long orgId; // 组织ID
    private String orgCode; // 所属组织编码
    private String orgName; // 组织名称
    private Long makeOrgId; // 编制单位ID
    private String makeOrgCode; // 编制单位编码
    private String makeOrgName; // 编制单位名称
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "bid-enroll")
    public Long getEngineeringId() {
        return engineeringId;
    }
    @ReferDeserialTransfer
    public void setEngineeringId(Long engineeringId) {
        this.engineeringId = engineeringId;
    }
    public String getEngineeringCode() {
        return engineeringCode;
    }

    public void setEngineeringCode(String engineeringCode) {
        this.engineeringCode = engineeringCode;
    }
    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getDisclosureDutyId() {
        return disclosureDutyId;
    }
    @ReferDeserialTransfer
    public void setDisclosureDutyId(Long disclosureDutyId) {
        this.disclosureDutyId = disclosureDutyId;
    }
    public String getDisclosureDutyName() {
        return disclosureDutyName;
    }

    public void setDisclosureDutyName(String disclosureDutyName) {
        this.disclosureDutyName = disclosureDutyName;
    }
    public Date getDisclosureTime() {
        return disclosureTime;
    }

    public void setDisclosureTime(Date disclosureTime) {
        this.disclosureTime = disclosureTime;
    }
    public String getAttachmentName() {
        return attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }
    public String getAttachmentId() {
        return attachmentId;
    }

    public void setAttachmentId(String attachmentId) {
        this.attachmentId = attachmentId;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getMakeOrgId() {
        return makeOrgId;
    }
    @ReferDeserialTransfer
    public void setMakeOrgId(Long makeOrgId) {
        this.makeOrgId = makeOrgId;
    }

    public String getMakeOrgCode() {
        return makeOrgCode;
    }

    public void setMakeOrgCode(String makeOrgCode) {
        this.makeOrgCode = makeOrgCode;
    }

    public String getMakeOrgName() {
        return makeOrgName;
    }

    public void setMakeOrgName(String makeOrgName) {
        this.makeOrgName = makeOrgName;
    }
}
