package com.ejianc.business.bid.vo;

import java.util.Date;
import java.util.List;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 投标停止申请
 * 
 * @author generator
 * 
 */
@ApiModel("投标停止申请")
public class StopApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("投标报名ID")
    private Long enrollId;
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("工程名称")
    private String engineeringName;
    @ApiModelProperty("工程编码")
    private String engineeringCode;
    @ApiModelProperty("申请日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date applyDate;
    @ApiModelProperty("终止原因")
    private String stopReason;
    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty("编制人")
    private Long employeeId;
    @ApiModelProperty("编制人名称")
    private String employeeName;
    @ApiModelProperty("编制日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date billDate;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("所属组织")
    private Long orgId;
    @ApiModelProperty("所属组织名称")
    private String orgName;


    @ApiModelProperty("所属组织编码")
    private String orgCode;

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }



    //单据状态名称
    private String billStateName;
    //投标记录
    private List<RecordVO> records;

    public List<RecordVO> getRecords() {
        return records;
    }

    public void setRecords(List<RecordVO> records) {
        this.records = records;
    }

    /**
     * 投标报名ID
     */
    @ReferSerialTransfer(referCode = "bid-enroll")
    public Long getEnrollId() {
        return enrollId;
    }
    /**
     * 投标报名ID
     */
    @ReferDeserialTransfer
    public void setEnrollId(Long enrollId) {
        this.enrollId = enrollId;
    }

    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 工程名称
     */
    public String getEngineeringName() {
        return engineeringName;
    }

    /**
     * 工程名称
     */
    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }

    /**
     * 工程编码
     */
    public String getEngineeringCode() {
        return engineeringCode;
    }

    /**
     * 工程编码
     */
    public void setEngineeringCode(String engineeringCode) {
        this.engineeringCode = engineeringCode;
    }

    /**
     * 申请日期
     */
    public Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请日期
     */
    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    /**
     * 终止原因
     */
    public String getStopReason() {
        return stopReason;
    }

    /**
     * 终止原因
     */
    public void setStopReason(String stopReason) {
        this.stopReason = stopReason;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }
    /**
     * 编制人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    /**
     * 编制人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }
    /**
     * 编制人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 编制时间
     */
    public Date getBillDate() {
        return billDate;
    }
    /**
     * 编制时间
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 所属组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
