package com.ejianc.business.bid.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 项目申请业主考察接待表
 * 
 * @author generator
 * 
 */
public class ReceptionVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String operatorCode; // 经办人联系方式
    private String updateUserName; // 修改者
    private String remark; // 备注
    private String applicantName; // 申请人
    private Long departmentId; // 所属项目经理部
    private String departmentName; // 所属项目经理部名称
    private Long departmentPeoId; // 项目部参加人员
    private String departmentPeoName; // 项目部参加人员名称
    private String departmentPeoPhone; // 项目部参加人员电话
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date applicantDate; // 申请时间
    private String inspectOrgName; // 考察单位
    private String inspectPeoName; // 考察单位代表
    private String inspectPeoPhone; // 考察单位代表电话
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date startDate; // 拟接待开始时间
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date endDate; // 拟接待结束时间
    private String inspectContents; // 考察内容
    private String inspectContentsId; // 考察内容

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getInspectContentsId() {
        return inspectContentsId;
    }
    @ReferDeserialTransfer
    public void setInspectContentsId(String inspectContentsId) {
        this.inspectContentsId = inspectContentsId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getApplicantName() {
        return applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getDepartmentPeoId() {
        return departmentPeoId;
    }

    public void setDepartmentPeoId(Long departmentPeoId) {
        this.departmentPeoId = departmentPeoId;
    }
    public String getDepartmentPeoName() {
        return departmentPeoName;
    }

    public void setDepartmentPeoName(String departmentPeoName) {
        this.departmentPeoName = departmentPeoName;
    }
    public String getDepartmentPeoPhone() {
        return departmentPeoPhone;
    }

    public void setDepartmentPeoPhone(String departmentPeoPhone) {
        this.departmentPeoPhone = departmentPeoPhone;
    }
    public Date getApplicantDate() {
        return applicantDate;
    }

    public void setApplicantDate(Date applicantDate) {
        this.applicantDate = applicantDate;
    }

    //@ReferSerialTransfer(referCode = "support-defdoc")
    public String getInspectOrgName() {
        return inspectOrgName;
    }
    //@ReferDeserialTransfer
    public void setInspectOrgName(String inspectOrgName) {
        this.inspectOrgName = inspectOrgName;
    }
    public String getInspectPeoName() {
        return inspectPeoName;
    }

    public void setInspectPeoName(String inspectPeoName) {
        this.inspectPeoName = inspectPeoName;
    }
    public String getInspectPeoPhone() {
        return inspectPeoPhone;
    }

    public void setInspectPeoPhone(String inspectPeoPhone) {
        this.inspectPeoPhone = inspectPeoPhone;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getInspectContents() {
        return inspectContents;
    }

    public void setInspectContents(String inspectContents) {
        this.inspectContents = inspectContents;
    }
    
}
