package com.ejianc.business.bid.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 投标记录
 *
 * @author generator
 */
@ApiModel("投标记录")
public class RecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("工程编码")
    private String engineeringCode;
    @ApiModelProperty("阶段名称")
    private String bidStageName;
    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate;
    @ApiModelProperty("阶段标志")
    private Integer bidStage;
    @ApiModelProperty("单据id")
    private Long billId;

    private List<RecordVO> subRecords = new ArrayList<>();

    public RecordVO() {
    }

    public RecordVO(Integer bidStage, List<RecordVO> subRecords) {
        this.bidStage = bidStage;
        this.bidStageName = BidStageEnum.getNameByCode(bidStage);
        if (subRecords.size() == 1) {
            this.billId = subRecords.get(0).getBillId();
        } else {
            this.subRecords = subRecords;
        }

    }

    public List<RecordVO> getSubRecords() {
        return subRecords;
    }

    public void setSubRecords(List<RecordVO> subRecords) {
        this.subRecords = subRecords;
    }

    public RecordVO(Long billId, String engineeringCode, Integer bidStage, String bidStageName, Date billDate) {
        this.engineeringCode = engineeringCode;
        this.bidStageName = bidStageName;
        this.billDate = billDate;
        this.bidStage = bidStage;
        this.billId = billId;
    }

    public String getEngineeringCode() {
        return engineeringCode;
    }

    public void setEngineeringCode(String engineeringCode) {
        this.engineeringCode = engineeringCode;
    }

    public String getBidStageName() {
        return bidStageName;
    }

    public void setBidStageName(String bidStageName) {
        this.bidStageName = bidStageName;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public Integer getBidStage() {
        return bidStage;
    }

    public void setBidStage(Integer bidStage) {
        this.bidStage = bidStage;
    }

    public Long getBillId() {
        return billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }
}
