package com.ejianc.business.bid.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;


/**
 * 资格预审
 *
 * @author generator
 *
 */
public class PrequaliFicationVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("工程编码")
    private String engineeringCode;
    @ApiModelProperty("工程名称")
    private Long engineeringId;
    @ApiModelProperty("工程名称")
    private String engineeringName;
    @ApiModelProperty("预审日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date estimatedExamineDate;
    @ApiModelProperty("预审结果 1通过 0未通过")
    private Integer estimatedExamineResult;
    @ApiModelProperty("预审结果")
    private String estimatedExamineResultName;
    @ApiModelProperty("未通过原因")
    private String failReason;
    @ApiModelProperty("建造师")
    private String builtConstructor;
    @ApiModelProperty("拟派技术负责人")
    private String technicallyConscientiousPerson;
    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty("所属组织")
    private Long orgId;
    @ApiModelProperty("所属组织名称")
    private String orgName;
    @ApiModelProperty("报名ID")
    private Long enrollId;
    @ApiModelProperty("是否停止")
    private Integer isStop;
    @ApiModelProperty("编制人")
    private Long employeeId;
    @ApiModelProperty("编制人")
    private String employeeName;
    @ApiModelProperty("编制日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date billDate;
    @ApiModelProperty("编制机构")
    private Long makeOrgId;
    @ApiModelProperty("编制机构")
    private String makeOrgName;

    private String billStateName;
    //投标记录
    private List<RecordVO> records;

    private String orgCode; // 组织编码
    @ApiModelProperty("建造师")
    private Long builtConstructorId;

    @ReferSerialTransfer(referCode = "JzsInfo")
    public Long getBuiltConstructorId() {
        return builtConstructorId;
    }
    @ReferDeserialTransfer
    public void setBuiltConstructorId(Long builtConstructorId) {
        this.builtConstructorId = builtConstructorId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public List<RecordVO> getRecords() {
        return records;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public void setRecords(List<RecordVO> records) {
        this.records = records;
    }

    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 工程编码
     */
    public String getEngineeringCode() {
        return engineeringCode;
    }

    /**
     * 工程编码
     */
    public void setEngineeringCode(String engineeringCode) {
        this.engineeringCode = engineeringCode;
    }
    /**
     * 工程名称
     */
    public String getEngineeringName() {
        return engineeringName;
    }

    /**
     * 工程名称
     */
    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    /**
     * 工程名称
     */
    @ReferSerialTransfer(referCode = "bid-enroll")
    public Long getEngineeringId() {
        return engineeringId;
    }

    /**
     * 工程名称
     */
    @ReferDeserialTransfer
    public void setEngineeringId(Long engineeringId) {
        this.engineeringId = engineeringId;
    }
    /**
     * 预审日期
     */
    public java.util.Date getEstimatedExamineDate() {
        return estimatedExamineDate;
    }

    /**
     * 预审日期
     */
    public void setEstimatedExamineDate(java.util.Date estimatedExamineDate) {
        this.estimatedExamineDate = estimatedExamineDate;
    }
    /**
     * 预审结果 1通过 0未通过
     */
    public Integer getEstimatedExamineResult() {
        return estimatedExamineResult;
    }

    /**
     * 预审结果 1通过 0未通过
     */
    public void setEstimatedExamineResult(Integer estimatedExamineResult) {
        this.estimatedExamineResult = estimatedExamineResult;
    }
    /**
     * 预审结果
     */
    public String getEstimatedExamineResultName() {
        return estimatedExamineResultName;
    }
    /**
     * 预审结果
     */
    public void setEstimatedExamineResultName(String estimatedExamineResultName) {
        this.estimatedExamineResultName = estimatedExamineResultName;
    }

    /**
     *  未通过原因
     */
    public String getFailReason() {
        return failReason;
    }
    /**
     *  未通过原因
     */
    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }

    /**
     * 建造师
     */
    public String getBuiltConstructor() {
        return builtConstructor;
    }

    /**
     * 建造师
     */
    public void setBuiltConstructor(String builtConstructor) {
        this.builtConstructor = builtConstructor;
    }
    /**
     * 拟派技术负责人
     */
    public String getTechnicallyConscientiousPerson() {
        return technicallyConscientiousPerson;
    }

    /**
     * 拟派技术负责人
     */
    public void setTechnicallyConscientiousPerson(String technicallyConscientiousPerson) {
        this.technicallyConscientiousPerson = technicallyConscientiousPerson;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }
    /**
     * 所属组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 报名ID
     */
    public Long getEnrollId() {
        return enrollId;
    }

    /**
     * 报名ID
     */
    public void setEnrollId(Long enrollId) {
        this.enrollId = enrollId;
    }
    /**
     * 是否停止
     */
    public Integer getIsStop() {
        return isStop;
    }

    /**
     * 是否停止
     */
    public void setIsStop(Integer isStop) {
        this.isStop = isStop;
    }
    /**
     * 编制人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 编制日期
     */
    public java.util.Date getBillDate() {
        return billDate;
    }

    /**
     * 编制日期
     */
    public void setBillDate(java.util.Date billDate) {
        this.billDate = billDate;
    }
    /**
     * 编制机构
     */
    public Long getMakeOrgId() {
        return makeOrgId;
    }

    /**
     * 编制机构
     */
    public void setMakeOrgId(Long makeOrgId) {
        this.makeOrgId = makeOrgId;
    }
    /**
     * 编制机构
     */
    public String getMakeOrgName() {
        return makeOrgName;
    }

    /**
     * 编制机构
     */
    public void setMakeOrgName(String makeOrgName) {
        this.makeOrgName = makeOrgName;
    }

}
