package com.ejianc.business.bid.consts;

import java.util.HashMap;
import java.util.Map;

/**
 * 项目投标节点，相关单据类型枚举
 */
public enum BidBillTypeEnum {

    TOU_BIAO_BAO_MING("BT211115000000001", "项目评审"),
    ZI_GE_YU_SHEN("BT211115000000002", "资格预审"),
//    ZHAO_BIAO_WEN_JIAN_PING_SHEN("BT211117000000001", "招标文件评审"),
    TOU_BIAO_WEN_JIAN_PING_SHEN("BT211119000000002", "投标文件评审"),
    TOU_BIAO_ZONG_JIE("BT211116000000002", "投标文件总结");

    private String code;
    private String name;


    private static Map<String, String> enumMap;

    static {
        enumMap = new HashMap<>();
        enumMap.put(TOU_BIAO_BAO_MING.getCode(), TOU_BIAO_BAO_MING.getName());
        enumMap.put(ZI_GE_YU_SHEN.getCode(), ZI_GE_YU_SHEN.getName());
//        enumMap.put(ZHAO_BIAO_WEN_JIAN_PING_SHEN.getCode(), ZHAO_BIAO_WEN_JIAN_PING_SHEN.getName());
        enumMap.put(TOU_BIAO_WEN_JIAN_PING_SHEN.getCode(), TOU_BIAO_WEN_JIAN_PING_SHEN.getName());
        enumMap.put(TOU_BIAO_ZONG_JIE.getCode(), TOU_BIAO_ZONG_JIE.getName());
    }

    public static String getNameByCode(Integer code) {
        return enumMap.get(code);
    }

    BidBillTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }


    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
