package com.ejianc.business.bid.consts;


import java.util.HashMap;
import java.util.Map;

/**
 * @author songlx
 * @description: 投标阶段常量
 * @date: 2021/11/15
 */
public enum BidStageEnum {


    TOU_BIAO_XIN_XIN_GEN_ZONG(1, "信息跟踪"),
    TOU_BIAO_XIN_XIN_GEN_ZONG_TING_ZHI(2, "信息跟踪停止"),
    TOU_BIAO_BU_SHU(3, "投标部署"),
    TOU_BIAO_BAO_MING(4, "项目评审"),
    ZI_GE_YU_SHEN(5, "资格预审"),
//    ZHAO_BIAO_WEN_JIAN_PING_SHEN(5, "招标文件评审"),
    TOU_BIAO_WEN_JIAN_PING_SHEN(6, "投标文件评审"),
    TOU_BIAO_TING_ZHI_SHEN_QING(7, "投标停止"),
    //中标
    TOU_BIAO_ZONG_JIE_ZHONG_BIAO(8, "投标总结"),
    //未中标
    TOU_BIAO_ZONG_JIE_WEI_ZHONG_BIAO(9, "投标总结");

    private Integer code;
    private String name;

    private static Map<Integer, String> enumMap;

    static {
        enumMap = new HashMap<>();
        enumMap.put(TOU_BIAO_XIN_XIN_GEN_ZONG.getCode(), TOU_BIAO_XIN_XIN_GEN_ZONG.getName());
        enumMap.put(TOU_BIAO_XIN_XIN_GEN_ZONG_TING_ZHI.getCode(), TOU_BIAO_XIN_XIN_GEN_ZONG_TING_ZHI.getName());
        enumMap.put(TOU_BIAO_BAO_MING.getCode(), TOU_BIAO_BAO_MING.getName());
        enumMap.put(TOU_BIAO_TING_ZHI_SHEN_QING.getCode(), TOU_BIAO_TING_ZHI_SHEN_QING.getName());
        enumMap.put(ZI_GE_YU_SHEN.getCode(), ZI_GE_YU_SHEN.getName());
//        enumMap.put(ZHAO_BIAO_WEN_JIAN_PING_SHEN.getCode(), ZHAO_BIAO_WEN_JIAN_PING_SHEN.getName());
        enumMap.put(TOU_BIAO_WEN_JIAN_PING_SHEN.getCode(), TOU_BIAO_WEN_JIAN_PING_SHEN.getName());
        enumMap.put(TOU_BIAO_BU_SHU.getCode(), TOU_BIAO_BU_SHU.getName());
        enumMap.put(TOU_BIAO_ZONG_JIE_ZHONG_BIAO.getCode(), TOU_BIAO_ZONG_JIE_ZHONG_BIAO.getName());
        enumMap.put(TOU_BIAO_ZONG_JIE_WEI_ZHONG_BIAO.getCode(), TOU_BIAO_ZONG_JIE_WEI_ZHONG_BIAO.getName());
    }

    public static String getNameByCode(Integer code) {
        return enumMap.get(code);
    }


    BidStageEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }


}
